/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.delta;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.id.CDOWithID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.revision.CDOElementProxy;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevisable;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDeltaVisitor;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOOriginSizeProvider;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.common.util.PartialCollectionLoadingNotSupportedException;
import org.eclipse.emf.cdo.internal.common.revision.CDOListImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOAddFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOClearFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOContainerFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOListFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOMoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDORemoveFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOSetFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.CDOUnsetFeatureDeltaImpl;
import org.eclipse.emf.cdo.internal.common.revision.delta.ListComparisonHandler;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchAdjustable;
import org.eclipse.emf.cdo.spi.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ListChange;
import org.eclipse.emf.ecore.change.util.ListDifferenceAnalyzer;
import org.eclipse.net4j.util.Predicates;
import org.eclipse.net4j.util.om.OMPlatform;

public class CDORevisionDeltaImpl
implements InternalCDORevisionDelta,
ListComparisonHandler {
    private static final boolean WORK_AROUND_BUG_308618 = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.common.revision.delta.WORK_AROUND_BUG_308618");
    private EClass eClass;
    private CDOID id;
    private CDOBranch branch;
    private int version;
    private CDORevisable target;
    private Map<EStructuralFeature, CDOFeatureDelta> featureDeltas = new HashMap<EStructuralFeature, CDOFeatureDelta>();

    public CDORevisionDeltaImpl(CDORevision revision) {
        this.eClass = revision.getEClass();
        this.id = revision.getID();
        this.branch = revision.getBranch();
        this.version = revision.getVersion();
    }

    public CDORevisionDeltaImpl(CDORevisionDelta revisionDelta, boolean copyFeatureDeltas) {
        this.eClass = revisionDelta.getEClass();
        this.id = revisionDelta.getID();
        this.branch = revisionDelta.getBranch();
        this.version = revisionDelta.getVersion();
        if (copyFeatureDeltas) {
            for (CDOFeatureDelta delta : revisionDelta.getFeatureDeltas()) {
                CDOFeatureDelta copy = delta.copy();
                this.addFeatureDelta(copy, null);
            }
        }
    }

    public CDORevisionDeltaImpl(CDORevision sourceRevision, CDORevision targetRevision) {
        if (sourceRevision.getEClass() != targetRevision.getEClass()) {
            throw new IllegalArgumentException();
        }
        this.eClass = sourceRevision.getEClass();
        this.id = sourceRevision.getID();
        this.branch = sourceRevision.getBranch();
        this.version = sourceRevision.getVersion();
        this.target = CDORevisionUtil.copyRevisable(targetRevision);
        InternalCDORevision internalSourceRevision = (InternalCDORevision)sourceRevision;
        InternalCDORevision internalTargetRevision = (InternalCDORevision)targetRevision;
        this.compare(internalSourceRevision, internalTargetRevision);
        Object dirtyContainerID = internalTargetRevision.getContainerID();
        if (dirtyContainerID instanceof CDOWithID) {
            dirtyContainerID = ((CDOWithID)dirtyContainerID).cdoID();
        }
        CDOID dirtyResourceID = internalTargetRevision.getResourceID();
        int dirtyContainerFeatureID = internalTargetRevision.getContainerFeatureID();
        if (!(CDORevisionDeltaImpl.compareValue((EStructuralFeature)CDOContainerFeatureDelta.CONTAINER_FEATURE, internalSourceRevision.getContainerID(), dirtyContainerID) && CDORevisionDeltaImpl.compareValue(null, internalSourceRevision.getContainerFeatureID(), dirtyContainerFeatureID) && CDORevisionDeltaImpl.compareValue((EStructuralFeature)CDOContainerFeatureDelta.CONTAINER_FEATURE, internalSourceRevision.getResourceID(), dirtyResourceID))) {
            CDOContainerFeatureDeltaImpl delta = new CDOContainerFeatureDeltaImpl(dirtyResourceID, dirtyContainerID, dirtyContainerFeatureID);
            this.addFeatureDelta(delta, null);
        }
    }

    public CDORevisionDeltaImpl(CDODataInput in) throws IOException {
        this.eClass = (EClass)in.readCDOClassifierRefAndResolve();
        this.id = in.readCDOID();
        this.branch = in.readCDOBranch();
        this.version = in.readXInt();
        if (this.version < 0) {
            this.version = -this.version;
            this.target = in.readCDORevisable();
        }
        int size = in.readXInt();
        int i = 0;
        while (i < size) {
            CDOFeatureDelta featureDelta = in.readCDOFeatureDelta(this.eClass);
            this.featureDeltas.put(featureDelta.getFeature(), featureDelta);
            ++i;
        }
    }

    public void write(CDODataOutput out) throws IOException {
        out.writeCDOClassifierRef((EClassifier)this.eClass);
        out.writeCDOID(this.id);
        out.writeCDOBranch(this.branch);
        if (this.target == null) {
            out.writeXInt(this.version);
        } else {
            out.writeXInt(-this.version);
            out.writeCDORevisable(this.target);
        }
        out.writeXInt(this.featureDeltas.size());
        for (CDOFeatureDelta featureDelta : this.featureDeltas.values()) {
            out.writeCDOFeatureDelta(this.eClass, featureDelta);
        }
    }

    @Override
    public EClass getEClass() {
        return this.eClass;
    }

    @Override
    public CDOID getID() {
        return this.id;
    }

    @Override
    public CDOBranch getBranch() {
        return this.branch;
    }

    @Override
    public void setBranch(CDOBranch branch) {
        this.branch = branch;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public CDORevisable getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(CDORevisable target) {
        this.target = target;
    }

    @Override
    public int size() {
        return this.featureDeltas.size();
    }

    @Override
    public boolean isEmpty() {
        return this.featureDeltas.isEmpty();
    }

    @Override
    public CDORevisionDelta copy() {
        return new CDORevisionDeltaImpl(this, true);
    }

    @Override
    public Map<EStructuralFeature, CDOFeatureDelta> getFeatureDeltaMap() {
        return this.featureDeltas;
    }

    @Override
    public CDOFeatureDelta getFeatureDelta(EStructuralFeature feature) {
        return this.featureDeltas.get(feature);
    }

    @Override
    public List<CDOFeatureDelta> getFeatureDeltas() {
        return new ArrayList<CDOFeatureDelta>(this.featureDeltas.values());
    }

    @Override
    @Deprecated
    public void apply(CDORevision revision) {
        this.applyTo(revision);
    }

    @Override
    public void applyTo(CDORevision revision) {
        for (CDOFeatureDelta featureDelta : this.featureDeltas.values()) {
            featureDelta.applyTo(revision);
        }
    }

    @Override
    @Deprecated
    public void addFeatureDelta(CDOFeatureDelta delta) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addFeatureDelta(CDOFeatureDelta delta, CDOOriginSizeProvider originSizeProvider) {
        if (delta instanceof CDOListFeatureDelta) {
            CDOListFeatureDelta listDelta = (CDOListFeatureDelta)delta;
            for (CDOFeatureDelta listChange : listDelta.getListChanges()) {
                this.addSingleFeatureDelta(listChange, listDelta);
            }
        } else {
            this.addSingleFeatureDelta(delta, originSizeProvider);
        }
    }

    private void addSingleFeatureDelta(CDOFeatureDelta delta, CDOOriginSizeProvider originSizeProvider) {
        EStructuralFeature feature = delta.getFeature();
        if (feature.isMany()) {
            CDOListFeatureDeltaImpl listDelta = (CDOListFeatureDeltaImpl)this.featureDeltas.get(feature);
            if (listDelta == null) {
                int originSize = originSizeProvider.getOriginSize();
                listDelta = new CDOListFeatureDeltaImpl(feature, originSize);
                this.featureDeltas.put(feature, listDelta);
            }
            if (delta instanceof CDOClearFeatureDelta || delta instanceof CDOUnsetFeatureDelta) {
                listDelta.getListChanges().clear();
            }
            listDelta.add(delta);
        } else {
            CDOFeatureDelta oldDelta = this.featureDeltas.put(feature, delta);
            if (oldDelta instanceof CDOSetFeatureDelta && delta instanceof CDOSetFeatureDelta) {
                Object oldValue = ((CDOSetFeatureDelta)oldDelta).getOldValue();
                CDOSetFeatureDeltaImpl newDelta = (CDOSetFeatureDeltaImpl)delta;
                newDelta.setOldValue(oldValue);
            }
        }
    }

    @Override
    public boolean adjustReferences(CDOReferenceAdjuster referenceAdjuster) {
        boolean changed = false;
        for (CDOFeatureDelta featureDelta : this.featureDeltas.values()) {
            changed |= ((CDOFeatureDeltaImpl)featureDelta).adjustReferences(referenceAdjuster);
        }
        return changed;
    }

    @Override
    public void adjustBranches(CDOBranchManager newBranchManager) {
        if (this.branch != null) {
            this.branch = newBranchManager.getBranch(this.branch.getID());
        }
        if (this.target instanceof CDOBranchAdjustable) {
            ((CDOBranchAdjustable)((Object)this.target)).adjustBranches(newBranchManager);
        }
    }

    @Override
    public void accept(CDOFeatureDeltaVisitor visitor) {
        this.accept(visitor, (EStructuralFeature t) -> true);
    }

    @Override
    @Deprecated
    public void accept(CDOFeatureDeltaVisitor visitor, org.eclipse.net4j.util.Predicate<EStructuralFeature> filter) {
        this.accept(visitor, Predicates.toJava8(filter));
    }

    @Override
    public void accept(CDOFeatureDeltaVisitor visitor, Predicate<EStructuralFeature> filter) {
        for (CDOFeatureDelta featureDelta : this.featureDeltas.values()) {
            EStructuralFeature feature = featureDelta.getFeature();
            if (!filter.test(feature)) continue;
            featureDelta.accept(visitor);
        }
    }

    @Override
    public void addDelta(CDOListFeatureDelta listFeatureDelta) {
        this.featureDeltas.put(listFeatureDelta.getFeature(), listFeatureDelta);
    }

    @Override
    public void addClearDelta(CDOClearFeatureDelta clearFeatureDelta, CDOOriginSizeProvider originSizeProvider) {
        this.addFeatureDelta(clearFeatureDelta, originSizeProvider);
    }

    private void compare(InternalCDORevision originRevision, InternalCDORevision dirtyRevision) {
        EStructuralFeature[] eStructuralFeatureArray = originRevision.getClassInfo().getAllPersistentFeatures();
        int n = eStructuralFeatureArray.length;
        int n2 = 0;
        while (n2 < n) {
            EStructuralFeature feature = eStructuralFeatureArray[n2];
            if (feature.isMany()) {
                CDORevisionDeltaImpl.compareLists(originRevision, dirtyRevision, feature, this);
            } else {
                Object dirtyValue;
                Object originValue = originRevision.get(feature, 0);
                if (!CDORevisionDeltaImpl.compareValue(feature, originValue, dirtyValue = dirtyRevision.get(feature, 0))) {
                    CDOFeatureDeltaImpl delta;
                    if (dirtyValue == null) {
                        delta = new CDOUnsetFeatureDeltaImpl(feature);
                        this.addFeatureDelta(delta, null);
                    } else {
                        delta = new CDOSetFeatureDeltaImpl(feature, 0, dirtyValue, originValue);
                        this.addFeatureDelta(delta, null);
                    }
                }
            }
            ++n2;
        }
    }

    private static boolean compareValue(EStructuralFeature feature, Object originValue, Object dirtyValue) {
        if (feature != null) {
            if (feature instanceof EReference) {
                originValue = CDORevisionDeltaImpl.convertEObject(originValue);
                dirtyValue = CDORevisionDeltaImpl.convertEObject(dirtyValue);
            } else {
                Object defaultValue = feature.getDefaultValue();
                if (defaultValue != null) {
                    originValue = CDORevisionDeltaImpl.convertDefaultValue(originValue, defaultValue);
                    dirtyValue = CDORevisionDeltaImpl.convertDefaultValue(dirtyValue, defaultValue);
                }
            }
        }
        if (originValue == null) {
            return dirtyValue == null;
        }
        if (dirtyValue == null) {
            return false;
        }
        if (originValue == dirtyValue) {
            return true;
        }
        if (originValue instanceof CDOID) {
            return false;
        }
        return originValue.equals(dirtyValue);
    }

    private static Object convertEObject(Object value) {
        CDOID id = CDOIDUtil.getCDOID(value);
        if (id != null) {
            return id;
        }
        return value;
    }

    private static Object convertDefaultValue(Object value, Object defaultValue) {
        return value;
    }

    private static void compareLists(final InternalCDORevision originRevision, final InternalCDORevision dirtyRevision, final EStructuralFeature feature, ListComparisonHandler handler) {
        final int originSize = originRevision.size(feature);
        if (originSize > 0 && dirtyRevision.size(feature) == 0) {
            handler.addClearDelta(new CDOClearFeatureDeltaImpl(feature), new CDOOriginSizeProvider(){

                @Override
                public int getOriginSize() {
                    return originSize;
                }
            });
        } else {
            CDOList dirtyList;
            CDOListFeatureDeltaImpl listFeatureDelta = new CDOListFeatureDeltaImpl(feature, originSize);
            final List<CDOFeatureDelta> changes = listFeatureDelta.getListChanges();
            ListDifferenceAnalyzer analyzer = new ListDifferenceAnalyzer(){

                public void analyzeLists(EList<Object> oldList, EList<?> newList, EList<ListChange> listChanges) {
                    this.checkNoProxies(oldList, originRevision);
                    this.checkNoProxies(newList, dirtyRevision);
                    super.analyzeLists(oldList, newList, listChanges);
                }

                protected void createAddListChange(EList<Object> oldList, EList<ListChange> listChanges, Object value, int index) {
                    CDOAddFeatureDeltaImpl delta = new CDOAddFeatureDeltaImpl(feature, index, value);
                    changes.add(delta);
                    oldList.add(index, value);
                }

                protected void createRemoveListChange(EList<?> oldList, EList<ListChange> listChanges, Object value, int index) {
                    CDORemoveFeatureDeltaImpl delta = new CDORemoveFeatureDeltaImpl(feature, index);
                    if (WORK_AROUND_BUG_308618) {
                        delta.setValue(oldList.get(index));
                    } else {
                        delta.setValue(value);
                    }
                    changes.add(delta);
                    oldList.remove(index);
                }

                protected void createMoveListChange(EList<?> oldList, EList<ListChange> listChanges, Object value, int index, int toIndex) {
                    CDOMoveFeatureDeltaImpl delta = new CDOMoveFeatureDeltaImpl(feature, toIndex, index);
                    if (WORK_AROUND_BUG_308618) {
                        delta.setValue(oldList.get(index));
                    } else {
                        delta.setValue(value);
                    }
                    changes.add(delta);
                    oldList.move(toIndex, index);
                }

                protected boolean equal(Object originValue, Object dirtyValue) {
                    return CDORevisionDeltaImpl.compareValue(feature, originValue, dirtyValue);
                }

                private void checkNoProxies(EList<?> list, CDORevision revision) {
                    if (list != null && !((InternalCDORevision)revision).isUnchunked()) {
                        for (Object element : list) {
                            if (!(element instanceof CDOElementProxy) && element != CDOListImpl.UNINITIALIZED) continue;
                            throw new PartialCollectionLoadingNotSupportedException("List contains proxy elements");
                        }
                    }
                }
            };
            CDOList originList = originRevision.getListOrNull(feature);
            if (originList == null) {
                originList = new CDOListImpl(0, 0);
            }
            if ((dirtyList = dirtyRevision.getListOrNull(feature)) == null) {
                dirtyList = new CDOListImpl(0, 0);
            }
            analyzer.analyzeLists((EList)originList, (EList)dirtyList, (EList)new NOOPList());
            if (!changes.isEmpty()) {
                handler.addDelta(listFeatureDelta);
            }
        }
    }

    public static CDOListFeatureDelta compareLists(final InternalCDORevision originRevision, InternalCDORevision dirtyRevision, final EStructuralFeature feature) {
        final CDOListFeatureDelta[] result = new CDOListFeatureDelta[1];
        CDORevisionDeltaImpl.compareLists(originRevision, dirtyRevision, feature, new ListComparisonHandler(){

            @Override
            public void addDelta(CDOListFeatureDelta listFeatureDelta) {
                result[0] = listFeatureDelta;
            }

            @Override
            public void addClearDelta(CDOClearFeatureDelta clearFeatureDelta, CDOOriginSizeProvider originSizeProvider) {
                CDOListFeatureDeltaImpl listFeatureDelta = new CDOListFeatureDeltaImpl(feature, originRevision.size(feature));
                listFeatureDelta.add(clearFeatureDelta);
                result[0] = listFeatureDelta;
            }
        });
        return result[0];
    }

    public String toString() {
        return MessageFormat.format("CDORevisionDelta[{0}@{1}:{2}v{3} --> {4}]", this.eClass.getName(), this.id, this.branch.getID(), this.version, this.featureDeltas.values());
    }

    public static class NOOPList
    implements EList<ListChange> {
        private static final EList<ListChange> LIST = ECollections.emptyEList();

        public int size() {
            return 0;
        }

        public boolean isEmpty() {
            return true;
        }

        public boolean contains(Object o) {
            return false;
        }

        public Iterator<ListChange> iterator() {
            return LIST.iterator();
        }

        public Object[] toArray() {
            return LIST.toArray();
        }

        public <T> T[] toArray(T[] a) {
            return LIST.toArray((Object[])a);
        }

        public boolean add(ListChange o) {
            return false;
        }

        public boolean remove(Object o) {
            return false;
        }

        public boolean containsAll(Collection<?> c) {
            return false;
        }

        public boolean addAll(Collection<? extends ListChange> c) {
            return false;
        }

        public boolean addAll(int index, Collection<? extends ListChange> c) {
            return false;
        }

        public boolean removeAll(Collection<?> c) {
            return false;
        }

        public boolean retainAll(Collection<?> c) {
            return false;
        }

        public void clear() {
        }

        public ListChange get(int index) {
            return (ListChange)LIST.get(index);
        }

        public ListChange set(int index, ListChange element) {
            return null;
        }

        public void add(int index, ListChange element) {
        }

        public ListChange remove(int index) {
            return null;
        }

        public int indexOf(Object o) {
            return LIST.indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return LIST.lastIndexOf(o);
        }

        public ListIterator<ListChange> listIterator() {
            return LIST.listIterator();
        }

        public ListIterator<ListChange> listIterator(int index) {
            return LIST.listIterator(index);
        }

        public List<ListChange> subList(int fromIndex, int toIndex) {
            return LIST.subList(fromIndex, toIndex);
        }

        public void move(int newPosition, ListChange object) {
        }

        public ListChange move(int newPosition, int oldPosition) {
            return null;
        }
    }
}

