/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.net4j.util.ui.ManagedLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableLabelProvider<T>
extends ManagedLabelProvider
implements ITableLabelProvider,
ITableColorProvider,
ITableFontProvider {
    private final List<Column<T>> columns = new ArrayList<Column<T>>();
    private boolean headerVisible = true;
    private boolean linesVisible;

    public TableLabelProvider<T> addColumn(Column<T> column) {
        this.columns.add(column);
        return this;
    }

    public boolean isHeaderVisible() {
        return this.headerVisible;
    }

    public TableLabelProvider<T> setHeaderVisible(boolean headerVisible) {
        this.headerVisible = headerVisible;
        return this;
    }

    public boolean isLinesVisible() {
        return this.linesVisible;
    }

    public TableLabelProvider<T> setLinesVisible(boolean linesVisible) {
        this.linesVisible = linesVisible;
        return this;
    }

    public Column<T> removeColumn(int columnIndex) {
        return this.columns.remove(columnIndex);
    }

    public Column<T> getColumn(int columnIndex) {
        return this.columns.get(columnIndex);
    }

    public String getColumnText(Object element, int columnIndex) {
        Object t = element;
        String text = this.getColumn(columnIndex).getText(t);
        if (text == null) {
            return "";
        }
        return text;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Object t = element;
        return this.getColumn(columnIndex).getImage(t);
    }

    public Color getForeground(Object element, int columnIndex) {
        Object t = element;
        return this.getColumn(columnIndex).getForeground(t);
    }

    public Color getBackground(Object element, int columnIndex) {
        Object t = element;
        return this.getColumn(columnIndex).getBackground(t);
    }

    public Font getFont(Object element, int columnIndex) {
        Object t = element;
        return this.getColumn(columnIndex).getFont(t);
    }

    public TableLabelProvider<T> support(TableViewer tableViewer) {
        for (Column<T> column : this.columns) {
            TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tableColumn.setText(column.getHeader());
            tableColumn.setToolTipText(column.getToolTipText());
            tableColumn.setWidth(column.getWidth());
            tableColumn.setAlignment(column.getAlignment());
            tableColumn.setImage(column.getImage());
            tableColumn.setMoveable(column.isMoveable());
            tableColumn.setResizable(column.isResizable());
        }
        Table table = tableViewer.getTable();
        table.setHeaderVisible(this.headerVisible);
        table.setLinesVisible(this.linesVisible);
        tableViewer.setLabelProvider((IBaseLabelProvider)this);
        return this;
    }

    public static class Column<T> {
        public static final int DEFAULT_WIDTH = 100;
        private String header = "";
        private String toolTipText = "";
        private int width = 100;
        private int alignment = 16384;
        private Image image;
        private boolean moveable;
        private boolean resizable = true;

        public Column() {
        }

        public Column(String header) {
            this.header = header;
        }

        public Column(String header, int width) {
            this.header = header;
            this.width = width;
        }

        public Column(String header, int width, int alignment) {
            this.header = header;
            this.width = width;
            this.alignment = alignment;
        }

        public String getHeader() {
            return this.header;
        }

        public Column<T> setHeader(String header) {
            this.header = header;
            return this;
        }

        public String getToolTipText() {
            return this.toolTipText;
        }

        public Column<T> setToolTipText(String toolTipText) {
            this.toolTipText = toolTipText;
            return this;
        }

        public int getWidth() {
            return this.width;
        }

        public Column<T> setWidth(int width) {
            this.width = width;
            return this;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public Column<T> setAlignment(int alignment) {
            this.alignment = alignment;
            return this;
        }

        public Image getImage() {
            return this.image;
        }

        public Column<T> setImage(Image image) {
            this.image = image;
            return this;
        }

        public boolean isMoveable() {
            return this.moveable;
        }

        public Column<T> setMoveable(boolean moveable) {
            this.moveable = moveable;
            return this;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public Column<T> setResizable(boolean resizable) {
            this.resizable = resizable;
            return this;
        }

        public String getText(T element) {
            if (element == null) {
                return "";
            }
            return element.toString();
        }

        public Image getImage(T element) {
            return null;
        }

        public Color getForeground(T element) {
            return null;
        }

        public Color getBackground(T element) {
            return null;
        }

        public Font getFont(T element) {
            return null;
        }
    }
}

