/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.explorer.ui.checkouts.workingsets;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.explorer.ui.bundle.OM;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutContentProvider;
import org.eclipse.emf.cdo.explorer.ui.checkouts.CDOCheckoutLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetPage;

public class CheckoutWorkingSetWizardPage
extends WizardPage
implements IWorkingSetPage {
    public static final String WORKING_SET_ID = "org.eclipse.emf.cdo.explorer.ui.CheckoutWorkingSet";
    private static final String PAGE_NAME = "cdoCheckoutWorkingSetPage";
    private static final String PAGE_TITLE = "CDO Checkout Working Set";
    private final Set<Object> selectedElements = new HashSet<Object>();
    private IStructuredSelection initialSelection;
    private Text nameText;
    private TreeViewer treeViewer;
    private TableViewer tableViewer;
    private boolean firstCheck = true;
    private IWorkingSet workingSet;

    public CheckoutWorkingSetWizardPage() {
        super(PAGE_NAME, PAGE_TITLE, OM.getImageDescriptor("icons/wiz/new_checkout.gif"));
        ISelection selection;
        this.setDescription("Enter a working set name and select the working set elements.");
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (selection = activeWorkbenchWindow.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            this.initialSelection = (IStructuredSelection)selection;
        }
    }

    private Object[] getInitialWorkingSetElements(IWorkingSet workingSet) {
        Object[] elements;
        if (workingSet == null) {
            if (this.initialSelection == null) {
                return new IAdaptable[0];
            }
            elements = this.initialSelection.toArray();
        } else {
            elements = workingSet.getElements();
        }
        LinkedHashSet<CDOCheckout> result = new LinkedHashSet<CDOCheckout>();
        int i = 0;
        while (i < elements.length) {
            IAdaptable element = elements[i];
            CDOCheckout checkout = CDOExplorerUtil.getCheckout((Object)element);
            if (checkout != null) {
                result.add(checkout);
            }
            ++i;
        }
        return result.toArray();
    }

    private Object[] getInitialTreeSelection() {
        Object[][] result = new Object[1][];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> {
            IStructuredSelection selection = this.initialSelection;
            if (selection == null) {
                IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
                if (part == null) {
                    return;
                }
                selection = CheckoutWorkingSetWizardPage.getStructuredSelection(part);
            }
            Object[] elements = selection.toArray();
            int i = 0;
            while (i < elements.length) {
                elements[i] = CDOExplorerUtil.getCheckout((Object)elements[i]);
                ++i;
            }
            objectArray[0] = elements;
        });
        if (result[0] == null) {
            return new Object[0];
        }
        return result[0];
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        Label label = new Label(composite, 64);
        label.setText("&Working set name:");
        GridData gd = new GridData(772);
        label.setLayoutData((Object)gd);
        this.nameText = new Text(composite, 2052);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(e -> this.validateInput());
        Composite leftCenterRightComposite = new Composite(composite, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.convertHeightInCharsToPixels(20);
        leftCenterRightComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        leftCenterRightComposite.setLayout((Layout)gridLayout);
        Composite leftComposite = new Composite(leftCenterRightComposite, 0);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        leftComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        leftComposite.setLayout((Layout)gridLayout);
        Composite centerComposite = new Composite(leftCenterRightComposite, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        centerComposite.setLayout((Layout)gridLayout);
        centerComposite.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        Composite rightComposite = new Composite(leftCenterRightComposite, 0);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        rightComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        rightComposite.setLayout((Layout)gridLayout);
        this.createTree(leftComposite);
        this.createTable(rightComposite);
        if (this.workingSet != null) {
            this.nameText.setText(this.workingSet.getName());
        }
        this.initializeSelectedElements();
        this.validateInput();
        this.tableViewer.setInput(this.selectedElements);
        this.tableViewer.refresh(true);
        this.treeViewer.refresh(true);
        this.createButtonBar(centerComposite);
        this.nameText.setFocus();
        this.nameText.setSelection(0, this.nameText.getText().length());
        Dialog.applyDialogFont((Control)composite);
    }

    private void createTree(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        label.setText("A&vailable checkouts:");
        this.treeViewer = CDOCheckoutContentProvider.createTreeViewer(parent, 2818, e -> e instanceof CDOCheckout);
        this.treeViewer.addFilter((ViewerFilter)new AddedElementsFilter());
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.getSelection() == null) {
            return;
        }
        Object[] selection = this.getInitialTreeSelection();
        if (selection.length > 0) {
            try {
                tree.setRedraw(false);
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object s = objectArray[n2];
                    this.treeViewer.expandToLevel(s, 0);
                    ++n2;
                }
                this.treeViewer.setSelection((ISelection)new StructuredSelection(selection));
            }
            finally {
                tree.setRedraw(true);
            }
        }
    }

    private void createTable(Composite parent) {
        Label label = new Label(parent, 64);
        label.setText("Working set &content:");
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        CDOCheckoutContentProvider contentProvider = new CDOCheckoutContentProvider();
        contentProvider.disposeWith((Control)parent);
        this.tableViewer = new TableViewer(parent, 2818);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new CDOCheckoutLabelProvider(contentProvider));
        this.tableViewer.setInput(this.selectedElements);
        Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    private void createButtonBar(Composite parent) {
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(4, 128, true, false));
        Button addButton = new Button(parent, 8);
        addButton.setLayoutData((Object)new GridData(4, 128, true, false));
        addButton.setText("&Add ->");
        addButton.setEnabled(!this.treeViewer.getSelection().isEmpty());
        final Button addAllButton = new Button(parent, 8);
        addAllButton.setLayoutData((Object)new GridData(4, 128, true, false));
        addAllButton.setText("A&dd All ->");
        addAllButton.setEnabled(this.treeViewer.getTree().getItems().length > 0);
        Button removeButton = new Button(parent, 8);
        removeButton.setLayoutData((Object)new GridData(4, 128, true, false));
        removeButton.setText("<- &Remove");
        removeButton.setEnabled(!this.tableViewer.getSelection().isEmpty());
        final Button removeAllButton = new Button(parent, 8);
        removeAllButton.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        removeAllButton.setText("<- R&emove All");
        removeAllButton.setEnabled(!this.selectedElements.isEmpty());
        this.treeViewer.addSelectionChangedListener(event -> addButton.setEnabled(!event.getSelection().isEmpty()));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutWorkingSetWizardPage.this.addTreeSelection();
                removeAllButton.setEnabled(true);
                addAllButton.setEnabled(CheckoutWorkingSetWizardPage.this.treeViewer.getTree().getItems().length > 0);
            }
        });
        this.treeViewer.addDoubleClickListener(event -> {
            this.addTreeSelection();
            removeAllButton.setEnabled(true);
            addAllButton.setEnabled(this.treeViewer.getTree().getItems().length > 0);
        });
        this.tableViewer.addSelectionChangedListener(event -> removeButton.setEnabled(!event.getSelection().isEmpty()));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutWorkingSetWizardPage.this.removeTableSelection();
                addAllButton.setEnabled(true);
                removeAllButton.setEnabled(!CheckoutWorkingSetWizardPage.this.selectedElements.isEmpty());
            }
        });
        this.tableViewer.addDoubleClickListener(event -> {
            this.removeTableSelection();
            addAllButton.setEnabled(true);
            removeAllButton.setEnabled(!this.selectedElements.isEmpty());
        });
        addAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem[] treeItemArray = CheckoutWorkingSetWizardPage.this.treeViewer.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    CheckoutWorkingSetWizardPage.this.selectedElements.add(item.getData());
                    ++n2;
                }
                CheckoutWorkingSetWizardPage.this.tableViewer.refresh();
                CheckoutWorkingSetWizardPage.this.treeViewer.refresh();
                addAllButton.setEnabled(false);
                removeAllButton.setEnabled(true);
            }
        });
        removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutWorkingSetWizardPage.this.selectedElements.clear();
                CheckoutWorkingSetWizardPage.this.tableViewer.refresh();
                CheckoutWorkingSetWizardPage.this.treeViewer.refresh();
                removeAllButton.setEnabled(false);
                addAllButton.setEnabled(true);
            }
        });
    }

    private void addTreeSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        this.selectedElements.addAll(selection.toList());
        Object[] selectedElements = selection.toArray();
        this.tableViewer.add(selectedElements);
        this.treeViewer.remove(selectedElements);
        this.tableViewer.setSelection((ISelection)selection);
        this.tableViewer.getControl().setFocus();
        this.validateInput();
    }

    private void removeTableSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        this.selectedElements.removeAll(selection.toList());
        Object[] selectedElements = selection.toArray();
        this.tableViewer.remove(selectedElements);
        try {
            this.treeViewer.getTree().setRedraw(false);
            ITreeContentProvider contentProvider = (ITreeContentProvider)this.treeViewer.getContentProvider();
            Object[] objectArray = selectedElements;
            int n = selectedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedElement = objectArray[n2];
                this.treeViewer.refresh(contentProvider.getParent(selectedElement), true);
                ++n2;
            }
        }
        finally {
            this.treeViewer.getTree().setRedraw(true);
        }
        this.treeViewer.setSelection((ISelection)selection);
        this.treeViewer.getControl().setFocus();
        this.validateInput();
    }

    public IWorkingSet getSelection() {
        return this.workingSet;
    }

    public void setSelection(IWorkingSet workingSet) {
        Assert.isNotNull((Object)workingSet, (String)"Working set must not be null");
        this.workingSet = workingSet;
        if (this.getContainer() != null && this.getShell() != null && this.nameText != null) {
            this.firstCheck = false;
            this.nameText.setText(workingSet.getName());
            this.initializeSelectedElements();
            this.validateInput();
        }
    }

    public void finish() {
        String workingSetName = this.nameText.getText();
        Set<Object> elements = this.selectedElements;
        if (this.workingSet == null) {
            IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            this.workingSet = workingSetManager.createWorkingSet(workingSetName, elements.toArray(new IAdaptable[elements.size()]));
            this.workingSet.setId(WORKING_SET_ID);
        }
        this.workingSet.setName(workingSetName);
        this.workingSet.setElements(elements.toArray(new IAdaptable[elements.size()]));
    }

    private void validateInput() {
        String errorMessage = null;
        String infoMessage = null;
        String newText = this.nameText.getText();
        if (!newText.equals(newText.trim())) {
            errorMessage = "The name must not have leading or trailing whitespace.";
        }
        if (newText.isEmpty()) {
            if (this.firstCheck) {
                this.setPageComplete(false);
                this.firstCheck = false;
                return;
            }
            errorMessage = "The name must not be empty.";
        }
        this.firstCheck = false;
        if (!(errorMessage != null || this.workingSet != null && newText.equals(this.workingSet.getName()))) {
            IWorkingSet[] iWorkingSetArray = PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets();
            int n = iWorkingSetArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkingSet workingSet = iWorkingSetArray[n2];
                if (newText.equals(workingSet.getName())) {
                    errorMessage = "A working set with that name already exists.";
                }
                ++n2;
            }
        }
        if (!this.hasSelectedElement()) {
            infoMessage = "No checkouts selected.";
        }
        this.setMessage(infoMessage, 1);
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    private boolean hasSelectedElement() {
        return !this.selectedElements.isEmpty();
    }

    private void initializeSelectedElements() {
        this.selectedElements.addAll(Arrays.asList(this.getInitialWorkingSetElements(this.workingSet)));
    }

    private static IStructuredSelection getStructuredSelection(IWorkbenchPart part) {
        ISelection selection;
        ISelectionProvider provider = part.getSite().getSelectionProvider();
        if (provider != null && (selection = provider.getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    private final class AddedElementsFilter
    extends ViewerFilter {
        private AddedElementsFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !CheckoutWorkingSetWizardPage.this.selectedElements.contains(element);
        }
    }
}

