/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.tests;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.io.SortedFileMap;
import org.eclipse.net4j.util.tests.AbstractOMTest;

public class SortedFileMapTest
extends AbstractOMTest {
    public void testMap() throws Exception {
        File file = this.createTempFile("testMap-", ".dat");
        if (file.exists()) {
            file.delete();
        }
        TestMap map = null;
        try {
            map = new TestMap(file);
            int i = 0;
            while (i < 500) {
                map.put(Integer.valueOf(i), "Value " + i);
                ++i;
            }
            i = 0;
            while (i < 500) {
                String value = (String)map.get(Integer.valueOf(i));
                IOUtil.OUT().println(value);
                ++i;
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(map);
            throw throwable;
        }
        IOUtil.close((Closeable)((Object)map));
    }

    public static final class TestMap
    extends SortedFileMap<Integer, String> {
        public TestMap(File file) {
            super(file, "rw");
        }

        public int getKeySize() {
            return 4;
        }

        protected Integer readKey(ExtendedDataInput in) throws IOException {
            return in.readInt();
        }

        protected void writeKey(ExtendedDataOutput out, Integer key) throws IOException {
            out.writeInt(key.intValue());
        }

        public int getValueSize() {
            return 20;
        }

        protected String readValue(ExtendedDataInput in) throws IOException {
            return in.readString();
        }

        protected void writeValue(ExtendedDataOutput out, String value) throws IOException {
            byte[] bytes = value.getBytes();
            if (bytes.length + 4 > this.getValueSize()) {
                throw new IllegalArgumentException("Value size of " + this.getValueSize() + " exceeded: " + value);
            }
            out.writeByteArray(bytes);
        }
    }
}

