/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.util.Hashtable;
import org.apache.derby.impl.drda.DDMWriter;
import org.apache.derby.impl.drda.DRDAConnThread;
import org.apache.derby.impl.drda.DRDAProtocolExceptionInfo;
import org.apache.derby.impl.drda.NetworkServerControlImpl;

class DRDAProtocolException
extends Exception {
    protected static final int NO_ASSOC_ERRCD = 0;
    protected static final int NO_CODPNT_ARG = 0;
    private DRDAConnThread agent;
    private int correlationID;
    private byte[] crrtkn;
    private int codpntArg;
    private DRDAProtocolExceptionInfo exceptionInfo;
    private int errorCodePoint;
    private int svrcod;
    private int errcd;
    private String messageid;
    private String rdbnam;
    private String srvdgn;
    private Object[] messageArgs;
    private String msg;
    private static Hashtable<String, DRDAProtocolExceptionInfo> errorInfoTable;
    protected static String DRDA_Proto_CMDCHKRM;
    protected static String DRDA_Proto_CMDNSPRM;
    protected static String DRDA_Proto_DTAMCHRM;
    protected static String DRDA_Proto_OBJNSPRM;
    protected static String DRDA_Proto_PKGBNARM;
    protected static String DRDA_Proto_PRCCNVRM;
    protected static String DRDA_Proto_PRMNSRM;
    protected static String DRDA_Proto_SYNTAXRM;
    protected static String DRDA_Proto_VALNSPRM;
    protected static String DRDA_Proto_MGRLVLRM;
    protected static String DRDA_Proto_RDBNFNRM;
    protected static String DRDA_Disconnect;
    protected static String DRDA_AgentError;
    protected static String DRDA_Timeout;
    protected static String DRDA_InvalidClient;

    DRDAProtocolException(String msgid, DRDAConnThread agent, int cpArg, int errCdArg, Object[] args) {
        boolean agentError = false;
        this.exceptionInfo = errorInfoTable.get(msgid);
        if (agent != null) {
            this.correlationID = agent.getCorrelationID();
            this.crrtkn = agent.getCrrtkn();
        }
        this.codpntArg = cpArg;
        this.errorCodePoint = this.exceptionInfo.errorCodePoint;
        this.errcd = errCdArg;
        this.messageid = msgid;
        if (msgid.equals(DRDA_AgentError)) {
            this.svrcod = (Integer)args[0];
            this.rdbnam = (String)args[1];
            String srvdgn = (String)args[2];
            this.msg = "Execution failed because of Permanent Agent Error: SVRCOD = " + Integer.toHexString(this.svrcod) + "; RDBNAM = " + this.rdbnam + "; diagnostic msg = " + srvdgn;
            agentError = true;
        } else if (msgid.equals(DRDA_Proto_RDBNFNRM)) {
            this.svrcod = this.exceptionInfo.svrcod;
            this.rdbnam = (String)args[0];
            this.msg = "Execution failed because of Distributed Protocol Error:  " + this.messageid + "; RDBNAM = " + this.rdbnam;
        } else {
            this.svrcod = this.exceptionInfo.svrcod;
            this.msg = "Execution failed because of a Distributed Protocol Error:  " + this.messageid + "; CODPNT arg  = " + Integer.toHexString(cpArg) + "; Error Code Value = " + Integer.toHexString(errCdArg);
            if (msgid.equals(DRDA_Proto_SYNTAXRM)) {
                this.msg = this.msg + ". Plaintext connection attempt from an SSL enabled client?";
            }
        }
        if (!agentError && args != null) {
            this.messageArgs = args;
            for (int i = 0; i < args.length; ++i) {
                this.msg = msgid.equals(DRDA_Proto_MGRLVLRM) ? this.msg + "," + Integer.toHexString((Integer)args[i]) : this.msg + "," + args[i];
            }
        }
        if (!this.isDisconnectException()) {
            DRDAConnThread.println2Log(agent.getDbName(), agent.getSession().drdaID, this.msg);
            NetworkServerControlImpl s = agent.getServer();
            s.consoleExceptionPrintTrace(this);
        }
    }

    DRDAProtocolException(String msgid, DRDAConnThread agent, int cpArg, int errCdArg) {
        this(msgid, agent, cpArg, errCdArg, null);
    }

    protected static DRDAProtocolException newDisconnectException(DRDAConnThread agent, Object[] args) {
        return new DRDAProtocolException(DRDA_Disconnect, agent, 0, 0, args);
    }

    protected static DRDAProtocolException newAgentError(DRDAConnThread agent, int svrcod, String rdbnam, String srvdgn) {
        agent.trace("agentError in " + agent);
        Object[] oa = new Object[]{svrcod, rdbnam, srvdgn};
        return new DRDAProtocolException(DRDA_AgentError, agent, 0, 0, oa);
    }

    protected final boolean isDisconnectException() {
        return this.errorCodePoint == 0;
    }

    protected void write(DDMWriter writer) {
        writer.createDssReply();
        writer.startDdm(this.errorCodePoint);
        writer.writeScalar2Bytes(4425, this.svrcod);
        if (this.exceptionInfo.sendsCodpntArg) {
            writer.writeScalar2Bytes(12, this.codpntArg);
        }
        if (this.exceptionInfo.errCdCodePoint != 0) {
            writer.writeScalar1Byte(this.exceptionInfo.errCdCodePoint, this.errcd);
        }
        if (this.rdbnam != null && this.agent != null) {
            try {
                this.agent.writeRDBNAM(this.rdbnam);
            }
            catch (DRDAProtocolException dRDAProtocolException) {
                // empty catch block
            }
        }
        if (this.errorCodePoint == 4624) {
            writer.startDdm(5124);
            for (int i = 0; i < this.messageArgs.length; i += 2) {
                writer.writeNetworkShort((Integer)this.messageArgs[i]);
                writer.writeNetworkShort((Integer)this.messageArgs[i + 1]);
            }
            writer.endDdm();
        }
        writer.endDdmAndDss();
    }

    @Override
    public String getMessage() {
        return this.msg;
    }

    static {
        DRDA_Proto_CMDCHKRM = "DRDA_Proto_CMDCHKRM";
        DRDA_Proto_CMDNSPRM = "DRDA_Proto_CMDNSPRM";
        DRDA_Proto_DTAMCHRM = "DRDA_Proto_DTAMCHRM";
        DRDA_Proto_OBJNSPRM = "DRDA_Proto_OBJNSPRM";
        DRDA_Proto_PKGBNARM = "DRDA_Proto_PKGBNARM";
        DRDA_Proto_PRCCNVRM = "DRDA_Proto_PRCCNVRM";
        DRDA_Proto_PRMNSRM = "DRDA_Proto_PRMNSPRM";
        DRDA_Proto_SYNTAXRM = "DRDA_Proto_SYNTAXRM";
        DRDA_Proto_VALNSPRM = "DRDA_Proto_VALNSPRM";
        DRDA_Proto_MGRLVLRM = "DRDA_Proto_MGRLVLRM";
        DRDA_Proto_RDBNFNRM = "DRDA_Proto_RDBNFNRM";
        DRDA_Disconnect = "DRDA_Disconnect";
        DRDA_AgentError = "DRDA_AgentError";
        DRDA_Timeout = "DRDA_Timeout";
        DRDA_InvalidClient = "DRDA_InvalidClient";
        errorInfoTable = new Hashtable();
        errorInfoTable.put(DRDA_Proto_CMDCHKRM, new DRDAProtocolExceptionInfo(4692, 8, 0, false));
        errorInfoTable.put(DRDA_Proto_CMDNSPRM, new DRDAProtocolExceptionInfo(4688, 8, 0, true));
        errorInfoTable.put(DRDA_Proto_DTAMCHRM, new DRDAProtocolExceptionInfo(8718, 8, 0, false));
        errorInfoTable.put(DRDA_Proto_OBJNSPRM, new DRDAProtocolExceptionInfo(4691, 8, 0, true));
        errorInfoTable.put(DRDA_Proto_PKGBNARM, new DRDAProtocolExceptionInfo(8710, 8, 0, false));
        errorInfoTable.put(DRDA_Proto_PRCCNVRM, new DRDAProtocolExceptionInfo(4677, 8, 4415, false));
        errorInfoTable.put(DRDA_Proto_SYNTAXRM, new DRDAProtocolExceptionInfo(4684, 8, 4426, true));
        errorInfoTable.put(DRDA_Proto_VALNSPRM, new DRDAProtocolExceptionInfo(4690, 8, 0, true));
        errorInfoTable.put(DRDA_Proto_MGRLVLRM, new DRDAProtocolExceptionInfo(4624, 8, 0, false));
        errorInfoTable.put(DRDA_Proto_RDBNFNRM, new DRDAProtocolExceptionInfo(8721, 8, 0, false));
        errorInfoTable.put(DRDA_Disconnect, new DRDAProtocolExceptionInfo(0, 0, 0, false));
        errorInfoTable.put(DRDA_AgentError, new DRDAProtocolExceptionInfo(4658, 64, 0, false));
        errorInfoTable.put(DRDA_Timeout, new DRDAProtocolExceptionInfo(0, 0, 0, false));
    }
}

