/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.JoinResultSet;
import org.apache.derby.shared.common.error.StandardException;

class NestedLoopJoinResultSet
extends JoinResultSet {
    private boolean returnedRowMatchingRightSide = false;
    private ExecRow rightTemplate;

    @Override
    void clearScanState() {
        this.returnedRowMatchingRightSide = false;
        super.clearScanState();
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow result = null;
        boolean haveRow = false;
        boolean restrict = false;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S", "next");
        }
        if (!this.isRightOpen && this.leftRow != null) {
            this.leftRow = this.leftResultSet.getNextRowCore();
            if (this.leftRow == null) {
                this.closeRight();
            } else {
                ++this.rowsSeenLeft;
                this.openRight();
            }
        }
        while (this.leftRow != null && !haveRow) {
            DataValueDescriptor src_col;
            if (this.oneRowRightSide && this.returnedRowMatchingRightSide) {
                this.rightRow = null;
                this.returnedRowMatchingRightSide = false;
            } else {
                this.rightRow = this.rightResultSet.getNextRowCore();
                if (this.notExistsRightSide) {
                    this.rightRow = this.rightRow == null ? this.rightTemplate : null;
                }
                boolean bl = this.returnedRowMatchingRightSide = this.rightRow != null;
            }
            if (this.rightRow == null) {
                this.leftRow = this.leftResultSet.getNextRowCore();
                if (this.leftRow == null) {
                    this.closeRight();
                    continue;
                }
                ++this.rowsSeenLeft;
                this.openRight();
                continue;
            }
            ++this.rowsSeenRight;
            if (this.restriction != null) {
                DataValueDescriptor restrictBoolean = (DataValueDescriptor)this.restriction.invoke(this.activation);
                boolean bl = restrict = !restrictBoolean.isNull() && restrictBoolean.getBoolean();
                if (!restrict) {
                    ++this.rowsFiltered;
                    continue;
                }
            }
            if (this.mergedRow == null) {
                this.mergedRow = this.getExecutionFactory().getValueRow(this.leftNumCols + this.rightNumCols);
            }
            int colInCtr = 1;
            int colOutCtr = 1;
            while (colInCtr <= this.leftNumCols) {
                src_col = this.leftRow.getColumn(colInCtr);
                if (src_col != null && src_col.hasStream()) {
                    src_col = src_col.cloneValue(false);
                }
                this.mergedRow.setColumn(colOutCtr, src_col);
                ++colInCtr;
                ++colOutCtr;
            }
            if (!this.notExistsRightSide) {
                colInCtr = 1;
                while (colInCtr <= this.rightNumCols) {
                    src_col = this.rightRow.getColumn(colInCtr);
                    if (src_col != null && src_col.hasStream()) {
                        src_col = src_col.cloneValue(false);
                    }
                    this.mergedRow.setColumn(colOutCtr, src_col);
                    ++colInCtr;
                    ++colOutCtr;
                }
            }
            this.setCurrentRow(this.mergedRow);
            haveRow = true;
        }
        if (haveRow) {
            result = this.mergedRow;
            ++this.rowsReturned;
        } else {
            this.clearCurrentRow();
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return result;
    }

    @Override
    public void close() throws StandardException {
        if (this.isOpen) {
            this.beginTime = this.getCurrentTimeMillis();
            this.clearCurrentRow();
            super.close();
            this.returnedRowMatchingRightSide = false;
            this.closeTime += this.getElapsedMillis(this.beginTime);
        }
    }

    @Override
    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime - this.leftResultSet.getTimeSpent(1) - this.rightResultSet.getTimeSpent(1);
        }
        return totTime;
    }

    NestedLoopJoinResultSet(NoPutResultSet leftResultSet, int leftNumCols, NoPutResultSet rightResultSet, int rightNumCols, Activation activation, GeneratedMethod restriction, int resultSetNumber, boolean oneRowRightSide, boolean notExistsRightSide, double optimizerEstimatedRowCount, double optimizerEstimatedCost, String userSuppliedOptimizerOverrides) {
        super(leftResultSet, leftNumCols, rightResultSet, rightNumCols, activation, restriction, resultSetNumber, oneRowRightSide, notExistsRightSide, optimizerEstimatedRowCount, optimizerEstimatedCost, userSuppliedOptimizerOverrides);
        if (notExistsRightSide) {
            this.rightTemplate = this.getExecutionFactory().getValueRow(rightNumCols);
        }
    }
}

