/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.heap;

import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.conglomerate.GenericConglomerateController;
import org.apache.derby.impl.store.access.conglomerate.OpenConglomerate;
import org.apache.derby.impl.store.access.conglomerate.RowPosition;
import org.apache.derby.impl.store.access.heap.Heap;
import org.apache.derby.impl.store.access.heap.HeapPostCommit;
import org.apache.derby.impl.store.access.heap.HeapRowLocation;
import org.apache.derby.impl.store.access.heap.OpenHeap;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class HeapController
extends GenericConglomerateController
implements ConglomerateController {
    @Override
    protected final void getRowPositionFromRowLocation(RowLocation row_loc, RowPosition pos) throws StandardException {
        SanityManager.ASSERT(row_loc instanceof HeapRowLocation);
        pos.current_rh = ((HeapRowLocation)row_loc).getRecordHandle(this.open_conglom.getContainer());
        pos.current_rh_qualified = true;
    }

    @Override
    protected void queueDeletePostCommitWork(RowPosition pos) throws StandardException {
        TransactionManager xact_mgr = this.open_conglom.getXactMgr();
        xact_mgr.addPostCommitWork(new HeapPostCommit(xact_mgr.getAccessManager(), pos.current_page.getPageKey()));
    }

    protected final boolean purgeCommittedDeletes(Page page) throws StandardException {
        boolean purgingDone = false;
        int num_possible_commit_delete = page.recordCount() - page.nonDeletedRecordCount();
        if (num_possible_commit_delete > 0) {
            for (int slot_no = page.recordCount() - 1; slot_no >= 0; --slot_no) {
                RecordHandle rh;
                boolean row_is_committed_delete = page.isDeletedAtSlot(slot_no);
                if (!row_is_committed_delete || !(row_is_committed_delete = this.lockRowAtSlotNoWaitExclusive(rh = page.fetchFromSlot(null, slot_no, RowUtil.EMPTY_ROW, RowUtil.EMPTY_ROW_FETCH_DESCRIPTOR, true)))) continue;
                purgingDone = true;
                page.purgeAtSlot(slot_no, 1, false);
            }
        }
        if (page.recordCount() == 0) {
            this.removePage(page);
            purgingDone = true;
        }
        return purgingDone;
    }

    private RecordHandle doInsert(DataValueDescriptor[] row) throws StandardException {
        RecordHandle rh;
        byte insert_mode;
        Page page = null;
        Heap heap = (Heap)this.open_conglom.getConglomerate();
        int invalidColumn = RowUtil.columnOutOfRange(row, null, heap.format_ids.length);
        if (invalidColumn >= 0) {
            throw StandardException.newException("XSCH5.S", invalidColumn, heap.format_ids.length);
        }
        page = this.open_conglom.getContainer().getPageForInsert(0);
        if (page != null) {
            insert_mode = page.recordCount() == 0 ? (byte)8 : 1;
            rh = page.insert(row, null, insert_mode, 100);
            page.unlatch();
            page = null;
            if (rh != null) {
                return rh;
            }
        }
        if ((page = this.open_conglom.getContainer().getPageForInsert(1)) != null) {
            insert_mode = page.recordCount() == 0 ? (byte)8 : 1;
            rh = page.insert(row, null, insert_mode, 100);
            page.unlatch();
            page = null;
            if (rh != null) {
                return rh;
            }
        }
        page = this.open_conglom.getContainer().addPage();
        rh = page.insert(row, null, (byte)8, 100);
        page.unlatch();
        page = null;
        SanityManager.ASSERT(rh != null);
        return rh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long load(TransactionManager xact_manager, Heap heap, boolean createConglom, RowLocationRetRowSource rowSource) throws StandardException {
        OpenHeap open_conglom;
        long num_rows_loaded = 0L;
        SanityManager.ASSERT(this.open_conglom == null, "load expects container handle to be closed on entry.");
        int mode = 5;
        if (createConglom) {
            mode |= 2;
        }
        if ((open_conglom = new OpenHeap()).init(null, heap, heap.format_ids, heap.collation_ids, xact_manager, xact_manager.getRawStoreXact(), false, mode, 7, xact_manager.getRawStoreXact().newLockingPolicy(2, 5, true), null) == null) {
            throw StandardException.newException("XSCH1.S", heap.getId().getContainerId());
        }
        this.init(open_conglom);
        Page page = open_conglom.getContainer().addPage();
        boolean callbackWithRowLocation = rowSource.needsRowLocation();
        HeapRowLocation rowlocation = callbackWithRowLocation || rowSource.needsRowLocationForDeferredCheckConstraints() ? new HeapRowLocation() : null;
        FormatableBitSet validColumns = rowSource.getValidColumns();
        try {
            Object[] row;
            while ((row = rowSource.getNextRowFromRowSource()) != null) {
                ++num_rows_loaded;
                int invalidColumn = RowUtil.columnOutOfRange((DataValueDescriptor[])row, validColumns, heap.format_ids.length);
                if (invalidColumn >= 0) {
                    throw StandardException.newException("XSCH5.S", invalidColumn, heap.format_ids.length);
                }
                RecordHandle rh = page.insert(row, validColumns, (byte)1, 100);
                if (rh == null) {
                    page.unlatch();
                    page = null;
                    page = open_conglom.getContainer().addPage();
                    rh = page.insert(row, validColumns, (byte)8, 100);
                }
                if (callbackWithRowLocation) {
                    rowlocation.setFrom(rh);
                    rowSource.rowLocation(rowlocation);
                }
                if (!rowSource.needsRowLocationForDeferredCheckConstraints()) continue;
                rowlocation.setFrom(rh);
                rowSource.offendingRowLocation(rowlocation, heap.getContainerid());
            }
            page.unlatch();
            page = null;
            if (!heap.isTemporary()) {
                open_conglom.getContainer().flushContainer();
            }
        }
        finally {
            this.close();
        }
        return num_rows_loaded;
    }

    protected boolean lockRow(RecordHandle rh, int lock_oper, boolean wait, int lock_duration) throws StandardException {
        boolean ret_val;
        boolean forUpdateLock;
        boolean forUpdate = (1 & lock_oper) != 0;
        boolean bl = forUpdateLock = (8 & lock_oper) != 0;
        if (forUpdate && !forUpdateLock) {
            boolean forInsert = (2 & lock_oper) != 0;
            boolean forInsertPrevKey = (4 & lock_oper) != 0;
            SanityManager.ASSERT(!forInsertPrevKey || !forInsert);
            ret_val = lock_duration == 1 ? this.open_conglom.getContainer().getLockingPolicy().zeroDurationLockRecordForWrite(this.open_conglom.getRawTran(), rh, forInsertPrevKey, wait) : this.open_conglom.getContainer().getLockingPolicy().lockRecordForWrite(this.open_conglom.getRawTran(), rh, forInsert, wait);
        } else {
            SanityManager.ASSERT((2 & lock_oper) == 0);
            SanityManager.ASSERT((4 & lock_oper) == 0);
            ret_val = this.open_conglom.getContainer().getLockingPolicy().lockRecordForRead(this.open_conglom.getRawTran(), this.open_conglom.getContainer(), rh, wait, forUpdate);
        }
        return ret_val;
    }

    protected Page getUserPageNoWait(long pageno) throws StandardException {
        return this.open_conglom.getContainer().getUserPageNoWait(pageno);
    }

    protected Page getUserPageWait(long pageno) throws StandardException {
        return this.open_conglom.getContainer().getUserPageWait(pageno);
    }

    protected boolean lockRowAtSlotNoWaitExclusive(RecordHandle rh) throws StandardException {
        try {
            return this.open_conglom.getContainer().getLockingPolicy().lockRecordForWrite(this.open_conglom.getRawTran(), rh, false, false);
        }
        catch (StandardException se) {
            if (se.isSelfDeadlock()) {
                return false;
            }
            throw se;
        }
    }

    protected void removePage(Page page) throws StandardException {
        this.open_conglom.getContainer().removePage(page);
    }

    @Override
    public int insert(DataValueDescriptor[] row) throws StandardException {
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                this.open_conglom.reopen();
            } else {
                throw StandardException.newException("XSCH6.S", this.open_conglom.getConglomerate().getId());
            }
        }
        this.doInsert(row);
        return 0;
    }

    @Override
    public void insertAndFetchLocation(DataValueDescriptor[] row, RowLocation templateRowLocation) throws StandardException {
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                this.open_conglom.reopen();
            } else {
                throw StandardException.newException("XSCH6.S", this.open_conglom.getConglomerate().getId());
            }
        }
        RecordHandle rh = this.doInsert(row);
        SanityManager.ASSERT(templateRowLocation instanceof HeapRowLocation);
        HeapRowLocation hrl = (HeapRowLocation)templateRowLocation;
        hrl.setFrom(rh);
    }

    @Override
    public boolean lockRow(RowLocation loc, int lock_operation, boolean wait, int lock_duration) throws StandardException {
        RecordHandle rh = ((HeapRowLocation)loc).getRecordHandle(this.open_conglom.getContainer());
        return this.lockRow(rh, lock_operation, wait, lock_duration);
    }

    @Override
    public void unlockRowAfterRead(RowLocation loc, boolean forUpdate, boolean row_qualified) throws StandardException {
        RecordHandle rh = ((HeapRowLocation)loc).getRecordHandle(this.open_conglom.getContainer());
        this.open_conglom.getContainer().getLockingPolicy().unlockRecordAfterRead(this.open_conglom.getRawTran(), this.open_conglom.getContainer(), rh, this.open_conglom.isForUpdate(), row_qualified);
    }

    @Override
    public boolean lockRow(long page_num, int record_id, int lock_operation, boolean wait, int lock_duration) throws StandardException {
        RecordHandle rh = this.open_conglom.getContainer().makeRecordHandle(page_num, record_id);
        return this.lockRow(rh, lock_operation, wait, lock_duration);
    }

    @Override
    public RowLocation newRowLocationTemplate() throws StandardException {
        if (this.open_conglom.isClosed()) {
            if (this.open_conglom.getHold()) {
                this.open_conglom.reopen();
            } else {
                throw StandardException.newException("XSCH6.S", this.open_conglom.getConglomerate().getId());
            }
        }
        return new HeapRowLocation();
    }

    public OpenConglomerate getOpenConglomerate() {
        return this.open_conglom;
    }
}

