/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.jms.tests;

import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.NamingException;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.db.IDBAdapter;
import org.eclipse.net4j.db.derby.EmbeddedDerbyAdapter;
import org.eclipse.net4j.jms.JMSInitialContext;
import org.eclipse.net4j.jms.admin.IJMSAdmin;
import org.eclipse.net4j.jms.admin.JMSAdminUtil;
import org.eclipse.net4j.jms.internal.server.Server;
import org.eclipse.net4j.jms.server.IStore;
import org.eclipse.net4j.jms.server.JMSServerUtil;
import org.eclipse.net4j.jms.server.jdbc.JDBCUtil;
import org.eclipse.net4j.tcp.ITCPConnector;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.ManagedContainer;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.log.OMLogHandler;
import org.eclipse.net4j.util.om.log.PrintLogHandler;
import org.eclipse.net4j.util.om.trace.OMTraceHandler;
import org.eclipse.net4j.util.om.trace.PrintTraceHandler;

public class JMSSeparatedTest {
    public static void main(String[] args) throws Exception {
        try {
            Context context = JMSSeparatedTest.init();
            ConnectionFactory connectionFactory = (ConnectionFactory)context.lookup("net4j.jms.ConnectionFactory");
            Destination destination = (Destination)context.lookup("StockTopic");
            Connection connection = connectionFactory.createConnection();
            Session session = connection.createSession(true, 0);
            MessageProducer publisher = session.createProducer(destination);
            MessageConsumer subscriber1 = session.createConsumer(destination);
            MessageConsumer subscriber2 = session.createConsumer(destination);
            subscriber1.setMessageListener((MessageListener)new MessageLogger("subscriber1"));
            subscriber2.setMessageListener((MessageListener)new MessageLogger("subscriber2"));
            connection.start();
            publisher.send((Message)session.createObjectMessage((Serializable)((Object)"Message 1")));
            publisher.send((Message)session.createObjectMessage((Serializable)((Object)"Message 2")));
            publisher.send((Message)session.createObjectMessage((Serializable)((Object)"Message 3")));
            publisher.send((Message)session.createObjectMessage((Serializable)((Object)"Message 4")));
            session.commit();
        }
        finally {
            ConcurrencyUtil.sleep((long)500L);
            Server.INSTANCE.deactivate();
        }
    }

    private static Context init() throws Exception {
        OMPlatform.INSTANCE.addLogHandler((OMLogHandler)PrintLogHandler.CONSOLE);
        OMPlatform.INSTANCE.addTraceHandler((OMTraceHandler)PrintTraceHandler.CONSOLE);
        OMPlatform.INSTANCE.setDebugging(true);
        JMSSeparatedTest.initServer();
        return JMSSeparatedTest.initClient();
    }

    private static void initServer() throws Exception {
        IDBAdapter.REGISTRY.put((Object)"derby-embedded", (Object)new EmbeddedDerbyAdapter());
        IStore store = JDBCUtil.getStore();
        Server.INSTANCE.setStore(store);
        Server.INSTANCE.activate();
        ManagedContainer serverContainer = new ManagedContainer();
        Net4jUtil.prepareContainer((IManagedContainer)serverContainer);
        TCPUtil.prepareContainer((IManagedContainer)serverContainer);
        JMSServerUtil.prepareContainer((IManagedContainer)serverContainer);
        TCPUtil.getAcceptor((IManagedContainer)serverContainer, null);
    }

    private static Context initClient() throws NamingException {
        ManagedContainer clientContainer = new ManagedContainer();
        Net4jUtil.prepareContainer((IManagedContainer)clientContainer);
        TCPUtil.prepareContainer((IManagedContainer)clientContainer);
        ITCPConnector connector = TCPUtil.getConnector((IManagedContainer)clientContainer, (String)"localhost");
        IJMSAdmin admin = JMSAdminUtil.createAdmin((IConnector)connector);
        admin.createQueue("StockQueue");
        admin.createTopic("StockTopic");
        return new JMSInitialContext((IManagedContainer)clientContainer);
    }

    private static final class MessageLogger
    implements MessageListener {
        private String name;

        public MessageLogger(String name) {
            this.name = name;
        }

        public void onMessage(Message message) {
            try {
                Serializable object = ((ObjectMessage)message).getObject();
                IOUtil.OUT().println("\n------> MESSAGE for " + this.name + ": " + object + "\n");
                message.acknowledge();
            }
            catch (JMSException ex) {
                IOUtil.print((Throwable)ex);
            }
        }
    }
}

