/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceLeaf;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.ui.editor.CDOEditor;
import org.eclipse.emf.cdo.internal.ui.editor.CDOEditorInputImpl;
import org.eclipse.emf.cdo.internal.ui.editor.CDOLobEditorInput;
import org.eclipse.emf.cdo.ui.CDOEditorInput;
import org.eclipse.emf.cdo.ui.CDOEditorInput2;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public final class CDOEditorUtil {
    public static final String EDITOR_ID = "org.eclipse.emf.cdo.ui.CDOEditor";
    public static final String TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    private static final IEditorRegistry EDITOR_REGISTRY = PlatformUI.getWorkbench().getEditorRegistry();
    private static final Map<String, String> EDITOR_MAPPINGS = CDOEditorUtil.initEditorMappings();
    private static final Map<CDOResourceLeaf, String> EDITOR_OVERRIDES = new WeakHashMap<CDOResourceLeaf, String>();
    private static String editorID = OMPlatform.INSTANCE.getProperty("org.eclipse.emf.cdo.ui.editorID", "org.eclipse.emf.cdo.ui.CDOEditor");

    private CDOEditorUtil() {
    }

    public static String getEditorID() {
        return editorID;
    }

    public static void setEditorID(String editorID) {
        CDOEditorUtil.editorID = editorID;
    }

    public static CDOEditorInput createCDOEditorInput(CDOView view, String resourcePath, boolean viewOwned) {
        return new CDOEditorInputImpl(view, resourcePath, viewOwned);
    }

    public static CDOEditorInput createCDOEditorInputWithEditingDomain(CDOEditorInput input, EditingDomain editingDomain) {
        return CDOEditorUtil.createCDOEditorInputWithEditingDomain(input.getView(), input.getResourcePath(), input.isViewOwned(), editingDomain);
    }

    public static CDOEditorInput createCDOEditorInputWithEditingDomain(CDOView view, String resourcePath, boolean viewOwned, EditingDomain editingDomain) {
        class CDOEditorInputWithEditingDomain
        extends CDOEditorInputImpl
        implements IEditingDomainProvider {
            private final EditingDomain editingDomain;

            CDOEditorInputWithEditingDomain(CDOView view, String resourcePath, boolean viewOwned, EditingDomain editingDomain) {
                super(view, resourcePath, viewOwned);
                this.editingDomain = editingDomain;
            }

            public EditingDomain getEditingDomain() {
                return this.editingDomain;
            }

            public <T> T getAdapter(Class<T> adapter) {
                if (adapter == IEditingDomainProvider.class) {
                    return (T)this;
                }
                return (T)super.getAdapter(adapter);
            }
        }
        return new CDOEditorInputWithEditingDomain(view, resourcePath, viewOwned, editingDomain);
    }

    public static void openEditor(IWorkbenchPage page, CDOView view, String resourcePath) {
        Display display = page.getWorkbenchWindow().getShell().getDisplay();
        UIUtil.asyncExec((Display)display, () -> {
            try {
                IEditorReference[] references = CDOEditorUtil.findEditor(page, view, resourcePath);
                if (references.length != 0) {
                    IEditorPart editor = references[0].getEditor(true);
                    page.activate((IWorkbenchPart)editor);
                } else {
                    CDOEditorInput input = CDOEditorUtil.createCDOEditorInput(view, resourcePath, false);
                    page.openEditor((IEditorInput)input, editorID);
                }
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        });
    }

    public static IEditorReference[] findEditor(IWorkbenchPage page, CDOView view, String resourcePath, CDOID objectID) {
        ArrayList<IEditorReference> result = new ArrayList<IEditorReference>();
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            try {
                IEditorInput editorInput;
                if (ObjectUtil.equals((Object)editorReference.getId(), (Object)editorID) && (editorInput = editorReference.getEditorInput()) instanceof CDOEditorInput) {
                    CDOEditorInput2 cdoInput2;
                    CDOEditorInput cdoInput = (CDOEditorInput)editorInput;
                    if ((view == null || view == cdoInput.getView()) && (resourcePath == null || ObjectUtil.equals((Object)resourcePath, (Object)cdoInput.getResourcePath())) && (objectID == null || cdoInput instanceof CDOEditorInput2 && ObjectUtil.equals((Object)objectID, (Object)(cdoInput2 = (CDOEditorInput2)cdoInput).getObjectID()))) {
                        result.add(editorReference);
                    }
                }
            }
            catch (PartInitException ex) {
                OM.LOG.error((Throwable)ex);
            }
            ++n2;
        }
        return result.toArray(new IEditorReference[result.size()]);
    }

    public static IEditorReference[] findEditor(IWorkbenchPage page, CDOView view, String resourcePath) {
        return CDOEditorUtil.findEditor(page, view, resourcePath, null);
    }

    public static void populateMenu(IMenuManager manager, CDOResourceLeaf resource, IWorkbenchPage page) {
        String[] editorIDs;
        String effectiveEditorID = CDOEditorUtil.getEffectiveEditorID(resource);
        if (effectiveEditorID != null) {
            manager.add((IAction)new OpenEditorAction(page, effectiveEditorID, resource, false));
        }
        if ((editorIDs = CDOEditorUtil.getAllEditorIDs(resource)).length > 1 || editorIDs.length == 1 && !editorIDs[0].equals(effectiveEditorID)) {
            MenuManager subMenu = new MenuManager("Open With");
            manager.add((IContributionItem)subMenu);
            String[] stringArray = editorIDs;
            int n = editorIDs.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                OpenEditorAction action = new OpenEditorAction(page, id, resource, true);
                subMenu.add((IAction)action);
                if (id.equals(effectiveEditorID)) {
                    action.setChecked(true);
                }
                ++n2;
            }
        }
    }

    public static String getEffectiveEditorID(CDOResourceLeaf resource) {
        String id = EDITOR_OVERRIDES.get(resource);
        if (id != null) {
            return id;
        }
        id = CDOEditorUtil.computeEffectiveEditorID(resource);
        id = CDOEditorUtil.mapEditorID(id);
        return id;
    }

    public static String[] getAllEditorIDs(CDOResourceLeaf resource) {
        HashSet<String> editorIDs = new HashSet<String>();
        if (resource instanceof CDOResource) {
            CDOEditorUtil.addMappedEditorID(editorIDs, EDITOR_ID);
        }
        CDOEditorUtil.addMappedEditorID(editorIDs, TEXT_EDITOR_ID);
        String name = resource.getName();
        IEditorDescriptor[] iEditorDescriptorArray = EDITOR_REGISTRY.getEditors(name);
        int n = iEditorDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorDescriptor editorDescriptor = iEditorDescriptorArray[n2];
            CDOEditorUtil.addMappedEditorID(editorIDs, editorDescriptor.getId());
            ++n2;
        }
        Object[] array = editorIDs.toArray(new String[editorIDs.size()]);
        Arrays.sort(array);
        return array;
    }

    public static IEditorInput createEditorInput(String editorID, CDOResourceLeaf resource, boolean viewOwned, boolean lobCommitOnSave) {
        if (resource instanceof CDOResource && EDITOR_ID.equals(editorID)) {
            CDOView view = resource.cdoView();
            String path = resource.getPath();
            return CDOEditorUtil.createCDOEditorInput(view, path, lobCommitOnSave);
        }
        return CDOEditorUtil.createLobEditorInput(resource, lobCommitOnSave);
    }

    public static IEditorInput createLobEditorInput(CDOResourceLeaf resource, boolean lobCommitOnSave) {
        return new CDOLobEditorInput(resource, lobCommitOnSave);
    }

    public static IEditorInput createEditorInput(String editorID, CDOResourceLeaf resource, boolean viewOwned) {
        return CDOEditorUtil.createEditorInput(editorID, resource, viewOwned, false);
    }

    public static IEditorInput createEditorInput(String editorID, CDOResourceLeaf resource) {
        return CDOEditorUtil.createEditorInput(editorID, resource, false);
    }

    public static void openEditor(IWorkbenchPage page, CDOResourceLeaf resource) {
        String editorID = CDOEditorUtil.getEffectiveEditorID(resource);
        if (editorID != null) {
            CDOEditorUtil.openEditor(page, editorID, resource);
        }
    }

    public static void openEditor(IWorkbenchPage page, String editorID, CDOResourceLeaf resource) {
        Display display = page.getWorkbenchWindow().getShell().getDisplay();
        UIUtil.asyncExec((Display)display, () -> {
            try {
                IEditorInput editorInput = CDOEditorUtil.createEditorInput(editorID, resource);
                page.openEditor(editorInput, editorID);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        });
    }

    public static void refreshEditors(IWorkbenchPage page, CDOView view) {
        IEditorReference[] references;
        IEditorReference[] iEditorReferenceArray = references = CDOEditorUtil.findEditor(page, view, null);
        int n = references.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference reference = iEditorReferenceArray[n2];
            CDOEditor editor = (CDOEditor)reference.getEditor(false);
            if (editor != null) {
                editor.refreshViewer(null);
            }
            ++n2;
        }
    }

    private static String computeEffectiveEditorID(CDOResourceLeaf resource) {
        if (resource instanceof CDOResource) {
            return EDITOR_ID;
        }
        String name = resource.getName();
        IEditorDescriptor editorDescriptor = EDITOR_REGISTRY.getDefaultEditor(name);
        if (editorDescriptor != null) {
            return editorDescriptor.getId();
        }
        return TEXT_EDITOR_ID;
    }

    private static void addMappedEditorID(Set<String> editorIDs, String id) {
        if ((id = CDOEditorUtil.mapEditorID(id)) != null) {
            editorIDs.add(id);
        }
    }

    private static String mapEditorID(String id) {
        if (id != null && EDITOR_MAPPINGS.containsKey(id)) {
            id = EDITOR_MAPPINGS.get(id);
        }
        if (id != null && EDITOR_REGISTRY.findEditor(TEXT_EDITOR_ID) == null) {
            id = null;
        }
        return id;
    }

    private static Map<String, String> initEditorMappings() {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put("org.eclipse.jdt.ui.PropertiesFileEditor", CDOEditorUtil.getCDOPropertiesFileEditorID());
        return mappings;
    }

    private static String getCDOPropertiesFileEditorID() {
        try {
            Class c = CommonPlugin.loadClass((String)"org.eclipse.emf.cdo.ui.jdt", (String)"org.eclipse.emf.cdo.ui.jdt.CDOPropertiesFileEditor");
            Field field = ReflectUtil.getField((Class)c, (String)"ID");
            return (String)ReflectUtil.getValue((Field)field, null);
        }
        catch (Throwable ex) {
            return null;
        }
    }

    private static class OpenEditorAction
    extends Action {
        private IWorkbenchPage page;
        private String editorID;
        private CDOResourceLeaf resource;
        private boolean overrideOnRun;

        public OpenEditorAction(IWorkbenchPage page, String editorID, CDOResourceLeaf resource, boolean overrideOnRun) {
            this.page = page;
            this.editorID = editorID;
            this.resource = resource;
            this.overrideOnRun = overrideOnRun;
            IEditorDescriptor editorDescriptor = EDITOR_REGISTRY.findEditor(editorID);
            String label = editorDescriptor.getLabel();
            if (overrideOnRun) {
                this.setText(label);
            } else {
                this.setText("Open With " + label);
            }
            this.setImageDescriptor(editorDescriptor.getImageDescriptor());
            this.setToolTipText("Open the " + label + " editor on this resource");
        }

        public void run() {
            if (this.overrideOnRun) {
                EDITOR_OVERRIDES.put(this.resource, this.editorID);
            }
            CDOEditorUtil.openEditor(this.page, this.editorID, this.resource);
        }
    }
}

