/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.BinaryLogicalOperatorNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class IsNode
extends BinaryLogicalOperatorNode {
    private boolean notMe;

    IsNode(ValueNode leftOperand, ValueNode rightOperand, boolean notMe, ContextManager cm) {
        super(leftOperand, rightOperand, "is", cm);
        this.notMe = notMe;
    }

    @Override
    ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        super.bindExpression(fromList, subqueryList, aggregates);
        this.leftOperand.checkIsBoolean();
        this.rightOperand.checkIsBoolean();
        this.setType(this.leftOperand.getTypeServices());
        return this;
    }

    @Override
    ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        if (underNotNode) {
            this.notMe = !this.notMe;
        }
        this.leftOperand = this.leftOperand.eliminateNots(false);
        this.rightOperand = this.rightOperand.eliminateNots(false);
        return this;
    }

    @Override
    public ValueNode putAndsOnTop() throws StandardException {
        this.leftOperand = this.leftOperand.putAndsOnTop();
        this.rightOperand = this.rightOperand.putAndsOnTop();
        return this;
    }

    @Override
    public boolean verifyPutAndsOnTop() {
        return this.leftOperand.verifyPutAndsOnTop() && this.rightOperand.verifyPutAndsOnTop();
    }

    @Override
    public ValueNode changeToCNF(boolean underTopAndNode) throws StandardException {
        this.leftOperand = this.leftOperand.changeToCNF(false);
        this.rightOperand = this.rightOperand.changeToCNF(false);
        return this;
    }

    @Override
    public boolean verifyChangeToCNF() {
        return this.leftOperand.verifyChangeToCNF() && this.rightOperand.verifyChangeToCNF();
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        String evaluatorMethodName = this.notMe ? "isNot" : "is";
        this.leftOperand.generateExpression(acb, mb);
        this.rightOperand.generateExpression(acb, mb);
        mb.callMethod((short)185, "org.apache.derby.iapi.types.BooleanDataValue", evaluatorMethodName, "org.apache.derby.iapi.types.BooleanDataValue", 1);
    }
}

