/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.properties;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.properties.IProperties;
import org.eclipse.net4j.util.properties.Property;

public class Properties<RECEIVER>
implements IProperties<RECEIVER> {
    private final List<Property<RECEIVER>> properties = new ArrayList<Property<RECEIVER>>();
    private final Class<RECEIVER> receiverType;

    public Properties(Class<RECEIVER> receiverType) {
        this.receiverType = receiverType;
    }

    @Override
    public final Class<RECEIVER> getReceiverType() {
        return this.receiverType;
    }

    @Override
    public final void add(Property<RECEIVER> property) {
        CheckUtil.checkArg(property, "property");
        CheckUtil.checkArg(property.getName(), "property.getName()");
        this.properties.add(property);
    }

    @Override
    public final List<Property<RECEIVER>> getProperties() {
        return this.properties;
    }

    @Override
    public final Property<RECEIVER> getProperty(String name) {
        for (Property<RECEIVER> property : this.properties) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public final <TARGET_RECEIVER> Properties<TARGET_RECEIVER> adaptProperties(Class<TARGET_RECEIVER> targetReceiverType, String namePrefix, Function<TARGET_RECEIVER, RECEIVER> receiverConverter) {
        Properties<TARGET_RECEIVER> result = new Properties<TARGET_RECEIVER>(targetReceiverType);
        for (Property<RECEIVER> property : this.properties) {
            Property<TARGET_RECEIVER> converted = this.adaptProperty(namePrefix, property, receiverConverter);
            result.add(converted);
        }
        return result;
    }

    private <TARGET_RECEIVER> Property<TARGET_RECEIVER> adaptProperty(String namePrefix, final Property<RECEIVER> property, final Function<TARGET_RECEIVER, RECEIVER> receiverConverter) {
        String name = String.valueOf(StringUtil.safe(namePrefix)) + property.getName();
        String label = property.getLabel();
        String description = property.getDescription();
        String category = property.getCategory();
        if (property instanceof Property.WithArguments) {
            final Property.WithArguments propertyWithArguments = (Property.WithArguments)property;
            return new Property.WithArguments<TARGET_RECEIVER>(name, label, description, category){

                @Override
                protected Object eval(TARGET_RECEIVER targetReceiver, Object[] args) {
                    Object receiver = receiverConverter.apply(targetReceiver);
                    return propertyWithArguments.eval(receiver, args);
                }
            };
        }
        return new Property<TARGET_RECEIVER>(name, label, description, category){

            @Override
            protected Object eval(TARGET_RECEIVER targetReceiver) {
                Object receiver = receiverConverter.apply(targetReceiver);
                return property.eval(receiver);
            }
        };
    }
}

