/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import org.apache.derby.impl.drda.CcsidManager;
import org.apache.derby.impl.drda.DRDAConnThread;
import org.apache.derby.impl.drda.DRDAProtocolException;
import org.apache.derby.impl.drda.DRDASocketTimeoutException;
import org.apache.derby.impl.drda.DRDAString;
import org.apache.derby.impl.drda.DecryptionManager;
import org.apache.derby.impl.drda.DssTrace;
import org.apache.derby.impl.drda.EXTDTAReaderInputStream;
import org.apache.derby.impl.drda.EbcdicCcsidManager;
import org.apache.derby.impl.drda.LayerBStreamedEXTDTAReaderInputStream;
import org.apache.derby.impl.drda.NetworkServerControlImpl;
import org.apache.derby.impl.drda.SignedBinary;
import org.apache.derby.impl.drda.StandardEXTDTAReaderInputStream;
import org.apache.derby.impl.drda.Utf8CcsidManager;
import org.apache.derby.shared.common.sanity.SanityManager;

class DDMReader {
    private static final int DEFAULT_BUFFER_SIZE = Short.MAX_VALUE;
    private static final int MAX_MARKS_NESTING = 10;
    private static final int NO_CODEPOINT = -1;
    private static final int EMPTY_STACK = -1;
    private static final boolean ADJUST_LENGTHS = true;
    private static final boolean NO_ADJUST_LENGTHS = false;
    private static final long MAX_EXTDTA_SIZE = Long.MAX_VALUE;
    private static final int[][] tenRadixMagnitude = new int[][]{{1000000000}, {232830643, -1486618624}, {54210108, -1613725636, -402653184}};
    private DRDAConnThread agent;
    private Utf8CcsidManager utf8CcsidManager;
    private EbcdicCcsidManager ebcdicCcsidManager;
    private CcsidManager ccsidManager;
    private byte[] buffer = new byte[Short.MAX_VALUE];
    private int pos;
    private int count;
    private int topDdmCollectionStack;
    private long[] ddmCollectionLenStack = new long[10];
    private long ddmScalarLen;
    private int dssLength;
    private boolean dssIsContinued;
    private boolean terminateChainOnErr;
    private boolean dssIsChainedWithSameID;
    private boolean dssIsChainedWithDiffID;
    private int dssCorrelationID;
    private int prevCorrelationID;
    private int svrcod;
    private DssTrace dssTrace;
    private InputStream inputStream;
    private boolean doingLayerBStreaming = false;
    volatile long totalByteCount = 0L;

    DDMReader(DRDAConnThread agent, DssTrace dssTrace) {
        this.initialize(agent, dssTrace);
    }

    DDMReader(InputStream inputStream) {
        this.inputStream = inputStream;
        this.initialize(null, null);
    }

    protected void initialize(DRDAConnThread agent, DssTrace dssTrace) {
        this.agent = agent;
        this.utf8CcsidManager = new Utf8CcsidManager();
        this.ebcdicCcsidManager = new EbcdicCcsidManager();
        this.ccsidManager = this.ebcdicCcsidManager;
        if (agent != null) {
            this.inputStream = agent.getInputStream();
        }
        this.topDdmCollectionStack = -1;
        this.svrcod = 0;
        this.pos = 0;
        this.count = 0;
        this.ddmScalarLen = 0L;
        this.dssLength = 0;
        this.prevCorrelationID = -1;
        this.dssCorrelationID = -1;
        this.dssTrace = dssTrace;
        this.dssIsChainedWithDiffID = false;
        this.dssIsChainedWithSameID = false;
    }

    protected void setUtf8Ccsid() {
        this.ccsidManager = this.utf8CcsidManager;
    }

    protected void setEbcdicCcsid() {
        this.ccsidManager = this.ebcdicCcsidManager;
    }

    protected boolean terminateChainOnErr() {
        return this.terminateChainOnErr;
    }

    protected boolean isChainedWithSameID() {
        return this.dssIsChainedWithSameID;
    }

    protected boolean isChainedWithDiffID() {
        return this.dssIsChainedWithDiffID;
    }

    protected long getDdmLength() {
        return this.ddmScalarLen;
    }

    protected boolean moreDdmData() {
        return this.ddmScalarLen > 0L;
    }

    protected boolean moreDssData() {
        return this.dssLength > 0;
    }

    protected boolean moreData() {
        return this.pos - this.count > 0;
    }

    protected boolean isCmd() throws DRDAProtocolException, UnsupportedEncodingException {
        this.ensureALayerDataInBuffer(4);
        String val = new String(this.buffer, 0, 4, "UTF8");
        return NetworkServerControlImpl.isCmd(val);
    }

    protected int readDssHeader() throws DRDAProtocolException {
        int gdsFormatter;
        this.ensureALayerDataInBuffer(6);
        this.dssLength = ((this.buffer[this.pos] & 0xFF) << 8) + ((this.buffer[this.pos + 1] & 0xFF) << 0);
        this.pos += 2;
        if ((this.dssLength & 0x8000) == 32768) {
            this.dssLength = Short.MAX_VALUE;
            this.dssIsContinued = true;
        } else {
            this.dssIsContinued = false;
        }
        if (this.dssLength < 6) {
            this.agent.throwSyntaxrm(1, 0);
        }
        if ((this.buffer[this.pos++] & 0xFF) != 208) {
            this.agent.throwSyntaxrm(3, 0);
        }
        if (((gdsFormatter = this.buffer[this.pos++] & 0xFF) & 0xF) != 1 && (gdsFormatter & 0xF) != 3) {
            this.agent.throwSyntaxrm(4, 0);
        }
        if ((gdsFormatter & 0x40) == 64) {
            if ((gdsFormatter & 0x50) == 80) {
                this.dssIsChainedWithSameID = true;
                this.dssIsChainedWithDiffID = false;
            } else {
                this.dssIsChainedWithSameID = false;
                this.dssIsChainedWithDiffID = true;
            }
            this.terminateChainOnErr = (gdsFormatter & 0x20) != 32;
        } else {
            if ((gdsFormatter & 0x50) == 80) {
                this.agent.throwSyntaxrm(24, 0);
            }
            if ((gdsFormatter & 0x20) == 32) {
                this.agent.throwSyntaxrm(26, 0);
            }
            this.dssIsChainedWithSameID = false;
            this.dssIsChainedWithDiffID = false;
        }
        this.dssCorrelationID = ((this.buffer[this.pos] & 0xFF) << 8) + ((this.buffer[this.pos + 1] & 0xFF) << 0);
        this.pos += 2;
        this.trace("dssLength = " + this.dssLength + " correlationID = " + this.dssCorrelationID);
        if (this.prevCorrelationID != -1 && this.dssCorrelationID != this.prevCorrelationID) {
            this.agent.throwSyntaxrm(26, 0);
        }
        this.prevCorrelationID = this.dssIsChainedWithSameID ? this.dssCorrelationID : -1;
        this.dssLength -= 6;
        return this.dssCorrelationID;
    }

    protected void readReplyDss() throws DRDAProtocolException {
        int gdsFormatter;
        this.ensureALayerDataInBuffer(6);
        this.dssLength = ((this.buffer[this.pos++] & 0xFF) << 8) + ((this.buffer[this.pos++] & 0xFF) << 0);
        if ((this.dssLength & 0x8000) == 32768) {
            this.dssLength = Short.MAX_VALUE;
            this.dssIsContinued = true;
        } else {
            this.dssIsContinued = false;
        }
        if (this.dssLength < 6) {
            this.agent.throwSyntaxrm(1, 0);
        }
        if ((this.buffer[this.pos++] & 0xFF) != 208) {
            this.agent.throwSyntaxrm(3, 0);
        }
        if (((gdsFormatter = this.buffer[this.pos++] & 0xFF) & 0x40) == 64) {
            if ((gdsFormatter & 0x50) == 80) {
                this.dssIsChainedWithSameID = true;
                this.dssIsChainedWithDiffID = false;
            } else {
                this.dssIsChainedWithSameID = false;
                this.dssIsChainedWithDiffID = true;
            }
        } else {
            this.dssIsChainedWithSameID = false;
            this.dssIsChainedWithDiffID = false;
        }
        this.dssCorrelationID = ((this.buffer[this.pos++] & 0xFF) << 8) + ((this.buffer[this.pos++] & 0xFF) << 0);
        this.trace("dssLength = " + this.dssLength + " correlationID = " + this.dssCorrelationID);
        this.dssLength -= 6;
    }

    protected int readLengthAndCodePoint(boolean isLayerBStreamingPossible) throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(4, false);
        this.ddmScalarLen = this.readCodePoint();
        int codePoint = this.readCodePoint();
        this.trace("length = " + this.ddmScalarLen + " codepoint = " + Integer.toHexString(codePoint));
        if ((this.ddmScalarLen & 0x8000L) == 32768L) {
            int numberOfExtendedLenBytes = (int)this.ddmScalarLen - 32768 - 4;
            int adjustSize = 0;
            this.ensureBLayerDataInBuffer(numberOfExtendedLenBytes, false);
            switch (numberOfExtendedLenBytes) {
                case 8: {
                    this.ddmScalarLen = (((long)this.buffer[this.pos++] & 0xFFL) << 56) + (((long)this.buffer[this.pos++] & 0xFFL) << 48) + (((long)this.buffer[this.pos++] & 0xFFL) << 40) + (((long)this.buffer[this.pos++] & 0xFFL) << 32) + (((long)this.buffer[this.pos++] & 0xFFL) << 24) + (((long)this.buffer[this.pos++] & 0xFFL) << 16) + (((long)this.buffer[this.pos++] & 0xFFL) << 8) + (((long)this.buffer[this.pos++] & 0xFFL) << 0);
                    adjustSize = 12;
                    break;
                }
                case 6: {
                    this.ddmScalarLen = (((long)this.buffer[this.pos++] & 0xFFL) << 40) + (((long)this.buffer[this.pos++] & 0xFFL) << 32) + (((long)this.buffer[this.pos++] & 0xFFL) << 24) + (((long)this.buffer[this.pos++] & 0xFFL) << 16) + (((long)this.buffer[this.pos++] & 0xFFL) << 8) + (((long)this.buffer[this.pos++] & 0xFFL) << 0);
                    adjustSize = 10;
                    break;
                }
                case 4: {
                    this.ddmScalarLen = (((long)this.buffer[this.pos++] & 0xFFL) << 24) + (((long)this.buffer[this.pos++] & 0xFFL) << 16) + (((long)this.buffer[this.pos++] & 0xFFL) << 8) + (((long)this.buffer[this.pos++] & 0xFFL) << 0);
                    adjustSize = 8;
                    break;
                }
                case 0: {
                    if (isLayerBStreamingPossible && (codePoint == 5228 || codePoint == 9243)) {
                        this.startLayerBStreaming();
                        adjustSize = 4;
                        break;
                    }
                    this.agent.throwSyntaxrm(12, 0);
                    break;
                }
                default: {
                    this.agent.throwSyntaxrm(12, 0);
                }
            }
            int i = 0;
            while (i <= this.topDdmCollectionStack) {
                int n = i++;
                this.ddmCollectionLenStack[n] = this.ddmCollectionLenStack[n] - (long)adjustSize;
            }
            this.dssLength -= adjustSize;
        } else {
            if (this.ddmScalarLen < 4L) {
                this.agent.throwSyntaxrm(7, 0);
            }
            this.adjustLengths(4);
        }
        return codePoint;
    }

    protected int readCodePoint() {
        return ((this.buffer[this.pos++] & 0xFF) << 8) + ((this.buffer[this.pos++] & 0xFF) << 0);
    }

    protected void markCollection() {
        this.ddmCollectionLenStack[++this.topDdmCollectionStack] = this.ddmScalarLen;
        this.ddmScalarLen = 0L;
    }

    protected int getCodePoint() throws DRDAProtocolException {
        if (this.topDdmCollectionStack == -1) {
            return -1;
        }
        if (this.ddmCollectionLenStack[this.topDdmCollectionStack] == 0L) {
            this.ddmCollectionLenStack[this.topDdmCollectionStack--] = 0L;
            return -1;
        }
        return this.readLengthAndCodePoint(false);
    }

    protected int getCodePoint(int codePointCheck) throws DRDAProtocolException {
        int codePoint = this.getCodePoint();
        if (codePoint != codePointCheck) {
            this.agent.missingCodePoint(codePoint);
        }
        return codePoint;
    }

    protected byte readByte() throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(1, true);
        return this.buffer[this.pos++];
    }

    protected int readUnsignedByte() throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(1, true);
        return this.buffer[this.pos++] & 0xFF;
    }

    protected int readNetworkShort() throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(2, true);
        return ((this.buffer[this.pos++] & 0xFF) << 8) + ((this.buffer[this.pos++] & 0xFF) << 0);
    }

    protected int readSignedNetworkShort() throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(2, true);
        return (short)(((this.buffer[this.pos++] & 0xFF) << 8) + ((this.buffer[this.pos++] & 0xFF) << 0));
    }

    protected short readShort(int byteOrder) throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(2, true);
        short s = SignedBinary.getShort(this.buffer, this.pos, byteOrder);
        this.pos += 2;
        return s;
    }

    protected int readNetworkInt() throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(4, true);
        return ((this.buffer[this.pos++] & 0xFF) << 24) + ((this.buffer[this.pos++] & 0xFF) << 16) + ((this.buffer[this.pos++] & 0xFF) << 8) + ((this.buffer[this.pos++] & 0xFF) << 0);
    }

    protected int readInt(int byteOrder) throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(4, true);
        int i = SignedBinary.getInt(this.buffer, this.pos, byteOrder);
        this.pos += 4;
        return i;
    }

    protected long readNetworkLong() throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(8, true);
        return (((long)this.buffer[this.pos++] & 0xFFL) << 56) + (((long)this.buffer[this.pos++] & 0xFFL) << 48) + (((long)this.buffer[this.pos++] & 0xFFL) << 40) + (((long)this.buffer[this.pos++] & 0xFFL) << 32) + (((long)this.buffer[this.pos++] & 0xFFL) << 24) + (((long)this.buffer[this.pos++] & 0xFFL) << 16) + (((long)this.buffer[this.pos++] & 0xFFL) << 8) + (((long)this.buffer[this.pos++] & 0xFFL) << 0);
    }

    protected long readNetworkSixByteLong() throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(6, true);
        return (((long)this.buffer[this.pos++] & 0xFFL) << 40) + (((long)this.buffer[this.pos++] & 0xFFL) << 32) + (((long)this.buffer[this.pos++] & 0xFFL) << 24) + (((long)this.buffer[this.pos++] & 0xFFL) << 16) + (((long)this.buffer[this.pos++] & 0xFFL) << 8) + (((long)this.buffer[this.pos++] & 0xFFL) << 0);
    }

    protected long readLong(int byteOrder) throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(8, true);
        long l = SignedBinary.getLong(this.buffer, this.pos, byteOrder);
        this.pos += 8;
        return l;
    }

    protected float readFloat(int byteOrder) throws DRDAProtocolException {
        return Float.intBitsToFloat(this.readInt(byteOrder));
    }

    protected double readDouble(int byteOrder) throws DRDAProtocolException {
        return Double.longBitsToDouble(this.readLong(byteOrder));
    }

    protected BigDecimal readBigDecimal(int precision, int scale) throws DRDAProtocolException {
        int length = precision / 2 + 1;
        this.ensureBLayerDataInBuffer(length, true);
        int signum = (this.buffer[this.pos + length - 1] & 0xF) == 13 ? -1 : 1;
        if (precision <= 18) {
            long value = this.packedNybblesToLong(this.buffer, this.pos, 0, length * 2 - 1);
            if (signum < 0) {
                value = -value;
            }
            this.pos += length;
            return BigDecimal.valueOf(value, scale);
        }
        if (precision <= 27) {
            int lo = this.packedNybblesToInt(this.buffer, this.pos, (length - 5) * 2, 9);
            int me = this.packedNybblesToInt(this.buffer, this.pos, (length - 10) * 2 + 1, 9);
            int hi = this.packedNybblesToInt(this.buffer, this.pos, 0, (length - 10) * 2 + 1);
            int[] value = this.computeMagnitude(new int[]{hi, me, lo});
            byte[] magnitude = new byte[]{(byte)(value[0] >>> 24), (byte)(value[0] >>> 16), (byte)(value[0] >>> 8), (byte)value[0], (byte)(value[1] >>> 24), (byte)(value[1] >>> 16), (byte)(value[1] >>> 8), (byte)value[1], (byte)(value[2] >>> 24), (byte)(value[2] >>> 16), (byte)(value[2] >>> 8), (byte)value[2]};
            this.pos += length;
            return new BigDecimal(new BigInteger(signum, magnitude), scale);
        }
        if (precision <= 31) {
            int lo = this.packedNybblesToInt(this.buffer, this.pos, (length - 5) * 2, 9);
            int meLo = this.packedNybblesToInt(this.buffer, this.pos, (length - 10) * 2 + 1, 9);
            int meHi = this.packedNybblesToInt(this.buffer, this.pos, (length - 14) * 2, 9);
            int hi = this.packedNybblesToInt(this.buffer, this.pos, 0, (length - 14) * 2);
            int[] value = this.computeMagnitude(new int[]{hi, meHi, meLo, lo});
            byte[] magnitude = new byte[]{(byte)(value[0] >>> 24), (byte)(value[0] >>> 16), (byte)(value[0] >>> 8), (byte)value[0], (byte)(value[1] >>> 24), (byte)(value[1] >>> 16), (byte)(value[1] >>> 8), (byte)value[1], (byte)(value[2] >>> 24), (byte)(value[2] >>> 16), (byte)(value[2] >>> 8), (byte)value[2], (byte)(value[3] >>> 24), (byte)(value[3] >>> 16), (byte)(value[3] >>> 8), (byte)value[3]};
            this.pos += length;
            return new BigDecimal(new BigInteger(signum, magnitude), scale);
        }
        this.pos += length;
        throw new IllegalArgumentException("Decimal may only be up to 31 digits!");
    }

    EXTDTAReaderInputStream getEXTDTAReaderInputStream(boolean checkNullability) throws DRDAProtocolException {
        if (checkNullability && this.isEXTDTANull()) {
            return null;
        }
        boolean readEXTDTAStatusByte = this.agent.getSession().appRequester.supportsEXTDTAAbort();
        if (this.doingLayerBStreaming) {
            return new LayerBStreamedEXTDTAReaderInputStream(this, readEXTDTAStatusByte);
        }
        return new StandardEXTDTAReaderInputStream(this, readEXTDTAStatusByte);
    }

    ByteArrayInputStream readLOBInitStream() throws DRDAProtocolException {
        SanityManager.ASSERT(this.doingLayerBStreaming);
        return this.readLOBInitStream(0L);
    }

    ByteArrayInputStream readLOBInitStream(long desiredLength) throws DRDAProtocolException {
        return this.readLOBChunk(false, desiredLength);
    }

    ByteArrayInputStream readLOBContinuationStream() throws IOException {
        SanityManager.ASSERT(this.doingLayerBStreaming);
        return this.readLOBContinuationStream(0L);
    }

    ByteArrayInputStream readLOBContinuationStream(long desiredLength) throws IOException {
        try {
            return this.readLOBChunk(true, desiredLength);
        }
        catch (DRDAProtocolException e) {
            e.printStackTrace(this.agent.getServer().logWriter());
            throw new IOException(e.getMessage());
        }
    }

    private ByteArrayInputStream readLOBChunk(boolean readHeader, long desiredLength) throws DRDAProtocolException {
        if (readHeader) {
            this.readDSSContinuationHeader();
        }
        int copySize = this.doingLayerBStreaming ? this.dssLength : (int)Math.min((long)this.dssLength, desiredLength);
        this.ensureALayerDataInBuffer(copySize);
        if (!this.doingLayerBStreaming) {
            this.adjustLengths(copySize);
        } else {
            this.dssLength -= copySize;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(this.buffer, this.pos, copySize);
        this.pos += copySize;
        if (this.doingLayerBStreaming && !this.dssIsContinued) {
            this.finishLayerBStreaming();
        }
        return bais;
    }

    byte[] getExtData(long desiredLength, boolean checkNullability) throws DRDAProtocolException {
        boolean readHeader;
        ByteArrayOutputStream baos;
        SanityManager.ASSERT(!this.doingLayerBStreaming);
        boolean isLengthAndNullabilityUnknown = false;
        if (desiredLength != -1L) {
            baos = new ByteArrayOutputStream((int)desiredLength);
        } else {
            baos = new ByteArrayOutputStream();
            desiredLength = Long.MAX_VALUE;
        }
        if (checkNullability && this.isEXTDTANull()) {
            return null;
        }
        int copySize = (int)Math.min((long)this.dssLength, desiredLength);
        do {
            readHeader = this.dssIsContinued;
            this.ensureALayerDataInBuffer(copySize);
            this.adjustLengths(copySize);
            baos.write(this.buffer, this.pos, copySize);
            this.pos += copySize;
            desiredLength -= (long)copySize;
            if (readHeader) {
                this.readDSSContinuationHeader();
            }
            copySize = (int)Math.min((long)this.dssLength, desiredLength);
        } while (readHeader && desiredLength > 0L);
        return baos.toByteArray();
    }

    private void readDSSContinuationHeader() throws DRDAProtocolException {
        this.ensureALayerDataInBuffer(2);
        this.dssLength = ((this.buffer[this.pos++] & 0xFF) << 8) + ((this.buffer[this.pos++] & 0xFF) << 0);
        if ((this.dssLength & 0x8000) == 32768) {
            this.dssLength = Short.MAX_VALUE;
            this.dssIsContinued = true;
        } else {
            this.dssIsContinued = false;
        }
        if (this.dssLength <= 2) {
            this.agent.throwSyntaxrm(22, 0);
        }
        this.dssLength -= 2;
    }

    private boolean isEXTDTANull() throws DRDAProtocolException {
        this.ensureALayerDataInBuffer(1);
        this.adjustLengths(1);
        byte nullByte = this.buffer[this.pos++];
        return nullByte != 0;
    }

    private int packedNybblesToInt(byte[] buffer, int offset, int startNybble, int numberOfNybbles) {
        int value = 0;
        int i = startNybble / 2;
        if (startNybble % 2 != 0) {
            value += buffer[offset + i] & 0xF;
            ++i;
        }
        int endNybble = startNybble + numberOfNybbles - 1;
        while (i < (endNybble + 1) / 2) {
            value = value * 10 + ((buffer[offset + i] & 0xF0) >>> 4);
            value = value * 10 + (buffer[offset + i] & 0xF);
            ++i;
        }
        if (endNybble % 2 == 0) {
            value = value * 10 + ((buffer[offset + i] & 0xF0) >>> 4);
        }
        return value;
    }

    private long packedNybblesToLong(byte[] buffer, int offset, int startNybble, int numberOfNybbles) {
        long value = 0L;
        int i = startNybble / 2;
        if (startNybble % 2 != 0) {
            value += (long)(buffer[offset + i] & 0xF);
            ++i;
        }
        int endNybble = startNybble + numberOfNybbles - 1;
        while (i < (endNybble + 1) / 2) {
            value = value * 10L + (long)((buffer[offset + i] & 0xF0) >>> 4);
            value = value * 10L + (long)(buffer[offset + i] & 0xF);
            ++i;
        }
        if (endNybble % 2 == 0) {
            value = value * 10L + (long)((buffer[offset + i] & 0xF0) >>> 4);
        }
        return value;
    }

    private int[] computeMagnitude(int[] input) {
        int length = input.length;
        int[] mag = new int[length];
        mag[length - 1] = input[length - 1];
        for (int i = 0; i < length - 1; ++i) {
            int carry = 0;
            int j = tenRadixMagnitude[i].length - 1;
            int k = length - 1;
            while (j >= 0) {
                long product = ((long)input[length - 2 - i] & 0xFFFFFFFFL) * ((long)tenRadixMagnitude[i][j] & 0xFFFFFFFFL) + ((long)mag[k] & 0xFFFFFFFFL) + ((long)carry & 0xFFFFFFFFL);
                carry = (int)(product >>> 32);
                mag[k] = (int)(product & 0xFFFFFFFFL);
                --j;
                --k;
            }
            mag[k] = carry;
        }
        return mag;
    }

    protected String readEncryptedString(DecryptionManager decryptM, int securityMechanism, byte[] initVector, byte[] sourcePublicKey) throws DRDAProtocolException, SQLException {
        byte[] cipherText = this.readBytes();
        byte[] plainText = null;
        plainText = decryptM.decryptData(cipherText, securityMechanism, initVector, sourcePublicKey);
        if (plainText == null) {
            return null;
        }
        return this.ccsidManager.convertToJavaString(plainText);
    }

    protected String readString(int length) throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(length, true);
        String result = this.ccsidManager.convertToJavaString(this.buffer, this.pos, length);
        this.pos += length;
        return result;
    }

    protected void readString(DRDAString dst, int size, boolean unpad) throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(size, true);
        int startPos = this.pos;
        this.pos += size;
        if (unpad) {
            while (size > 0 && this.buffer[startPos + size - 1] == this.ccsidManager.space) {
                --size;
            }
        }
        dst.setBytes(this.buffer, startPos, size);
    }

    protected String readString(int length, String encoding) throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(length, true);
        String s = null;
        try {
            s = new String(this.buffer, this.pos, length, encoding);
        }
        catch (UnsupportedEncodingException e) {
            this.agent.agentError("UnsupportedEncodingException in readString, encoding = " + encoding);
            e.printStackTrace(this.agent.getServer().logWriter());
        }
        this.pos += length;
        return s;
    }

    protected String readStringData(int length) throws DRDAProtocolException {
        return this.readString(length, "UTF8");
    }

    protected String readLDStringData(String encoding) throws DRDAProtocolException {
        int length = this.readNetworkShort();
        return this.readString(length, encoding);
    }

    protected String readString() throws DRDAProtocolException {
        return this.readString((int)this.ddmScalarLen);
    }

    protected byte[] readBytes(int length) throws DRDAProtocolException {
        byte[] b;
        if (length < Short.MAX_VALUE) {
            this.ensureBLayerDataInBuffer(length, true);
            b = new byte[length];
            System.arraycopy(this.buffer, this.pos, b, 0, length);
            this.pos += length;
        } else {
            b = this.getExtData(length, false);
        }
        return b;
    }

    protected byte[] readBytes() throws DRDAProtocolException {
        return this.readBytes((int)this.ddmScalarLen);
    }

    protected void skipBytes(int length) throws DRDAProtocolException {
        this.ensureBLayerDataInBuffer(length, true);
        this.pos += length;
    }

    protected void skipBytes() throws DRDAProtocolException {
        this.skipBytes((int)this.ddmScalarLen);
    }

    protected void skipDss() throws DRDAProtocolException {
        while (this.dssIsContinued) {
            this.skipBytes(this.dssLength);
            this.readDSSContinuationHeader();
        }
        this.skipBytes(this.dssLength);
        this.topDdmCollectionStack = -1;
        this.ddmScalarLen = 0L;
        this.dssLength = 0;
    }

    protected void clearBuffer() throws DRDAProtocolException {
        this.skipBytes(Math.min(this.dssLength, this.count - this.pos));
        this.dssIsChainedWithSameID = false;
        this.dssIsChainedWithDiffID = false;
    }

    protected String convertBytes(byte[] buf) {
        return this.ccsidManager.convertToJavaString(buf, 0, buf.length);
    }

    private void adjustLengths(int length) {
        this.ddmScalarLen -= (long)length;
        int i = 0;
        while (i <= this.topDdmCollectionStack) {
            int n = i++;
            this.ddmCollectionLenStack[n] = this.ddmCollectionLenStack[n] - (long)length;
        }
        this.dssLength -= length;
    }

    protected String readCmdString(int length) throws DRDAProtocolException, UnsupportedEncodingException {
        if (length == 0) {
            return null;
        }
        this.ensureBLayerDataInBuffer(length, true);
        String result = new String(this.buffer, this.pos, length, "UTF8");
        this.pos += length;
        return result;
    }

    protected String readCmdString() throws DRDAProtocolException, UnsupportedEncodingException {
        int length = this.readNetworkShort();
        return this.readCmdString(length);
    }

    private void ensureALayerDataInBuffer(int desiredDataSize) throws DRDAProtocolException {
        int avail = this.count - this.pos;
        if (avail < desiredDataSize) {
            this.fill(desiredDataSize - avail);
        }
    }

    private void ensureBLayerDataInBuffer(int desiredDataSize, boolean adjustLen) throws DRDAProtocolException {
        if (this.dssIsContinued && desiredDataSize > this.dssLength) {
            int continueDssHeaderCount = (desiredDataSize - this.dssLength) / Short.MAX_VALUE + 1;
            this.ensureALayerDataInBuffer(desiredDataSize + 2 * continueDssHeaderCount);
            this.compressBLayerData(continueDssHeaderCount);
        } else {
            this.ensureALayerDataInBuffer(desiredDataSize);
        }
        if (adjustLen) {
            this.adjustLengths(desiredDataSize);
        }
    }

    private void compressBLayerData(int continueDssHeaderCount) throws DRDAProtocolException {
        int tempPos = 0;
        for (int i = 0; i < continueDssHeaderCount; ++i) {
            if (i == 0) {
                tempPos = this.pos + this.dssLength;
                continue;
            }
            tempPos += Short.MAX_VALUE;
        }
        int shiftSize = 0;
        int bytesToShift = 0;
        int continueHeaderLength = 0;
        int newdssLength = 0;
        for (int i = 0; i < continueDssHeaderCount; ++i) {
            continueHeaderLength = ((this.buffer[tempPos] & 0xFF) << 8) + ((this.buffer[tempPos + 1] & 0xFF) << 0);
            if (i == 0) {
                if ((continueHeaderLength & 0x8000) == 32768) {
                    continueHeaderLength = Short.MAX_VALUE;
                    this.dssIsContinued = true;
                } else {
                    this.dssIsContinued = false;
                }
                shiftSize = 2;
            } else {
                if ((continueHeaderLength & 0x8000) == 32768) {
                    continueHeaderLength = Short.MAX_VALUE;
                } else {
                    this.agent.throwSyntaxrm(2, 0);
                }
                shiftSize += 2;
            }
            if (continueHeaderLength <= 2) {
                this.agent.throwSyntaxrm(22, 0);
            }
            newdssLength += continueHeaderLength - 2;
            bytesToShift = i != continueDssHeaderCount - 1 ? Short.MAX_VALUE : this.dssLength;
            System.arraycopy(this.buffer, (tempPos -= bytesToShift - 2) - shiftSize, this.buffer, tempPos, bytesToShift);
        }
        this.pos = tempPos;
        this.dssLength += newdssLength;
    }

    private void shiftBuffer(byte[] destinationBuffer) {
        int sz = this.count - this.pos;
        if (sz < 0 || this.pos < 0) {
            SanityManager.THROWASSERT("Unexpected data size or position. sz=" + sz + " count=" + this.count + " pos=" + this.pos);
        }
        System.arraycopy(this.buffer, this.pos, destinationBuffer, 0, sz);
        this.pos = 0;
        this.count = sz;
        this.buffer = destinationBuffer;
    }

    private void ensureSpaceInBufferForFill(int desiredSpace) {
        int currentAvailableSpace = this.buffer.length - this.count + this.pos;
        if (currentAvailableSpace < desiredSpace) {
            int minumNewBufferSize = desiredSpace - currentAvailableSpace + this.buffer.length;
            int doubleBufferSize = 2 * this.buffer.length;
            int newsz = minumNewBufferSize <= doubleBufferSize ? doubleBufferSize : minumNewBufferSize;
            byte[] newBuffer = new byte[newsz];
            this.shiftBuffer(newBuffer);
        } else if (this.pos != 0) {
            this.shiftBuffer(this.buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fill(int minimumBytesNeeded) throws DRDAProtocolException {
        this.ensureSpaceInBufferForFill(minimumBytesNeeded);
        int totalBytesRead = 0;
        int actualBytesRead = 0;
        do {
            try {
                actualBytesRead = this.inputStream.read(this.buffer, this.count, this.buffer.length - this.count);
            }
            catch (SocketTimeoutException ste) {
                throw new DRDASocketTimeoutException(this.agent);
            }
            catch (IOException ioe) {
                this.agent.markCommunicationsFailure("DDMReader.fill()", "InputStream.read()", ioe.getMessage(), "*");
            }
            finally {
                if (this.dssTrace != null && this.dssTrace.isComBufferTraceOn()) {
                    this.dssTrace.writeComBufferData(this.buffer, this.count, actualBytesRead, 2, "Request", "fill", 5);
                }
            }
            if (actualBytesRead == -1) continue;
            this.count += actualBytesRead;
            totalBytesRead += actualBytesRead;
        } while (totalBytesRead < minimumBytesNeeded && actualBytesRead != -1);
        if (actualBytesRead == -1 && totalBytesRead < minimumBytesNeeded) {
            this.agent.markCommunicationsFailure("DDMReader.fill()", "InputStream.read()", "insufficient data", "*");
        }
        this.totalByteCount += (long)totalBytesRead;
    }

    private void trace(String msg) {
        if (this.agent != null) {
            this.agent.trace(msg);
        }
    }

    protected byte getCurrChainState() {
        if (!this.dssIsChainedWithSameID && !this.dssIsChainedWithDiffID) {
            return 0;
        }
        if (this.dssIsChainedWithSameID) {
            return 80;
        }
        return 64;
    }

    private void startLayerBStreaming() {
        this.doingLayerBStreaming = true;
    }

    private void finishLayerBStreaming() {
        this.doingLayerBStreaming = false;
    }

    boolean doingLayerBStreaming() {
        return this.doingLayerBStreaming;
    }
}

