/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Properties;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.iapi.util.PropertyUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.execute.rts.RealHashScanStatistics;
import org.apache.derby.shared.common.i18n.MessageService;

public class RealDistinctScanStatistics
extends RealHashScanStatistics {
    public RealDistinctScanStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, String tableName, String indexName, boolean isConstraint, int hashtableSize, int[] hashKeyColumns, String scanQualifiers, String nextQualifiers, Properties scanProperties, String startPosition, String stopPosition, String isolationLevel, String lockString, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(numOpens, rowsSeen, rowsFiltered, constructorTime, openTime, nextTime, closeTime, resultSetNumber, tableName, indexName, isConstraint, hashtableSize, hashKeyColumns, scanQualifiers, nextQualifiers, scanProperties, startPosition, stopPosition, isolationLevel, lockString, optimizerEstimatedRowCount, optimizerEstimatedCost);
    }

    @Override
    public String getStatementExecutionPlanText(int depth) {
        String hashKeyColumnString;
        Object isolationString = null;
        this.initFormatInfo(depth);
        String header = this.indexName != null ? this.indent + MessageService.getTextMessage("43X23.U", this.tableName, this.isConstraint ? "constraint" : "index", this.indexName) : this.indent + MessageService.getTextMessage("43X26.U", this.tableName);
        header = header + " " + MessageService.getTextMessage("43X27.U", this.isolationLevel, this.lockString) + ": \n";
        String scanInfo = this.indent + MessageService.getTextMessage("43X28.U", new Object[0]) + ": \n" + PropertyUtil.sortProperties(this.scanProperties, this.subIndent);
        if (this.hashKeyColumns.length == 1) {
            hashKeyColumnString = MessageService.getTextMessage("43X29.U", new Object[0]) + " " + this.hashKeyColumns[0];
        } else {
            hashKeyColumnString = MessageService.getTextMessage("43X30.U", new Object[0]) + " (" + this.hashKeyColumns[0];
            for (int index = 1; index < this.hashKeyColumns.length; ++index) {
                hashKeyColumnString = hashKeyColumnString + "," + this.hashKeyColumns[index];
            }
            hashKeyColumnString = hashKeyColumnString + ")";
        }
        return header + this.indent + MessageService.getTextMessage("43X03.U", new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X31.U", new Object[0]) + " = " + this.hashtableSize + "\n" + this.indent + hashKeyColumnString + "\n" + this.indent + MessageService.getTextMessage("43X04.U", new Object[0]) + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage("43X32.U", new Object[0]) + " = " + this.rowsFiltered + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + (String)(this.rowsSeen > 0 ? this.subIndent + MessageService.getTextMessage("43X33.U", new Object[0]) + " = " + this.nextTime / (long)this.rowsSeen + "\n" : "") + "\n" + scanInfo + this.subIndent + MessageService.getTextMessage("43X34.U", new Object[0]) + ":\n" + StringUtil.ensureIndent(this.startPosition, depth + 2) + "\n" + this.subIndent + MessageService.getTextMessage("43X35.U", new Object[0]) + ":\n" + StringUtil.ensureIndent(this.stopPosition, depth + 2) + "\n" + this.subIndent + MessageService.getTextMessage("43X36.U", new Object[0]) + ":\n" + StringUtil.ensureIndent(this.scanQualifiers, depth + 2) + "\n" + this.subIndent + MessageService.getTextMessage("43X37.U", new Object[0]) + ":\n" + StringUtil.ensureIndent(this.nextQualifiers, depth + 2) + "\n" + this.dumpEstimatedCosts(this.subIndent);
    }

    @Override
    public String getScanStatisticsText(String tableName, int depth) {
        if (tableName == null || tableName.equals(this.tableName)) {
            return this.getStatementExecutionPlanText(depth);
        }
        return "";
    }

    @Override
    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public String getNodeOn() {
        return MessageService.getTextMessage("43X38.U", this.tableName, this.indexName);
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage("43X39.U", new Object[0]);
    }

    @Override
    public void accept(XPLAINVisitor visitor) {
        visitor.setNumberOfChildren(0);
        visitor.visit(this);
    }

    @Override
    public String getRSXplainType() {
        return "DISTINCTSCAN";
    }
}

