/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.company;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VAT implements Enumerator
{
    VAT0(0, "vat0", "vat0"),
    VAT7(7, "vat7", "vat7"),
    VAT15(15, "vat15", "vat15");

    public static final int VAT0_VALUE = 0;
    public static final int VAT7_VALUE = 7;
    public static final int VAT15_VALUE = 15;
    private static final VAT[] VALUES_ARRAY;
    public static final List<VAT> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VAT[]{VAT0, VAT7, VAT15};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VAT get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VAT result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VAT getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VAT result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VAT get(int value) {
        switch (value) {
            case 0: {
                return VAT0;
            }
            case 7: {
                return VAT7;
            }
            case 15: {
                return VAT15;
            }
        }
        return null;
    }

    private VAT(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

