/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.AliasInfo;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.types.DataTypeDescriptor;

public class AggregateAliasInfo
implements AliasInfo,
Formatable {
    private static final int FIRST_VERSION = 0;
    private TypeDescriptor _forType;
    private TypeDescriptor _returnType;

    public AggregateAliasInfo() {
    }

    public AggregateAliasInfo(TypeDescriptor forType, TypeDescriptor returnType) {
        this._forType = forType;
        this._returnType = returnType;
    }

    @Override
    public boolean isTableFunction() {
        return false;
    }

    public TypeDescriptor getForType() {
        return this._forType;
    }

    public TypeDescriptor getReturnType() {
        return this._returnType;
    }

    public void setCollationTypeForAllStringTypes(int collationType) {
        this._forType = DataTypeDescriptor.getCatalogType(this._forType, collationType);
        this._returnType = DataTypeDescriptor.getCatalogType(this._returnType, collationType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int oldVersion = in.readInt();
        this._forType = (TypeDescriptor)in.readObject();
        this._returnType = (TypeDescriptor)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(0);
        out.writeObject(this._forType);
        out.writeObject(this._returnType);
    }

    @Override
    public int getTypeFormatId() {
        return 475;
    }

    public String toString() {
        return "FOR " + this._forType.getSQLstring() + " RETURNS " + this._returnType.getSQLstring();
    }

    @Override
    public String getMethodName() {
        return null;
    }
}

