/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.iapi.types.PositionedStream;
import org.apache.derby.impl.jdbc.LOBStreamControl;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.shared.common.error.ExceptionUtil;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.sanity.SanityManager;

public class LOBInputStream
extends InputStream
implements PositionedStream {
    private boolean closed = false;
    private final LOBStreamControl control;
    private long pos;
    private long updateCount;

    LOBInputStream(LOBStreamControl control, long position) {
        this.control = control;
        this.pos = position;
        this.updateCount = control.getUpdateCount();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("J104", new Object[0]));
        }
        try {
            int ret = this.control.read(b, off, len, this.pos);
            if (ret != -1) {
                this.pos += (long)ret;
                return ret;
            }
            return -1;
        }
        catch (StandardException se) {
            String state = se.getSQLState();
            if (state.equals(ExceptionUtil.getSQLStateFromIdentifier("XJ076.S"))) {
                return -1;
            }
            if (state.equals(ExceptionUtil.getSQLStateFromIdentifier("XJ078.S"))) {
                throw new ArrayIndexOutOfBoundsException(se.getMessage());
            }
            throw Util.newIOException(se);
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            throw new IOException(MessageService.getTextMessage("J104", new Object[0]));
        }
        try {
            int ret = this.control.read(this.pos);
            if (ret != -1) {
                ++this.pos;
            }
            return ret;
        }
        catch (StandardException se) {
            throw Util.newIOException(se);
        }
    }

    boolean isObsolete() {
        return this.updateCount != this.control.getUpdateCount();
    }

    void reInitialize() {
        this.updateCount = this.control.getUpdateCount();
        this.pos = 0L;
    }

    long length() throws IOException {
        return this.control.getLength();
    }

    @Override
    public InputStream asInputStream() {
        return this;
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public void reposition(long requestedPos) throws IOException {
        if (requestedPos < 0L) {
            SanityManager.THROWASSERT("Negative position: " + requestedPos);
        }
        if (requestedPos > this.length()) {
            this.pos = 0L;
            throw new EOFException();
        }
        this.pos = requestedPos;
    }
}

