/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.shared.common.i18n.MessageService;

public class RealSetOpResultSetStatistics
extends RealNoPutResultSetStatistics {
    public int opType;
    public int rowsSeenLeft;
    public int rowsSeenRight;
    public int rowsReturned;
    public ResultSetStatistics leftResultSetStatistics;
    public ResultSetStatistics rightResultSetStatistics;

    public RealSetOpResultSetStatistics(int opType, int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, int rowsSeenLeft, int rowsSeenRight, int rowsReturned, double optimizerEstimatedRowCount, double optimizerEstimatedCost, ResultSetStatistics leftResultSetStatistics, ResultSetStatistics rightResultSetStatistics) {
        super(numOpens, rowsSeen, rowsFiltered, constructorTime, openTime, nextTime, closeTime, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.opType = opType;
        this.rowsSeenLeft = rowsSeenLeft;
        this.rowsSeenRight = rowsSeenRight;
        this.rowsReturned = rowsReturned;
        this.leftResultSetStatistics = leftResultSetStatistics;
        this.rightResultSetStatistics = rightResultSetStatistics;
    }

    @Override
    public String getStatementExecutionPlanText(int depth) {
        this.initFormatInfo(depth);
        String rs = this.opType == 1 ? "INTERSECT ResultSet" : "EXCEPT ResultSet";
        return this.indent + MessageService.getTextMessage(rs, new Object[0]) + ":\n" + this.indent + MessageService.getTextMessage("43X03.U", new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage("43X79.U", new Object[0]) + " = " + this.rowsSeenLeft + "\n" + this.indent + MessageService.getTextMessage("43X80.U", new Object[0]) + " = " + this.rowsSeenRight + "\n" + this.indent + MessageService.getTextMessage("43X81.U", new Object[0]) + " = " + this.rowsReturned + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + this.dumpEstimatedCosts(this.subIndent) + "\n" + this.indent + MessageService.getTextMessage("43X82.U", new Object[0]) + ":\n" + this.leftResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n" + this.indent + MessageService.getTextMessage("43X83.U", new Object[0]) + ":\n" + this.rightResultSetStatistics.getStatementExecutionPlanText(this.sourceDepth) + "\n";
    }

    @Override
    public String getScanStatisticsText(String tableName, int depth) {
        return this.leftResultSetStatistics.getScanStatisticsText(tableName, depth) + this.rightResultSetStatistics.getScanStatisticsText(tableName, depth);
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public Vector<ResultSetStatistics> getChildren() {
        Vector<ResultSetStatistics> children = new Vector<ResultSetStatistics>();
        children.addElement(this.leftResultSetStatistics);
        children.addElement(this.rightResultSetStatistics);
        return children;
    }

    @Override
    public String getNodeName() {
        String nodeName = this.opType == 1 ? "INTERSECT" : "EXCEPT";
        return MessageService.getTextMessage(nodeName, new Object[0]);
    }

    @Override
    public void accept(XPLAINVisitor visitor) {
        int noChildren = 0;
        if (this.leftResultSetStatistics != null) {
            ++noChildren;
        }
        if (this.rightResultSetStatistics != null) {
            ++noChildren;
        }
        visitor.setNumberOfChildren(noChildren);
        visitor.visit(this);
        if (this.leftResultSetStatistics != null) {
            this.leftResultSetStatistics.accept(visitor);
        }
        if (this.rightResultSetStatistics != null) {
            this.rightResultSetStatistics.accept(visitor);
        }
    }

    @Override
    public String getRSXplainType() {
        return "SET";
    }

    @Override
    public String getRSXplainDetails() {
        String op_details = "(" + this.resultSetNumber + ")";
        op_details = op_details + (this.opType == 1 ? ", INTERSECT" : ", EXCEPT");
        return op_details;
    }

    @Override
    public Object getResultSetDescriptor(Object rsID, Object parentID, Object scanID, Object sortID, Object stmtID, Object timingID) {
        return new XPLAINResultSetDescriptor((UUID)rsID, this.getRSXplainType(), this.getRSXplainDetails(), this.numOpens, null, null, null, (UUID)parentID, this.optimizerEstimatedRowCount, this.optimizerEstimatedCost, null, null, null, this.rowsSeenLeft, this.rowsSeenRight, this.rowsFiltered, this.rowsReturned, null, null, (UUID)scanID, (UUID)sortID, (UUID)stmtID, (UUID)timingID);
    }
}

