/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.compare;

import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.ui.compare.CDOCompareEditorUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.internal.cdo.transaction.CDOHandlingConflictResolver;
import org.eclipse.emf.spi.cdo.CDOMergingConflictResolver;
import org.eclipse.net4j.util.factory.ProductCreationException;

public class CompareConflictHandler
implements CDOHandlingConflictResolver.ConflictHandler {
    public String getLabel() {
        return "Merge";
    }

    public int getPriority() {
        return 400;
    }

    public boolean canHandleConflict(CDOMergingConflictResolver conflictResolver, long lastNonConflictTimeStamp) {
        CDOTransaction transaction = conflictResolver.getTransaction();
        return transaction.getSession().getRepositoryInfo().isSupportingAudits();
    }

    public boolean handleConflict(CDOMergingConflictResolver conflictResolver, long lastNonConflictTimeStamp) {
        CDOTransaction transaction = conflictResolver.getTransaction();
        try (CDOView remoteView = transaction.getSession().openView((CDOBranchPoint)transaction);){
            CDOCompareEditorUtil.setSuppressCommit(true);
            boolean bl = CDOCompareEditorUtil.openDialog(remoteView, (CDOView)transaction, null);
            return bl;
        }
    }

    public static class Factory
    extends CDOHandlingConflictResolver.ConflictHandler.Factory {
        public static final String TYPE = "merge";

        public Factory() {
            super(TYPE);
        }

        public CDOHandlingConflictResolver.ConflictHandler create(String description) throws ProductCreationException {
            return new CompareConflictHandler();
        }
    }
}

