/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.jms.internal.server.protocol;

import org.eclipse.net4j.internal.jms.DestinationImpl;
import org.eclipse.net4j.internal.jms.util.DestinationUtil;
import org.eclipse.net4j.jms.internal.server.ServerConnection;
import org.eclipse.net4j.jms.internal.server.ServerSession;
import org.eclipse.net4j.jms.internal.server.protocol.JMSServerProtocol;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

public class JMSRegisterConsumerIndication
extends IndicationWithResponse {
    private long consumerID;

    public JMSRegisterConsumerIndication(JMSServerProtocol protocol) {
        super((SignalProtocol)protocol, (short)6);
    }

    protected void indicating(ExtendedDataInputStream in) throws Exception {
        int sessionID = in.readInt();
        DestinationImpl destination = DestinationUtil.read((ExtendedDataInputStream)in);
        String messageSelector = in.readString();
        boolean noLocal = in.readBoolean();
        boolean durable = in.readBoolean();
        JMSServerProtocol protocol = (JMSServerProtocol)this.getProtocol();
        ServerConnection connection = (ServerConnection)protocol.getInfraStructure();
        ServerSession session = connection.getSession(sessionID);
        this.consumerID = session.registerConsumer(destination, messageSelector, noLocal, durable);
    }

    protected void responding(ExtendedDataOutputStream out) throws Exception {
        out.writeLong(this.consumerID);
    }
}

