/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.net4j.util.io.DelegatingInputStream;

public class XORInputStream
extends DelegatingInputStream {
    private int[] key;
    private int index;

    public XORInputStream(InputStream in, int ... key) {
        super(in);
        this.key = key;
    }

    public int[] getKey() {
        return this.key;
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b != -1 && this.key != null && this.key.length != 0) {
            if (this.index == this.key.length) {
                this.index = 0;
            }
            b = b & 0xFF ^ this.key[this.index++] & 0xFF;
        }
        return b;
    }
}

