/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.security;

import java.nio.ByteBuffer;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.fsm.ITransition;
import org.eclipse.net4j.util.security.IChallengeResponse;
import org.eclipse.net4j.util.security.INegotiationContext;
import org.eclipse.net4j.util.security.Negotiator;
import org.eclipse.net4j.util.security.SecurityUtil;

public abstract class ChallengeResponseNegotiator
extends Negotiator<IChallengeResponse.State, IChallengeResponse.Event>
implements IChallengeResponse {
    private String encryptionAlgorithmName = "PBEWithMD5AndDES";
    private byte[] encryptionSaltBytes = SecurityUtil.DEFAULT_SALT;
    private int encryptionIterationCount = 20;

    public ChallengeResponseNegotiator(boolean initiator) {
        super(IChallengeResponse.State.class, IChallengeResponse.Event.class, IChallengeResponse.State.INITIAL, IChallengeResponse.State.SUCCESS, IChallengeResponse.State.FAILURE, IChallengeResponse.Event.START, IChallengeResponse.Event.BUFFER, initiator);
        this.init(IChallengeResponse.State.INITIAL, IChallengeResponse.Event.START, new Transition(this){

            @Override
            protected void execute(INegotiationContext context, ByteBuffer NULL) {
                ByteBuffer challenge = context.getBuffer();
                this.createChallenge(context, challenge);
                context.transmitBuffer(challenge);
                this.changeState(context, IChallengeResponse.State.CHALLENGE);
            }
        });
        this.init(IChallengeResponse.State.INITIAL, IChallengeResponse.Event.BUFFER, new Transition(this){

            @Override
            protected void execute(INegotiationContext context, ByteBuffer challenge) {
                ByteBuffer response = context.getBuffer();
                this.handleChallenge(context, challenge, response);
                context.transmitBuffer(response);
                this.changeState(context, IChallengeResponse.State.RESPONSE);
            }
        });
        this.init(IChallengeResponse.State.CHALLENGE, IChallengeResponse.Event.BUFFER, new Transition(this){

            @Override
            protected void execute(INegotiationContext context, ByteBuffer response) {
                boolean success = this.handleResponse(context, response);
                ByteBuffer acknowledgement = context.getBuffer();
                acknowledgement.put(success ? (byte)1 : 0);
                context.transmitBuffer(acknowledgement);
                ConcurrencyUtil.sleep(500L);
                this.changeState(context, success ? IChallengeResponse.State.SUCCESS : IChallengeResponse.State.FAILURE);
            }
        });
        this.init(IChallengeResponse.State.RESPONSE, IChallengeResponse.Event.BUFFER, new Transition(this){

            @Override
            protected void execute(INegotiationContext context, ByteBuffer acknowledgement) {
                boolean success = acknowledgement.get() == 1;
                this.changeState(context, success ? IChallengeResponse.State.SUCCESS : IChallengeResponse.State.FAILURE);
                this.handleAcknowledgement(context, success);
            }
        });
    }

    public String getEncryptionAlgorithmName() {
        return this.encryptionAlgorithmName;
    }

    public void setEncryptionAlgorithmName(String encryptionAlgorithmName) {
        this.encryptionAlgorithmName = encryptionAlgorithmName;
    }

    public byte[] getEncryptionSaltBytes() {
        return this.encryptionSaltBytes;
    }

    public void setEncryptionSaltBytes(byte[] encryptionSaltBytes) {
        this.encryptionSaltBytes = encryptionSaltBytes;
    }

    public int getEncryptionIterationCount() {
        return this.encryptionIterationCount;
    }

    public void setEncryptionIterationCount(int encryptionIterationCount) {
        this.encryptionIterationCount = encryptionIterationCount;
    }

    @Override
    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.encryptionAlgorithmName, "encryptionAlgorithmName");
        this.checkState(this.encryptionSaltBytes, "encryptionSaltBytes");
        this.checkState(this.encryptionSaltBytes.length > 0, "encryptionSaltBytes");
        this.checkState(this.encryptionIterationCount > 0, "encryptionIterationCount");
    }

    @Override
    protected IChallengeResponse.State getState(INegotiationContext subject) {
        return (IChallengeResponse.State)subject.getState();
    }

    @Override
    protected void setState(INegotiationContext subject, IChallengeResponse.State state) {
        subject.setState(state);
    }

    protected void createChallenge(INegotiationContext context, ByteBuffer challenge) {
        throw new UnsupportedOperationException();
    }

    protected void handleChallenge(INegotiationContext context, ByteBuffer challenge, ByteBuffer response) {
        throw new UnsupportedOperationException();
    }

    protected boolean handleResponse(INegotiationContext context, ByteBuffer response) {
        throw new UnsupportedOperationException();
    }

    protected void handleAcknowledgement(INegotiationContext context, boolean success) {
        throw new UnsupportedOperationException();
    }

    protected abstract class Transition
    implements ITransition<IChallengeResponse.State, IChallengeResponse.Event, INegotiationContext, ByteBuffer> {
        protected Transition() {
        }

        @Override
        public final void execute(INegotiationContext context, IChallengeResponse.State state, IChallengeResponse.Event event, ByteBuffer buffer) {
            this.execute(context, buffer);
        }

        protected abstract void execute(INegotiationContext var1, ByteBuffer var2);
    }
}

