/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.h2.command.Prepared;
import org.h2.engine.Database;
import org.h2.engine.SessionLocal;
import org.h2.engine.SysProperties;
import org.h2.expression.Expression;
import org.h2.message.DbException;
import org.h2.security.SHA256;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.FileStoreOutputStream;
import org.h2.store.fs.FileUtils;
import org.h2.tools.CompressTool;
import org.h2.util.IOUtils;
import org.h2.util.StringUtils;

abstract class ScriptBase
extends Prepared {
    private static final String SCRIPT_SQL = "script.sql";
    protected OutputStream out;
    protected BufferedReader reader;
    private Expression fileNameExpr;
    private Expression password;
    private String fileName;
    private String cipher;
    private FileStore store;
    private String compressionAlgorithm;
    ExecutorService executor = null;

    ScriptBase(SessionLocal sessionLocal) {
        super(sessionLocal);
    }

    public void setCipher(String string) {
        this.cipher = string;
    }

    private boolean isEncrypted() {
        return this.cipher != null;
    }

    public void setPassword(Expression expression) {
        this.password = expression;
    }

    public void setFileNameExpr(Expression expression) {
        this.fileNameExpr = expression;
    }

    protected String getFileName() {
        if (this.fileNameExpr != null && this.fileName == null) {
            this.fileName = this.fileNameExpr.optimize(this.session).getValue(this.session).getString();
            if (this.fileName == null || StringUtils.isWhitespaceOrEmpty(this.fileName)) {
                this.fileName = SCRIPT_SQL;
            }
            this.fileName = SysProperties.getScriptDirectory() + this.fileName;
        }
        return this.fileName;
    }

    @Override
    public boolean isTransactional() {
        return false;
    }

    void deleteStore() {
        String string = this.getFileName();
        if (string != null && FileUtils.isRegularFile(string)) {
            FileUtils.delete(string);
        }
    }

    private void initStore() {
        Object object;
        Database database = this.getDatabase();
        byte[] byArray = null;
        if (this.cipher != null && this.password != null) {
            object = this.password.optimize(this.session).getValue(this.session).getString().toCharArray();
            byArray = SHA256.getKeyPasswordHash("script", (char[])object);
        }
        object = this.getFileName();
        this.store = FileStore.open(database, (String)object, "rw", this.cipher, byArray);
        this.store.setCheckedWriting(false);
        this.store.init();
    }

    void openOutput() {
        String string = this.getFileName();
        if (string == null) {
            return;
        }
        if (this.isEncrypted()) {
            this.initStore();
            this.out = new FileStoreOutputStream(this.store, this.compressionAlgorithm);
            this.out = new BufferedOutputStream(this.out, 131072);
        } else {
            OutputStream outputStream;
            try {
                outputStream = FileUtils.newOutputStream(string, false);
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, null);
            }
            this.out = new BufferedOutputStream(outputStream, 4096);
            if ("kanzi".equalsIgnoreCase(this.compressionAlgorithm) && this.executor == null) {
                this.executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            }
            this.out = CompressTool.wrapOutputStream(this.out, this.compressionAlgorithm, SCRIPT_SQL, this.executor);
        }
    }

    void openInput(Charset charset) {
        InputStream inputStream;
        String string = this.getFileName();
        if (string == null) {
            return;
        }
        if (this.isEncrypted()) {
            this.initStore();
            inputStream = new FileStoreInputStream(this.store, this.compressionAlgorithm != null, false);
        } else {
            try {
                inputStream = FileUtils.newInputStream(string);
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, string);
            }
            if ("kanzi".equalsIgnoreCase(this.compressionAlgorithm) && this.executor == null) {
                this.executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            }
            if ((inputStream = CompressTool.wrapInputStream(inputStream, this.compressionAlgorithm, SCRIPT_SQL, this.executor)) == null) {
                throw DbException.get(90124, "script.sql in " + string);
            }
        }
        this.reader = new BufferedReader(new InputStreamReader(inputStream, charset), 4096);
    }

    void closeIO() {
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.executor = null;
        }
        IOUtils.closeSilently(this.out);
        this.out = null;
        IOUtils.closeSilently(this.reader);
        this.reader = null;
        if (this.store != null) {
            this.store.closeSilently();
            this.store = null;
        }
    }

    @Override
    public boolean needRecompile() {
        return false;
    }

    public void setCompressionAlgorithm(String string) {
        this.compressionAlgorithm = string;
    }
}

