/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.ocl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.cdo.server.ocl.OCLExtentCreator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class CDOExtentMap
implements Map<EClass, Set<? extends EObject>> {
    private final Map<EClass, Set<? extends EObject>> delegate = new HashMap<EClass, Set<? extends EObject>>();
    private final OCLExtentCreator extentCreator;
    private AtomicBoolean canceled = new AtomicBoolean(false);

    public CDOExtentMap(OCLExtentCreator extentCreator) {
        this.extentCreator = extentCreator;
    }

    public void cancel() {
        this.canceled.set(true);
    }

    @Override
    public Set<? extends EObject> get(Object key) {
        if (key instanceof EClass) {
            EClass cls = (EClass)key;
            Set<? extends EObject> result = this.delegate.get(cls);
            if (result == null) {
                result = this.extentCreator.createExtent(cls, this.canceled);
                this.delegate.put(cls, result);
            }
            return result;
        }
        return null;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Set<Map.Entry<EClass, Set<? extends EObject>>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Set<EClass> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Set<? extends EObject> put(EClass key, Set<? extends EObject> value) {
        return this.delegate.put(key, value);
    }

    @Override
    public void putAll(Map<? extends EClass, ? extends Set<? extends EObject>> t) {
        this.delegate.putAll(t);
    }

    @Override
    public Set<? extends EObject> remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public Collection<Set<? extends EObject>> values() {
        return this.delegate.values();
    }
}

