/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptorList;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.util.ArrayUtil;

public final class TriggerInfo
implements Formatable {
    TriggerDescriptor[] triggerArray;

    public TriggerInfo() {
    }

    public TriggerInfo(TriggerDescriptorList triggers) {
        SanityManager.ASSERT(triggers != null, "null trigger descriptor list");
        SanityManager.ASSERT(triggers.size() > 0, "trigger descriptor list has no elements");
        this.triggerArray = triggers.toArray(new TriggerDescriptor[triggers.size()]);
    }

    boolean hasTrigger(boolean isBefore, boolean isRow) {
        if (this.triggerArray == null) {
            return false;
        }
        for (int i = 0; i < this.triggerArray.length; ++i) {
            if (this.triggerArray[i].isBeforeTrigger() != isBefore || this.triggerArray[i].isRowTrigger() != isRow) continue;
            return true;
        }
        return false;
    }

    TriggerDescriptor[] getTriggerArray() {
        return this.triggerArray;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ArrayUtil.writeArray(out, this.triggerArray);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.triggerArray = new TriggerDescriptor[ArrayUtil.readArrayLength(in)];
        ArrayUtil.readArrayItems(in, this.triggerArray);
    }

    @Override
    public int getTypeFormatId() {
        return 317;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\nTriggers:");
        for (int i = 0; i < this.triggerArray.length; ++i) {
            str.append('\n');
            str.append(this.triggerArray[i]);
        }
        return str.toString();
    }
}

