/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.ui.debug.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.emf.mwe.core.debug.model.SyntaxElement;
import org.eclipse.emf.mwe.internal.core.debug.model.VarValueTO;
import org.eclipse.emf.mwe.internal.ui.debug.model.DebugElement;
import org.eclipse.emf.mwe.internal.ui.debug.model.DebugThread;
import org.eclipse.emf.mwe.internal.ui.debug.model.DebugVariable;
import org.eclipse.emf.mwe.internal.ui.debug.model.ui.VariableSorter;

public class DebugStackFrame
extends DebugElement
implements IStackFrame {
    private final DebugThread thread;
    private final SyntaxElement frameValues;
    private final List<DebugVariable> variables = new ArrayList<DebugVariable>();
    private boolean variablesChecked;

    public DebugStackFrame(DebugThread thread, SyntaxElement to) {
        super(thread.getDebugTarget0());
        this.thread = thread;
        this.frameValues = to;
    }

    public IThread getThread() {
        return this.thread;
    }

    public synchronized IVariable[] getVariables() throws DebugException {
        if (!this.variablesChecked) {
            List<VarValueTO> vars = this.getDebugModelManager().requireVariables(this.thread.getSetVarFrameId(this));
            this.variables.clear();
            for (VarValueTO varTO : vars) {
                DebugVariable var = new DebugVariable(this.getDebugTarget0(), varTO);
                this.variables.add(var);
            }
            VariableSorter.sort(this.variables);
            this.variablesChecked = true;
        }
        return this.variables.toArray(new IVariable[0]);
    }

    public boolean hasVariables() throws DebugException {
        return this.getVariables().length > 0;
    }

    public void setVariablesDirty() {
        this.variablesChecked = false;
    }

    public String getName() {
        return this.frameValues.containerName + " :: " + this.frameValues.elementName + " (line: " + this.frameValues.line + ")";
    }

    public int getLineNumber() {
        return this.frameValues.line;
    }

    public int getCharStart() {
        return this.frameValues.start;
    }

    public int getCharEnd() {
        return this.frameValues.end;
    }

    public String getResource() {
        return this.frameValues.resource;
    }

    public String getType() {
        return this.frameValues.type;
    }

    public int getFrameId() {
        return this.frameValues.frameId;
    }

    public boolean isVisible() {
        return this.frameValues.visible;
    }

    public IRegisterGroup[] getRegisterGroups() {
        return null;
    }

    public boolean hasRegisterGroups() {
        return false;
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }
}

