/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.util.ui.internal.exported.util.tree.menu;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.modisco.facet.util.core.Logger;
import org.eclipse.modisco.facet.util.ui.internal.Activator;
import org.eclipse.modisco.facet.util.ui.internal.exported.util.tree.item.AbstractTreeItem;
import org.eclipse.modisco.facet.util.ui.internal.exported.util.tree.menu.AbstractTreeMenu;
import org.eclipse.modisco.facet.util.ui.internal.exported.util.tree.menu.ExtendedTreeMenu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractTreeMenuItem<T>
extends AbstractTreeMenu<T> {
    private final List<AbstractTreeItem<T>> items = new LinkedList<AbstractTreeItem<T>>();

    @Override
    public T onMenuItemSelection() {
        AbstractTreeItem<T> item = null;
        item = this.getCurrentItemSelected() == null ? this.createItem(this.getTree()) : this.createItem(this.getCurrentItemSelected());
        this.getItems().add(item);
        item.setExtraProperties(this.getProperties());
        this.fireChanged();
        return item.onItemCreation();
    }

    public AbstractTreeItem<T> createItem(Tree parent) {
        return this.createTreeItem(parent);
    }

    public AbstractTreeItem<T> createItem(TreeItem parent) {
        return this.createTreeItem(parent);
    }

    protected AbstractTreeItem<T> createTreeItem(Object parent) {
        AbstractTreeItem<T> newTreeItem = null;
        try {
            newTreeItem = this.getAssociatedTreeItemClass().newInstance();
            if (parent instanceof Tree) {
                newTreeItem.createItem(this, (Tree)parent);
            } else if (parent instanceof TreeItem) {
                newTreeItem.createItem(this, (TreeItem)parent);
            }
        }
        catch (SecurityException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        catch (IllegalArgumentException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        catch (InstantiationException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        catch (IllegalAccessException e) {
            Logger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        return newTreeItem;
    }

    public AbstractTreeItem<T> findTreeItemExtended(TreeItem treeItem) {
        return this.getTreeMenu().getTreeItemExtended(treeItem);
    }

    @Override
    public AbstractTreeItem<T> getTreeItemExtended(TreeItem item) {
        AbstractTreeItem<T> result = null;
        for (AbstractTreeItem<T> itemExtended : this.getItems()) {
            if (!itemExtended.getTreeItem().equals(item)) continue;
            result = itemExtended;
            break;
        }
        return result;
    }

    @Override
    public boolean removeItem(TreeItem item) {
        boolean removed = false;
        AbstractTreeItem<T> itemExtended = this.findTreeItemExtended(item);
        if (itemExtended != null) {
            this.getItems().remove(itemExtended);
            itemExtended.removeItem();
            removed = true;
            this.fireChanged();
        }
        return removed;
    }

    public TreeItem getCurrentItemSelected() {
        return this.getTreeMenu().getCurrentItemSelected();
    }

    protected void removeLastItem() {
        ((AbstractTreeItem)((LinkedList)this.getItems()).getLast()).removeItem();
        this.fireChanged();
    }

    protected void setLastItemText(String newText) {
        ((AbstractTreeItem)((LinkedList)this.getItems()).getLast()).setTreeItemText(newText);
        this.fireChanged();
    }

    public void fireChanged() {
        ExtendedTreeMenu treeMenu = this.getTreeMenu();
        if (treeMenu != null) {
            treeMenu.fireChanged();
        }
    }

    public abstract Class<? extends AbstractTreeItem<T>> getAssociatedTreeItemClass();

    public List<AbstractTreeItem<T>> getItems() {
        return this.items;
    }
}

