/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.core.internal.annotations;

import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import org.eclipse.modisco.infra.discovery.core.Messages;
import org.eclipse.modisco.infra.discovery.core.annotations.Parameter;
import org.eclipse.modisco.infra.discovery.core.annotations.ParameterInitialValue;
import org.eclipse.modisco.infra.discovery.core.internal.annotations.ParameterDeclarationException;

public final class DiscoveryAnnotationControls {
    private static final String VOID = "void";

    private DiscoveryAnnotationControls() {
    }

    public static void checkAnnotation(Parameter parameterAnnotation, MemberDeclaration memberDeclaration, Member member) throws ParameterDeclarationException {
        if (memberDeclaration instanceof MethodDeclaration || member instanceof Method) {
            DiscoveryAnnotationControls.checkAnnotation(parameterAnnotation, (MethodDeclaration)memberDeclaration, (Method)member);
        } else {
            DiscoveryAnnotationControls.checkAnnotation(parameterAnnotation, (FieldDeclaration)memberDeclaration, (Field)member);
        }
    }

    public static void checkAnnotation(Parameter parameterAnnotation, MethodDeclaration methodDeclaration, Method method) throws ParameterDeclarationException {
        DiscoveryAnnotationControls.checkIsPublic(parameterAnnotation, (MemberDeclaration)methodDeclaration, (Member)method);
        DiscoveryAnnotationControls.checkIsNotStatic(parameterAnnotation, (MemberDeclaration)methodDeclaration, method);
        DiscoveryAnnotationControls.checkIsAnAccessor(parameterAnnotation, methodDeclaration, method);
        DiscoveryAnnotationControls.checkIsNotRequiredOnGetter(parameterAnnotation, methodDeclaration, method);
    }

    public static void checkAnnotation(Parameter parameterAnnotation, FieldDeclaration fieldDeclaration, Field field) throws ParameterDeclarationException {
        DiscoveryAnnotationControls.checkIsPublic(parameterAnnotation, (MemberDeclaration)fieldDeclaration, (Member)field);
        DiscoveryAnnotationControls.checkIsNotStatic(parameterAnnotation, (MemberDeclaration)fieldDeclaration, field);
    }

    public static void checkAnnotation(ParameterInitialValue annotation, MethodDeclaration methodDeclaration, Method method) throws ParameterDeclarationException {
        DiscoveryAnnotationControls.checkIsPublic(annotation, (MemberDeclaration)methodDeclaration, (Member)method);
        if (methodDeclaration != null) {
            if (methodDeclaration.getParameters().size() != 1) {
                throw new ParameterDeclarationException(Messages.DiscoveryAnnotationControls_initializerMethodMustHaveOneParameter);
            }
            if (methodDeclaration.getReturnType().toString().equalsIgnoreCase(VOID)) {
                throw new ParameterDeclarationException(Messages.DiscoveryAnnotationControls_initializerMethodMustHaveNonVoidReturnType);
            }
        }
        if (method != null) {
            if (method.getParameterTypes().length != 1) {
                throw new ParameterDeclarationException(Messages.DiscoveryAnnotationControls_initializerMethodMustHaveOneParameter);
            }
            if (method.getReturnType() == null || method.getReturnType().getName().equals(VOID)) {
                throw new ParameterDeclarationException(Messages.DiscoveryAnnotationControls_initializerMethodMustHaveNonVoidReturnType);
            }
        }
    }

    public static void checkAnnotationsForOneParameter(Map<MemberDeclaration, Parameter> memberDeclarationToAnnotationsMap, Map<Member, Parameter> memberToAnnotationsMap, Map<MethodDeclaration, ParameterInitialValue> initializerMethodDeclarationToAnnotationsMap, Map<Method, ParameterInitialValue> initializerMethodToAnnotationsMap) throws ParameterDeclarationException {
        DiscoveryAnnotationControls.checkTypeCoherence(memberDeclarationToAnnotationsMap, memberToAnnotationsMap, initializerMethodDeclarationToAnnotationsMap, initializerMethodToAnnotationsMap);
        DiscoveryAnnotationControls.checkAnnotationsNumber(memberDeclarationToAnnotationsMap, memberToAnnotationsMap);
    }

    private static void checkIsAnAccessor(Parameter parameterAnnotation, MethodDeclaration methodDeclaration, Method method) throws ParameterDeclarationException {
        boolean error = method != null && !DiscoveryAnnotationControls.isGetter(method) && !DiscoveryAnnotationControls.isSetter(method);
        boolean bl = error = error || methodDeclaration != null && !DiscoveryAnnotationControls.isGetter(methodDeclaration) && !DiscoveryAnnotationControls.isSetter(methodDeclaration);
        if (error) {
            throw new ParameterDeclarationException(Messages.DiscoveryAnnotationControls_0);
        }
    }

    private static void checkIsNotRequiredOnGetter(Parameter parameterAnnotation, MethodDeclaration methodDeclaration, Method method) throws ParameterDeclarationException {
        boolean error = method != null && DiscoveryAnnotationControls.isGetter(method) && parameterAnnotation.requiresInputValue();
        boolean bl = error = error || methodDeclaration != null && DiscoveryAnnotationControls.isGetter(methodDeclaration) && parameterAnnotation.requiresInputValue();
        if (error) {
            throw new ParameterDeclarationException(Messages.DiscoveryAnnotationControls_1);
        }
    }

    private static void checkIsPublic(Parameter parameterAnnotation, MemberDeclaration memberDeclaration, Member member) throws ParameterDeclarationException {
        boolean error = member != null && !Modifier.isPublic(member.getModifiers());
        boolean bl = error = error || memberDeclaration != null && !memberDeclaration.getModifiers().contains(com.sun.mirror.declaration.Modifier.PUBLIC);
        if (error) {
            throw new ParameterDeclarationException(Messages.DiscoveryAnnotationControls_2);
        }
    }

    private static void checkIsPublic(ParameterInitialValue annotation, MemberDeclaration memberDeclaration, Member member) throws ParameterDeclarationException {
        boolean error = member != null && !Modifier.isPublic(member.getModifiers());
        boolean bl = error = error || memberDeclaration != null && !memberDeclaration.getModifiers().contains(com.sun.mirror.declaration.Modifier.PUBLIC);
        if (error) {
            throw new ParameterDeclarationException(Messages.DiscoveryAnnotationControls_methodMustBePublic);
        }
    }

    private static void checkIsNotStatic(Parameter parameterAnnotation, MemberDeclaration memberDeclaration, Member member) throws ParameterDeclarationException {
        boolean error = member != null && Modifier.isStatic(member.getModifiers());
        boolean bl = error = error || memberDeclaration != null && memberDeclaration.getModifiers().contains(com.sun.mirror.declaration.Modifier.STATIC);
        if (error) {
            throw new ParameterDeclarationException(Messages.DiscoveryAnnotationControls_3);
        }
    }

    private static void checkTypeCoherence(Map<MemberDeclaration, Parameter> memberDeclarationToAnnotationsMap, Map<Member, Parameter> memberToAnnotationsMap, Map<MethodDeclaration, ParameterInitialValue> initializerMethodDeclarationToAnnotationsMap, Map<Method, ParameterInitialValue> initializerMethodToAnnotationsMap) throws ParameterDeclarationException {
        Object initializerMethod;
        Class<?> fieldType = null;
        Class<?> getterType = null;
        Class<?> setterType = null;
        Object initializerType = null;
        if (memberDeclarationToAnnotationsMap != null) {
            for (MemberDeclaration memberDeclaration : memberDeclarationToAnnotationsMap.keySet()) {
                if (memberDeclaration instanceof FieldDeclaration) {
                    fieldType = ((FieldDeclaration)memberDeclaration).getType();
                    continue;
                }
                if (!(memberDeclaration instanceof MethodDeclaration)) continue;
                if (DiscoveryAnnotationControls.isGetter((MethodDeclaration)memberDeclaration)) {
                    getterType = ((MethodDeclaration)memberDeclaration).getReturnType();
                    continue;
                }
                if (!DiscoveryAnnotationControls.isSetter((MethodDeclaration)memberDeclaration)) continue;
                setterType = ((ParameterDeclaration)((MethodDeclaration)memberDeclaration).getParameters().iterator().next()).getType();
            }
        }
        if (memberToAnnotationsMap != null) {
            for (Member member : memberToAnnotationsMap.keySet()) {
                if (member instanceof Field) {
                    fieldType = ((Field)member).getType();
                    continue;
                }
                if (!(member instanceof Method)) continue;
                if (DiscoveryAnnotationControls.isGetter((Method)member)) {
                    getterType = ((Method)member).getReturnType();
                    continue;
                }
                if (!DiscoveryAnnotationControls.isSetter((Method)member)) continue;
                setterType = ((Method)member).getParameterTypes()[0];
            }
        }
        if (initializerMethodDeclarationToAnnotationsMap != null) {
            Set<MethodDeclaration> set = initializerMethodDeclarationToAnnotationsMap.keySet();
            if (set.size() > 1) {
                throw new ParameterDeclarationException(Messages.DiscoveryAnnotationControls_noMoreThanOneInitializer);
            }
            if (set.size() == 1) {
                initializerMethod = set.iterator().next();
                initializerType = initializerMethod.getReturnType();
            }
        }
        if (initializerMethodToAnnotationsMap != null) {
            Set<Method> set = initializerMethodToAnnotationsMap.keySet();
            if (set.size() > 1) {
                throw new ParameterDeclarationException(Messages.DiscoveryAnnotationControls_noMoreThanOneInitializer);
            }
            if (set.size() == 1) {
                initializerMethod = set.iterator().next();
                initializerType = ((Method)initializerMethod).getReturnType();
            }
        }
        if (fieldType != null && getterType != null && !fieldType.equals(getterType)) {
            throw new ParameterDeclarationException(Messages.DiscoveryAnnotationControls_4);
        }
        if (fieldType != null && setterType != null && !fieldType.equals(setterType)) {
            throw new ParameterDeclarationException(Messages.DiscoveryAnnotationControls_5);
        }
        if (setterType != null && getterType != null && !setterType.equals(getterType)) {
            throw new ParameterDeclarationException(Messages.DiscoveryAnnotationControls_6);
        }
        if (fieldType != null && initializerType != null && !fieldType.equals(initializerType)) {
            throw new ParameterDeclarationException(Messages.DiscoveryAnnotationControls_initializerTypeMatchesFieldType);
        }
        if (getterType != null && initializerType != null && !getterType.equals(initializerType)) {
            throw new ParameterDeclarationException(Messages.DiscoveryAnnotationControls_initializerTypeMatchesGetterType);
        }
        if (setterType != null && initializerType != null && !setterType.equals(initializerType)) {
            throw new ParameterDeclarationException(Messages.DiscoveryAnnotationControls_initializerTypeMatchesSetterType);
        }
    }

    private static void checkAnnotationsNumber(Map<MemberDeclaration, Parameter> memberDeclarationToAnnotationsMap, Map<Member, Parameter> memberToAnnotationsMap) throws ParameterDeclarationException {
        int nbField = 0;
        int nbGetter = 0;
        int nbSetter = 0;
        if (memberDeclarationToAnnotationsMap != null) {
            for (MemberDeclaration memberDeclaration : memberDeclarationToAnnotationsMap.keySet()) {
                if (memberDeclaration instanceof FieldDeclaration) {
                    ++nbField;
                    continue;
                }
                if (!(memberDeclaration instanceof MethodDeclaration)) continue;
                if (DiscoveryAnnotationControls.isGetter((MethodDeclaration)memberDeclaration)) {
                    ++nbGetter;
                    continue;
                }
                if (!DiscoveryAnnotationControls.isSetter((MethodDeclaration)memberDeclaration)) continue;
                ++nbSetter;
            }
        }
        if (memberToAnnotationsMap != null) {
            for (Member member : memberToAnnotationsMap.keySet()) {
                if (member instanceof Field) {
                    ++nbField;
                    continue;
                }
                if (!(member instanceof Method)) continue;
                if (DiscoveryAnnotationControls.isGetter((Method)member)) {
                    ++nbGetter;
                    continue;
                }
                if (!DiscoveryAnnotationControls.isSetter((Method)member)) continue;
                ++nbSetter;
            }
        }
        if (nbField > 1) {
            throw new ParameterDeclarationException(Messages.DiscoveryAnnotationControls_7);
        }
        if (nbGetter > 1) {
            throw new ParameterDeclarationException(Messages.DiscoveryAnnotationControls_8);
        }
        if (nbSetter > 1) {
            throw new ParameterDeclarationException(Messages.DiscoveryAnnotationControls_9);
        }
    }

    private static boolean isGetter(Method method) {
        boolean result = true;
        result = result && method.getParameterTypes().length == 0;
        result = result && method.getReturnType() != null;
        result = result && !method.getReturnType().getName().equals(VOID);
        result = result && !Modifier.isStatic(method.getModifiers());
        return result;
    }

    private static boolean isSetter(Method method) {
        boolean result = true;
        result = result && method.getParameterTypes().length == 1;
        result = result && !Modifier.isStatic(method.getModifiers());
        return result;
    }

    private static boolean isGetter(MethodDeclaration method) {
        boolean result = true;
        result = result && method.getParameters().size() == 0;
        result = result && method.getReturnType() != null;
        result = result && !method.getReturnType().toString().equalsIgnoreCase(VOID);
        result = result && !method.getModifiers().contains(com.sun.mirror.declaration.Modifier.STATIC);
        return result;
    }

    private static boolean isSetter(MethodDeclaration method) {
        boolean result = true;
        result = result && method.getParameters().size() == 1;
        result = result && !method.getModifiers().contains(com.sun.mirror.declaration.Modifier.STATIC);
        return result;
    }
}

