/*****************************************************************************
 * Copyright (c) 2010 CEA LIST.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 *
 *****************************************************************************/
package org.eclipse.papyrus.uml.diagram.menu.actions.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.requests.RecalculatePageBreaksRequest;
import org.eclipse.papyrus.infra.gmfdiag.common.preferences.PreferencesConstantsHelper;

/**
 *
 * Handler for the Recalculate Page Breaks Action
 *
 *
 */
@SuppressWarnings("restriction")
public class RecalculatePageBreaksHandler extends AbstractViewHandler {


	/**
	 *
	 * Constructor.
	 *
	 */
	public RecalculatePageBreaksHandler() {
		super(PreferencesConstantsHelper.VIEW_PAGE_BREAK_CONSTANT);
	}

	/**
	 *
	 * Execute the request via the preformRequest() call. This action does
	 * not modify the model and does not use the request/command infrastructure.
	 *
	 * @see org.eclipse.papyrus.uml.diagram.menu.actions.handlers.AbstractViewHandler#execute(org.eclipse.core.commands.ExecutionEvent)
	 *
	 * @param event
	 * @return
	 * @throws ExecutionException
	 */
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		RecalculatePageBreaksRequest request = new RecalculatePageBreaksRequest();
		// not done in a CommandStack! (like the original!)
		((DiagramRootEditPart) getDiagramEditPart().getRoot()).performRequest(request);
		return null;
	}

}
