/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.SortIconFactory;
import ca.odell.glazedlists.impl.gui.SortingStrategy;
import ca.odell.glazedlists.swing.AdvancedTableModel;
import ca.odell.glazedlists.swing.SortableRenderer;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableComparatorChooser<E>
extends AbstractTableComparatorChooser<E> {
    private SortArrowHeaderRenderer sortArrowHeaderRenderer;
    private final TableHeaderUIHandler tableHeaderUIHandler = new TableHeaderUIHandler();
    private final TableModelHandler tableModelHandler = new TableModelHandler();
    private JTable table;
    private ActionListener sortListener;
    private static Icon[] icons = SortIconFactory.loadIcons();
    private final HeaderClickHandler headerClickHandler;

    public TableComparatorChooser(JTable table, SortedList<E> sortedList, boolean multipleColumnSort) {
        this(table, sortedList, multipleColumnSort ? MULTIPLE_COLUMN_MOUSE : SINGLE_COLUMN);
    }

    public TableComparatorChooser(JTable table, SortedList<E> sortedList, Object strategy) {
        this(table, sortedList, strategy, ((AdvancedTableModel)table.getModel()).getTableFormat());
    }

    protected TableComparatorChooser(JTable table, SortedList<E> sortedList, Object strategy, TableFormat<? super E> tableFormat) {
        super(sortedList, tableFormat);
        TableComparatorChooser.validateSortingStrategy(strategy);
        this.table = table;
        this.table.addPropertyChangeListener("model", this.tableModelHandler);
        this.table.getTableHeader().addPropertyChangeListener("UI", this.tableHeaderUIHandler);
        this.wrapDefaultTableHeaderRenderer();
        table.getModel().addTableModelListener(this.tableModelHandler);
        this.headerClickHandler = new HeaderClickHandler(table, (SortingStrategy)strategy);
    }

    private void wrapDefaultTableHeaderRenderer() {
        Class<?> defaultRendererType;
        TableCellRenderer defaultRenderer = this.table.getTableHeader().getDefaultRenderer();
        Class<?> clazz = defaultRendererType = defaultRenderer == null ? null : defaultRenderer.getClass();
        if (defaultRendererType != SortArrowHeaderRenderer.class && defaultRendererType != null) {
            this.sortArrowHeaderRenderer = new SortArrowHeaderRenderer(defaultRenderer);
            this.table.getTableHeader().setDefaultRenderer(this.sortArrowHeaderRenderer);
        }
    }

    public static <E> TableComparatorChooser<E> install(JTable table, SortedList<E> sortedList, Object strategy) {
        return TableComparatorChooser.install(table, sortedList, strategy, ((AdvancedTableModel)table.getModel()).getTableFormat());
    }

    public static <E> TableComparatorChooser<E> install(JTable table, SortedList<E> sortedList, Object strategy, TableFormat<? super E> tableFormat) {
        return new TableComparatorChooser<E>(table, sortedList, strategy, tableFormat);
    }

    private static void validateSortingStrategy(Object strategy) {
        if (!(strategy instanceof SortingStrategy)) {
            throw new IllegalArgumentException("Unrecognized sorting strategy, \"" + strategy + "\", use one of AbstractTableComparatorChooser.SINGLE_COLUMN, AbstractTableComparatorChooser.MULTIPLE_COLUMN_MOUSE, or AbstractTableComparatorChooser.MULTIPLE_COLUMN_KEYBOARD");
        }
    }

    public void addSortActionListener(ActionListener sortActionListener) {
        this.sortListener = AWTEventMulticaster.add(this.sortListener, sortActionListener);
    }

    public void removeSortActionListener(ActionListener sortActionListener) {
        this.sortListener = AWTEventMulticaster.remove(this.sortListener, sortActionListener);
    }

    public TableCellRenderer createSortArrowHeaderRenderer(TableCellRenderer delegateRenderer) {
        return new SortArrowHeaderRenderer(delegateRenderer);
    }

    @Override
    protected void redetectComparator(Comparator<? super E> currentComparator) {
        super.redetectComparator(currentComparator);
        this.table.getTableHeader().revalidate();
        this.table.getTableHeader().repaint();
    }

    @Override
    protected final void rebuildComparator() {
        super.rebuildComparator();
        this.table.getTableHeader().revalidate();
        this.table.getTableHeader().repaint();
        if (this.sortListener != null) {
            this.sortListener.actionPerformed(new ActionEvent(this, 0, "sort"));
        }
    }

    @Override
    protected final int getSortingStyle(int column) {
        return super.getSortingStyle(this.table.convertColumnIndexToModel(column));
    }

    protected boolean isSortingMouseEvent(MouseEvent e) {
        return e.getButton() == 1;
    }

    public static void setIconPath(String path) {
        icons = SortIconFactory.loadIcons(path);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.headerClickHandler.dispose();
        if (this.table.getTableHeader().getDefaultRenderer() == this.sortArrowHeaderRenderer) {
            this.table.getTableHeader().setDefaultRenderer(this.sortArrowHeaderRenderer.getDelegateRenderer());
        }
        this.table.getModel().removeTableModelListener(this.tableModelHandler);
        this.table.removePropertyChangeListener("model", this.tableModelHandler);
        this.table.getTableHeader().removePropertyChangeListener("UI", this.tableHeaderUIHandler);
        this.table = null;
    }

    private class HeaderClickHandler
    extends MouseAdapter {
        private final JTable table;
        private final SortingStrategy delegate;
        private boolean mouseEventIsPerformingPopupTrigger = false;

        public HeaderClickHandler(JTable table, SortingStrategy delegate) {
            this.table = table;
            this.delegate = delegate;
            table.getTableHeader().addMouseListener(this);
        }

        public void mouseClicked(MouseEvent e) {
            if (this.mouseEventIsPerformingPopupTrigger) {
                return;
            }
            if (this.table.getTableHeader().getCursor() == Cursor.getPredefinedCursor(11)) {
                return;
            }
            if (!TableComparatorChooser.this.isSortingMouseEvent(e)) {
                return;
            }
            TableColumnModel columnModel = this.table.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = this.table.convertColumnIndexToModel(viewColumn);
            int clicks = e.getClickCount();
            if (clicks >= 1 && column != -1) {
                boolean shift = e.isShiftDown();
                boolean control = e.isControlDown() || e.isMetaDown();
                this.delegate.columnClicked(TableComparatorChooser.this.sortingState, column, clicks, shift, control);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mouseEventIsPerformingPopupTrigger = mouseEvent.isPopupTrigger();
        }

        public void dispose() {
            this.table.getTableHeader().removeMouseListener(this);
        }
    }

    class SortArrowHeaderRenderer
    implements TableCellRenderer,
    UIResource {
        private TableCellRenderer delegateRenderer;

        public SortArrowHeaderRenderer(TableCellRenderer delegateRenderer) {
            this.delegateRenderer = delegateRenderer;
        }

        public TableCellRenderer getDelegateRenderer() {
            return this.delegateRenderer;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component rendered;
            if (column < 0) {
                return this.getDelegateTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            Icon sortIcon = icons[TableComparatorChooser.this.getSortingStyle(column)];
            if (this.delegateRenderer instanceof SortableRenderer) {
                ((SortableRenderer)((Object)this.delegateRenderer)).setSortIcon(sortIcon);
                rendered = this.getDelegateTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            } else {
                rendered = this.getDelegateTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (rendered instanceof JLabel) {
                    JLabel label = (JLabel)rendered;
                    label.setIcon(sortIcon);
                    label.setHorizontalTextPosition(10);
                }
            }
            return rendered;
        }

        private Component getDelegateTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            try {
                return this.delegateRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            catch (RuntimeException e) {
                this.delegateRenderer = new DefaultTableCellRenderer();
                return this.delegateRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        }
    }

    private class TableHeaderUIHandler
    implements PropertyChangeListener {
        private TableHeaderUIHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            TableComparatorChooser.this.wrapDefaultTableHeaderRenderer();
        }
    }

    private class TableModelHandler
    implements TableModelListener,
    PropertyChangeListener {
        private TableModelHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            AdvancedTableModel newModel;
            AdvancedTableModel oldModel = evt.getOldValue() instanceof AdvancedTableModel ? (AdvancedTableModel)evt.getOldValue() : null;
            AdvancedTableModel advancedTableModel = newModel = evt.getNewValue() instanceof AdvancedTableModel ? (AdvancedTableModel)evt.getNewValue() : null;
            if (oldModel != null) {
                oldModel.removeTableModelListener(this);
            }
            if (newModel != null) {
                newModel.addTableModelListener(this);
                TableComparatorChooser.this.setTableFormat(newModel.getTableFormat());
            }
        }

        public void tableChanged(TableModelEvent event) {
            Comparator currentComparator;
            if (event.getFirstRow() == -1 && event.getColumn() == -1 && TableComparatorChooser.this.table.getModel() instanceof AdvancedTableModel) {
                TableComparatorChooser.this.setTableFormat(((AdvancedTableModel)TableComparatorChooser.this.table.getModel()).getTableFormat());
            }
            if ((currentComparator = TableComparatorChooser.this.sortedList.getComparator()) != TableComparatorChooser.this.sortedListComparator) {
                TableComparatorChooser.this.redetectComparator(currentComparator);
            }
        }
    }
}

