/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.GeneralizationSet;

public class GeneralizationSetReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public GeneralizationSetReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof GeneralizationSet)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        return this.newEnd instanceof Generalization;
    }

    protected boolean canReorientTarget() {
        return this.newEnd instanceof Generalization;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().getGeneralizationSets().remove((Object)this.getLink());
        this.getNewSource().getGeneralizationSets().add((Object)this.getLink());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getOldTarget().getGeneralizationSets().remove((Object)this.getLink());
        this.getNewTarget().getGeneralizationSets().add((Object)this.getLink());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected GeneralizationSet getLink() {
        return (GeneralizationSet)this.getElementToEdit();
    }

    protected Generalization getOldSource() {
        return (Generalization)this.oldEnd;
    }

    protected Generalization getNewSource() {
        return (Generalization)this.newEnd;
    }

    protected Generalization getOldTarget() {
        return (Generalization)this.oldEnd;
    }

    protected Generalization getNewTarget() {
        return (Generalization)this.newEnd;
    }
}

