/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.policies;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.handles.MoveHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.NonResizableLabelEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.PapyrusLabelEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;

public class ExternalLabelPrimaryDragRoleEditPolicy
extends NonResizableLabelEditPolicy {
    protected List<?> createSelectionHandles() {
        MoveHandle mh = new MoveHandle(this.getHost());
        mh.setBorder(null);
        return Collections.singletonList(mh);
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        LabelEditPart editPart = (LabelEditPart)this.getHost();
        PrecisionRectangle initialRect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        Rectangle updatedRect = initialRect.getTranslated(this.getHostFigure().getParent().getBounds().getLocation().getNegated());
        double zoomLevel = DiagramEditPartsUtil.getDiagramZoomLevel((EditPart)editPart);
        updatedRect = updatedRect.getTranslated(request.getMoveDelta().scale(1.0 / zoomLevel));
        if (editPart instanceof PapyrusLabelEditPart) {
            switch (((PapyrusLabelEditPart)editPart).getTextAlignment()) {
                case 2: {
                    updatedRect.translate(this.getHostFigure().getBounds().width / 2, 0);
                    break;
                }
                case 4: {
                    updatedRect.translate(this.getHostFigure().getBounds().width, 0);
                    break;
                }
            }
        }
        SetBoundsCommand moveCommand = new SetBoundsCommand(editPart.getEditingDomain(), DiagramUIMessages.MoveLabelCommand_Label_Location, (IAdaptable)new EObjectAdapter((EObject)((View)editPart.getModel())), updatedRect);
        return new ICommandProxy((ICommand)moveCommand);
    }
}

