/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.outline.emftree.internal;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;

public class OutlineDragAdapter
implements DragSourceListener {
    private final ISelectionProvider selectionProvider;

    public OutlineDragAdapter(ISelectionProvider provider) {
        this.selectionProvider = provider;
    }

    public Transfer[] getSupportedDragTransfers() {
        LinkedHashSet<LocalSelectionTransfer> supportedTypes = new LinkedHashSet<LocalSelectionTransfer>();
        supportedTypes.add(LocalSelectionTransfer.getTransfer());
        Transfer[] transfers = supportedTypes.toArray(new Transfer[supportedTypes.size()]);
        return transfers;
    }

    public void dragFinished(DragSourceEvent event) {
        LocalSelectionTransfer.getTransfer().setSelection(null);
    }

    public void dragSetData(DragSourceEvent event) {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
            event.data = selection;
        } else {
            event.doit = false;
        }
    }

    public void dragStart(DragSourceEvent event) {
        try {
            IStructuredSelection selection = this.getSelection();
            if (!selection.isEmpty()) {
                LocalSelectionTransfer.getTransfer().setSelection((ISelection)selection);
                event.doit = true;
                event.data = this.getSelection();
            } else {
                event.doit = false;
            }
        }
        catch (RuntimeException e) {
            System.err.println(e);
        }
    }

    protected IStructuredSelection getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
        ArrayList<Object> transferData = new ArrayList<Object>();
        for (Object sel : selection) {
            if (!(sel instanceof IWrapperItemProvider) && !(sel instanceof FeatureMap.Entry) && !(sel instanceof EObject)) continue;
            transferData.add(AdapterFactoryEditingDomain.unwrap(sel));
        }
        return new StructuredSelection(transferData);
    }
}

