/*
 * Decompiled with CFR 0.152.
 */
package xpt.propsheet;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Objects;
import org.eclipse.papyrus.gmf.codegen.gmfgen.GenCustomPropertyTab;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import xpt.CodeStyle;
import xpt.Common;

@Singleton
public class PropertySection {
    @Inject
    @Extension
    private Common _common;
    @Inject
    private CodeStyle xptCodeStyle;

    public CharSequence className(GenCustomPropertyTab it) {
        StringConcatenation _builder = new StringConcatenation();
        String _className = it.getClassName();
        _builder.append(_className);
        return _builder;
    }

    public CharSequence packageName(GenCustomPropertyTab it) {
        StringConcatenation _builder = new StringConcatenation();
        String _packageName = it.getSheet().getPackageName();
        _builder.append(_packageName);
        return _builder;
    }

    public CharSequence qualifiedClassName(GenCustomPropertyTab it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(".");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        return _builder;
    }

    public CharSequence fullPath(GenCustomPropertyTab it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _qualifiedClassName = this.qualifiedClassName(it);
        _builder.append((Object)_qualifiedClassName);
        return _builder;
    }

    public CharSequence PropertySection(GenCustomPropertyTab it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _copyright = this._common.copyright(it.getSheet().getEditorGen());
        _builder.append((Object)_copyright);
        _builder.newLineIfNotEmpty();
        _builder.append("package ");
        CharSequence _packageName = this.packageName(it);
        _builder.append((Object)_packageName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generatedClassComment = this._common.generatedClassComment();
        _builder.append((Object)_generatedClassComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public class ");
        CharSequence _className = this.className(it);
        _builder.append((Object)_className);
        _builder.append(" ");
        CharSequence _extendsList = this.extendsList(it);
        _builder.append((Object)_extendsList);
        _builder.append(" ");
        CharSequence _implementsClause = this.implementsClause(it);
        _builder.append((Object)_implementsClause);
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        boolean _isReadOnly = it.getSheet().isReadOnly();
        if (_isReadOnly) {
            _builder.append("\t");
            CharSequence _createReadonlyControlsMethod = this.createReadonlyControlsMethod(it);
            _builder.append((Object)_createReadonlyControlsMethod, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        CharSequence _transfromSelectionMethod = this.transfromSelectionMethod(it);
        _builder.append((Object)_transfromSelectionMethod, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence extendsList(GenCustomPropertyTab it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("extends org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.sheet.DefaultPropertySection");
        return _builder;
    }

    public CharSequence implementsClause(GenCustomPropertyTab it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("implements org.eclipse.ui.views.properties.IPropertySourceProvider");
        return _builder;
    }

    public CharSequence createReadonlyControlsMethod(GenCustomPropertyTab it) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedMemberComment = this._common.generatedMemberComment();
        _builder.append((Object)_generatedMemberComment);
        _builder.newLineIfNotEmpty();
        _builder.append("public void createControls(org.eclipse.swt.widgets.Composite parent, org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage aTabbedPropertySheetPage) {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("super.createControls(parent, aTabbedPropertySheetPage);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("forcePageReadOnly();");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence transfromSelectionMethod(GenCustomPropertyTab it) {
        StringConcatenation _builder = new StringConcatenation();
        String _iD = it.getID();
        boolean _equals = Objects.equals("domain", _iD);
        if (_equals) {
            CharSequence _generatedMemberComment = this._common.generatedMemberComment("Modify/unwrap selection.");
            _builder.append((Object)_generatedMemberComment);
            _builder.newLineIfNotEmpty();
            CharSequence _overrideC = this.xptCodeStyle.overrideC(it.getSheet().getEditorGen().getDiagram());
            _builder.append((Object)_overrideC);
            _builder.newLineIfNotEmpty();
            _builder.append("protected Object transformSelection(Object selected) {");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _transfromSelectionMethodBodyDefault = this.transfromSelectionMethodBodyDefault(it);
            _builder.append((Object)_transfromSelectionMethodBodyDefault, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return selected;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence transfromSelectionMethodBodyDefault(GenCustomPropertyTab it) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("selected = /* super. */transformSelectionToDomain(selected);");
        _builder.newLine();
        return _builder;
    }
}

