/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.profile.internal.checkers;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.toolsmiths.validation.common.checkers.IPluginChecker;
import org.eclipse.papyrus.toolsmiths.validation.common.utils.MarkersService;
import org.eclipse.papyrus.uml.tools.profile.definition.PapyrusDefinitionAnnotation;
import org.eclipse.uml2.uml.Profile;

public class ProfileDefinitionChecker
implements IPluginChecker {
    private final IFile profileFile;
    private final Collection<Profile> existingProfiles;

    public ProfileDefinitionChecker(IFile profileFile, Collection<Profile> existingProfiles) {
        this.profileFile = profileFile;
        this.existingProfiles = existingProfiles;
    }

    public void check(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.subTask("Validate profiles definitions for profile '" + this.profileFile.getName() + "'.");
        }
        HashSet<Profile> profiles = new HashSet<Profile>(this.existingProfiles);
        Iterator profilesIt = profiles.iterator();
        while (profilesIt.hasNext()) {
            Profile currentProfile = (Profile)profilesIt.next();
            if (this.hasProfileDefinition(currentProfile)) continue;
            profilesIt.remove();
        }
        if (!profiles.isEmpty()) {
            for (Profile profile : profiles) {
                MarkersService.createMarker((IResource)this.profileFile, (String)"org.eclipse.papyrus.toolsmiths.validation.profile.diagnostic", (String)("The profile '" + profile.getName() + "' contain a definition but should not"), (int)2);
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
    }

    private boolean hasProfileDefinition(Profile profile) {
        boolean result = false;
        EAnnotation umlAnnotation = profile.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML");
        if (umlAnnotation != null && !umlAnnotation.getContents().isEmpty()) {
            for (EObject content : umlAnnotation.getContents()) {
                PapyrusDefinitionAnnotation parsedAnnotation;
                EAnnotation papyrusVersionAnnotation;
                if (!(content instanceof EModelElement) || (papyrusVersionAnnotation = ((EModelElement)content).getEAnnotation("PapyrusVersion")) == null || PapyrusDefinitionAnnotation.UNDEFINED_ANNOTATION.equals(parsedAnnotation = PapyrusDefinitionAnnotation.parseEAnnotation((EAnnotation)papyrusVersionAnnotation))) continue;
                result = true;
            }
        }
        return result;
    }
}

