/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.ListSelection;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.swing.AdvancedListSelectionModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class DefaultEventSelectionModel<E>
implements AdvancedListSelectionModel<E> {
    private ListSelection<E> listSelection;
    private EventList<E> source;
    private boolean disposeSource;
    private boolean enabled = true;
    private final ListSelection.Listener selectionListener = new SwingSelectionListener();
    private final List<ListSelectionListener> listeners = new ArrayList<ListSelectionListener>();
    private boolean valueIsAdjusting = false;
    private int fullChangeStart = -1;
    private int fullChangeFinish = -1;

    public DefaultEventSelectionModel(EventList<E> source) {
        this(source, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultEventSelectionModel(EventList<E> source, boolean disposeSource) {
        source.getReadWriteLock().readLock().lock();
        try {
            this.source = source;
            this.listSelection = new ListSelection<E>(source);
            this.listSelection.addSelectionListener(this.selectionListener);
        }
        finally {
            source.getReadWriteLock().readLock().unlock();
        }
        this.disposeSource = disposeSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventList<E> getSelected() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            EventList<E> eventList = this.listSelection.getSelected();
            return eventList;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventList<E> getTogglingSelected() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            EventList<E> eventList = this.listSelection.getTogglingSelected();
            return eventList;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventList<E> getDeselected() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            EventList<E> eventList = this.listSelection.getDeselected();
            return eventList;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventList<E> getTogglingDeselected() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            EventList<E> eventList = this.listSelection.getTogglingDeselected();
            return eventList;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    private void fireSelectionChanged(int changeStart, int changeFinish) {
        if (this.valueIsAdjusting) {
            if (this.fullChangeStart == -1 || changeStart < this.fullChangeStart) {
                this.fullChangeStart = changeStart;
            }
            if (this.fullChangeFinish == -1 || changeFinish > this.fullChangeFinish) {
                this.fullChangeFinish = changeFinish;
            }
        }
        ListSelectionEvent event = new ListSelectionEvent(this, changeStart, changeFinish, this.valueIsAdjusting);
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            this.listeners.get(i).valueChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invertSelection() {
        this.source.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.invertSelection();
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectionInterval(int index0, int index1) {
        if (!this.enabled) {
            return;
        }
        this.source.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.setSelection(index0, index1);
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSelectionInterval(int index0, int index1) {
        if (!this.enabled) {
            return;
        }
        this.source.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.select(index0, index1);
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSelectionInterval(int index0, int index1) {
        if (!this.enabled) {
            return;
        }
        if (index0 == 0 && index1 == 0 && this.source.isEmpty()) {
            return;
        }
        this.source.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.deselect(index0, index1);
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public boolean isSelectedIndex(int index) {
        return this.listSelection.isSelected(index);
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.listSelection.getAnchorSelectionIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAnchorSelectionIndex(int anchorSelectionIndex) {
        if (!this.enabled) {
            return;
        }
        this.source.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.setAnchorSelectionIndex(anchorSelectionIndex);
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public int getLeadSelectionIndex() {
        return this.listSelection.getLeadSelectionIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLeadSelectionIndex(int leadSelectionIndex) {
        if (!this.enabled) {
            return;
        }
        this.source.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.setLeadSelectionIndex(leadSelectionIndex);
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public int getMinSelectionIndex() {
        return this.listSelection.getMinSelectionIndex();
    }

    @Override
    public int getMaxSelectionIndex() {
        return this.listSelection.getMaxSelectionIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSelection() {
        if (!this.enabled) {
            return;
        }
        this.source.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.deselectAll();
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSelectionEmpty() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            boolean bl = this.listSelection.getSelected().isEmpty();
            return bl;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    @Override
    public void insertIndexInterval(int index, int length, boolean before) {
    }

    @Override
    public void removeIndexInterval(int index0, int index1) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.valueIsAdjusting = valueIsAdjusting;
        if (!valueIsAdjusting && this.fullChangeStart != -1 && this.fullChangeFinish != -1) {
            this.source.getReadWriteLock().writeLock().lock();
            try {
                this.fireSelectionChanged(this.fullChangeStart, this.fullChangeFinish);
                this.fullChangeStart = -1;
                this.fullChangeFinish = -1;
            }
            finally {
                this.source.getReadWriteLock().writeLock().unlock();
            }
        }
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSelectionMode(int selectionMode) {
        this.source.getReadWriteLock().writeLock().lock();
        try {
            this.listSelection.setSelectionMode(selectionMode);
        }
        finally {
            this.source.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public int getSelectionMode() {
        return this.listSelection.getSelectionMode();
    }

    @Override
    public void addValidSelectionMatcher(Matcher<E> validSelectionMatcher) {
        this.listSelection.addValidSelectionMatcher(validSelectionMatcher);
    }

    @Override
    public void removeValidSelectionMatcher(Matcher<E> validSelectionMatcher) {
        this.listSelection.removeValidSelectionMatcher(validSelectionMatcher);
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void dispose() {
        this.listSelection.removeSelectionListener(this.selectionListener);
        this.listSelection.dispose();
        if (this.disposeSource) {
            this.source.dispose();
        }
    }

    private class SwingSelectionListener
    implements ListSelection.Listener {
        private SwingSelectionListener() {
        }

        @Override
        public void selectionChanged(int changeStart, int changeEnd) {
            DefaultEventSelectionModel.this.fireSelectionChanged(changeStart, changeEnd);
        }
    }
}

