/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.constraints.operations;

import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrus.infra.emf.types.advices.constraints.PermissionResult;
import org.eclipse.papyrus.infra.emf.types.constraints.EndPermission;
import org.eclipse.papyrus.infra.emf.types.constraints.RelationshipConstraint;
import org.eclipse.papyrus.infra.emf.types.constraints.operations.AdviceConstraintOperations;

public class RelationshipConstraintOperations
extends AdviceConstraintOperations {
    protected RelationshipConstraintOperations() {
    }

    public static boolean approveRequest(RelationshipConstraint relationshipConstraint, IEditCommandRequest request) {
        Function<EndPermission, PermissionResult> evaluator = request instanceof CreateRelationshipRequest ? permission -> RelationshipConstraintOperations.approveRequest(permission, (CreateRelationshipRequest)request) : (request instanceof ReorientRelationshipRequest ? permission -> RelationshipConstraintOperations.approveRequest(permission, (ReorientRelationshipRequest)request) : null);
        return RelationshipConstraintOperations.approveRequest(request, relationshipConstraint.getPermissions(), evaluator);
    }

    private static PermissionResult approveRequest(EndPermission permission, CreateRelationshipRequest request) {
        EObject source = request.getSource();
        EObject target = request.getTarget();
        if (source == null && target == null) {
            return PermissionResult.NONE;
        }
        PermissionResult result = PermissionResult.NONE;
        switch (permission.getEndKind()) {
            case ALL: {
                if (source != null && !permission.matches(source) || target != null && !permission.matches(target)) break;
                result = RelationshipConstraintOperations.evaluate(permission, (Object)request.getElementType());
                break;
            }
            case SOURCE: {
                if (source != null && !permission.matches(source)) break;
                result = RelationshipConstraintOperations.evaluate(permission, (Object)request.getElementType());
                break;
            }
            case TARGET: {
                if (target != null && !permission.matches(target)) break;
                result = RelationshipConstraintOperations.evaluate(permission, (Object)request.getElementType());
            }
        }
        return result;
    }

    private static PermissionResult approveRequest(EndPermission permission, ReorientRelationshipRequest request) {
        boolean isSource;
        EObject newEnd = request.getNewRelationshipEnd();
        boolean bl = isSource = request.getDirection() == 1;
        if (newEnd == null) {
            return PermissionResult.NONE;
        }
        PermissionResult result = PermissionResult.NONE;
        switch (permission.getEndKind()) {
            case ALL: {
                if (!permission.matches(newEnd)) break;
                result = RelationshipConstraintOperations.evaluate(permission, (Object)newEnd);
                break;
            }
            case SOURCE: {
                if (!isSource || !permission.matches(newEnd)) break;
                result = RelationshipConstraintOperations.evaluate(permission, (Object)newEnd);
                break;
            }
            case TARGET: {
                if (isSource || !permission.matches(newEnd)) break;
                result = RelationshipConstraintOperations.evaluate(permission, (Object)newEnd);
            }
        }
        return result;
    }

    protected static PermissionResult evaluate(EndPermission permission, Object value) {
        return RelationshipConstraintOperations.evaluate(permission.getFilter(), value) ? PermissionResult.of(permission.isPermitted()) : PermissionResult.NONE;
    }
}

