/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.editor.reload;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.ui.editor.reload.IDisposableReloadContext;
import org.eclipse.papyrus.infra.ui.editor.reload.IInternalEMFSelectionContext;

public class CompositeReloadContext
implements IDisposableReloadContext,
IAdaptable {
    private final Collection<Object> reloadContexts;

    public CompositeReloadContext() {
        this(Collections.EMPTY_LIST);
    }

    public CompositeReloadContext(Iterable<?> reloadContexts) {
        this.reloadContexts = Lists.newArrayList(reloadContexts);
    }

    public <T> T add(T reloadContext) {
        this.reloadContexts.add(reloadContext);
        return reloadContext;
    }

    public Iterable<?> getReloadContexts() {
        return Collections.unmodifiableCollection(this.reloadContexts);
    }

    public <T> Iterable<T> getReloadContexts(Class<T> type) {
        return Iterables.filter(this.getReloadContexts(), type);
    }

    @Override
    public void dispose() {
        for (Object next : this.reloadContexts) {
            if (!(next instanceof IDisposableReloadContext)) continue;
            ((IDisposableReloadContext)next).dispose();
        }
        this.reloadContexts.clear();
    }

    public Object getAdapter(Class adapter) {
        return adapter == IInternalEMFSelectionContext.class ? this.getEMFContext() : null;
    }

    private IInternalEMFSelectionContext getEMFContext() {
        IInternalEMFSelectionContext.Composite result = null;
        for (Object next : this.reloadContexts) {
            if (AdapterUtils.adapt((Object)next, IInternalEMFSelectionContext.class, null) == null) continue;
            result = new IInternalEMFSelectionContext.Composite(this);
            break;
        }
        return result;
    }
}

