/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.provider;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.tooltip.NatTableContentTooltip;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableproblem.Problem;
import org.eclipse.papyrus.infra.nattable.provider.ProblemLabelProvider;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderCellContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.services.decoration.DecorationService;
import org.eclipse.papyrus.infra.services.decoration.util.Decoration;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class PapyrusNatTableToolTipProvider
extends NatTableContentTooltip {
    private final ISharedImages sharedImage = PlatformUI.getWorkbench().getSharedImages();
    private final LabelProviderCellContextElementWrapper wrapper = new LabelProviderCellContextElementWrapper();

    public PapyrusNatTableToolTipProvider(NatTable natTable, String ... tooltipRegions) {
        super(natTable, tooltipRegions);
    }

    protected boolean isInHeaderRegion(ILayerCell cell) {
        LabelStack labels = cell.getConfigLabels();
        return labels.hasLabel("ROW_HEADER") || labels.hasLabel("COLUMN_HEADER");
    }

    protected boolean isInBodyRegion(ILayerCell cell) {
        LabelStack labels = cell.getConfigLabels();
        return labels.hasLabel("BODY");
    }

    protected Image getImage(Event event) {
        ILayerCell cell = this.getCell(event);
        if (cell == null) {
            return null;
        }
        if (this.isInBodyRegion(cell) && this.isCellWithError(cell)) {
            return this.sharedImage.getImage("IMG_OBJS_ERROR_TSK");
        }
        if (this.isInHeaderRegion(cell) && this.isCellWithDecorationMarker(cell)) {
            LabelProviderService serv = (LabelProviderService)this.natTable.getConfigRegistry().getConfigAttribute(NattableConfigAttributes.LABEL_PROVIDER_SERVICE_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"label_provider_service_id"});
            this.wrapper.setCell(cell);
            this.wrapper.setConfigRegistry(this.natTable.getConfigRegistry());
            this.wrapper.setObject(cell.getDataValue());
            return serv.getLabelProvider("org.eclipse.papyrus.infra.nattable.full.labelprovider", (Object)this.wrapper).getImage((Object)this.wrapper);
        }
        return super.getImage(event);
    }

    protected String getText(Event event) {
        ILayerCell cell = this.getCell(event);
        if (cell == null) {
            return null;
        }
        if (this.isInBodyRegion(cell) && this.isCellWithError(cell)) {
            return this.getProblemTooltip(cell.getDataValue());
        }
        if (this.isInHeaderRegion(cell) && this.isCellWithDecorationMarker(cell)) {
            Object element;
            DecorationService serv = (DecorationService)this.natTable.getConfigRegistry().getConfigAttribute(NattableConfigAttributes.DECORATION_SERVICE_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"decoration_service_id"});
            Object value = cell.getDataValue();
            if (value != null && (element = AxisUtils.getRepresentedElement(value)) != null) {
                return Decoration.getMessageFromDecorations((DecorationService)serv, (Object)element);
            }
        }
        return super.getText(event);
    }

    protected boolean isCellWithDecorationMarker(ILayerCell cell) {
        Object representedValue;
        if (cell == null) {
            return false;
        }
        DecorationService serv = (DecorationService)this.natTable.getConfigRegistry().getConfigAttribute(NattableConfigAttributes.DECORATION_SERVICE_CONFIG_ATTRIBUTE, DisplayMode.NORMAL, new String[]{"decoration_service_id"});
        Object value = cell.getDataValue();
        if (value != null && (representedValue = AxisUtils.getRepresentedElement(value)) != null) {
            return serv.getDecorations(representedValue, true).size() > 0;
        }
        return false;
    }

    protected String getProblemTooltip(Object value) {
        ProblemLabelProvider provider = new ProblemLabelProvider();
        if (value instanceof Problem) {
            return provider.getTooltipText((EObject)value);
        }
        if (value instanceof Collection) {
            StringBuilder builder = new StringBuilder();
            Iterator iter = ((Collection)value).iterator();
            while (iter.hasNext()) {
                Object current = iter.next();
                if (current instanceof Problem) {
                    builder.append(provider.getTooltipText((EObject)current));
                }
                if (!iter.hasNext()) continue;
                builder.append("\n");
            }
            return builder.toString();
        }
        return null;
    }

    protected ILayerCell getCell(Event event) {
        int col = this.natTable.getColumnPositionByX(event.x);
        int row = this.natTable.getRowPositionByY(event.y);
        return this.natTable.getCellByPosition(col, row);
    }

    protected boolean isCellWithError(ILayerCell cell) {
        boolean hasError = false;
        if (cell != null) {
            Object value = cell.getDataValue();
            if (value instanceof Problem) {
                hasError = true;
            } else if (value instanceof Collection) {
                Iterator iter = ((Collection)value).iterator();
                while (!hasError && iter.hasNext()) {
                    hasError = iter.next() instanceof Problem;
                }
            }
        }
        return hasError;
    }

    protected boolean shouldCreateToolTip(Event event) {
        ILayerCell cell = this.getCell(event);
        if (cell == null) {
            return false;
        }
        if (this.isCellWithError(cell)) {
            return true;
        }
        if (this.isInHeaderRegion(this.getCell(event)) && this.isCellWithDecorationMarker(cell)) {
            return true;
        }
        return !this.isDisplayingFullCellText(event);
    }

    protected boolean isDisplayingFullCellText(Event event) {
        return true;
    }
}

