/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.codegen.gmfgen;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ProviderPriority implements Enumerator
{
    LOWEST_LITERAL(0, "Lowest", "Lowest"),
    LOW_LITERAL(1, "Low", "Low"),
    MEDIUM_LITERAL(2, "Medium", "Medium"),
    HIGH_LITERAL(3, "High", "High"),
    HIGHEST_LITERAL(4, "Highest", "Highest");

    public static final int LOWEST = 0;
    public static final int LOW = 1;
    public static final int MEDIUM = 2;
    public static final int HIGH = 3;
    public static final int HIGHEST = 4;
    private static final ProviderPriority[] VALUES_ARRAY;
    public static final List<ProviderPriority> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ProviderPriority[]{LOWEST_LITERAL, LOW_LITERAL, MEDIUM_LITERAL, HIGH_LITERAL, HIGHEST_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ProviderPriority get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProviderPriority result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProviderPriority getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProviderPriority result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProviderPriority get(int value) {
        switch (value) {
            case 0: {
                return LOWEST_LITERAL;
            }
            case 1: {
                return LOW_LITERAL;
            }
            case 2: {
                return MEDIUM_LITERAL;
            }
            case 3: {
                return HIGH_LITERAL;
            }
            case 4: {
                return HIGHEST_LITERAL;
            }
        }
        return null;
    }

    private ProviderPriority(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

