/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.internal.readonly;

import com.google.common.base.Optional;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.resource.AbstractReadOnlyHandler;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;

public class InternationalizationPropertiesReadOnlyHandler
extends AbstractReadOnlyHandler {
    private ModelSet modelSet;

    public InternationalizationPropertiesReadOnlyHandler(EditingDomain editingDomain) {
        super(editingDomain);
        if (this.getEditingDomain().getResourceSet() instanceof ModelSet) {
            this.modelSet = (ModelSet)this.getEditingDomain().getResourceSet();
        }
    }

    public Optional<Boolean> anyReadOnly(Set<ReadOnlyAxis> axes, URI[] uris) {
        if (this.modelSet == null || !axes.contains(ReadOnlyAxis.DISCRETION)) {
            return Optional.absent();
        }
        int knownWritableCount = 0;
        URI[] uRIArray = uris;
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            if ("internationalization".equals(uri.fileExtension()) || "notation".equals(uri.fileExtension()) || uri.isPlatform() && "properties".equals(uri.fileExtension())) {
                ++knownWritableCount;
            }
            ++n2;
        }
        return knownWritableCount == uris.length ? Optional.of((Object)false) : Optional.absent();
    }

    public Optional<Boolean> makeWritable(Set<ReadOnlyAxis> axes, URI[] uris) {
        return Optional.absent();
    }
}

