/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.commands;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.internal.messages.Messages;
import org.eclipse.uml2.uml.ProfileApplication;

public class SeparateProfileApplicationsCommand
extends RecordingCommand {
    private final ResourceSet resourceSet;
    private final Iterable<? extends ProfileApplication> profileApplications;
    private final URI resourceURI;

    public SeparateProfileApplicationsCommand(TransactionalEditingDomain domain, Iterable<? extends ProfileApplication> profileApplications, URI resourceURI) {
        super(domain, Messages.SeparateProfileApplicationsCommand_0);
        this.resourceSet = domain.getResourceSet();
        this.profileApplications = profileApplications;
        this.resourceURI = resourceURI;
    }

    protected void doExecute() {
        Resource decoratorModel = this.resourceSet.getResource(this.resourceURI, true);
        for (ProfileApplication profileApplication : this.profileApplications) {
            DecoratorModelUtils.externalizeProfileApplication(profileApplication, decoratorModel);
        }
    }
}

