/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.commands;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;

public class InsertDiagramCommand
extends RecordingCommand {
    protected TransactionalEditingDomain transactionalEditingDomain;
    protected Diagram diagram;
    protected EObject graphicalOwner;
    protected EObject semanticOwner;

    public InsertDiagramCommand(TransactionalEditingDomain transactionalEditingDomain, String label, Diagram diagram, EObject semanticOwner) {
        this(transactionalEditingDomain, label, diagram, semanticOwner, semanticOwner);
    }

    public InsertDiagramCommand(TransactionalEditingDomain transactionalEditingDomain, String label, Diagram diagram, EObject semanticOwner, EObject graphicalOwner) {
        super(transactionalEditingDomain, label);
        this.transactionalEditingDomain = transactionalEditingDomain;
        this.diagram = diagram;
        Assert.isNotNull((Object)semanticOwner);
        this.semanticOwner = semanticOwner;
        this.graphicalOwner = graphicalOwner;
        if (graphicalOwner == null) {
            this.graphicalOwner = this.semanticOwner;
        }
    }

    protected void doExecute() {
        Resource targetResource = NotationUtils.getNotationResourceForDiagram(this.semanticOwner, this.transactionalEditingDomain);
        this.diagram.setElement(this.semanticOwner);
        DiagramUtils.setOwner(this.diagram, this.graphicalOwner);
        if (targetResource != null) {
            targetResource.getContents().add((Object)this.diagram);
        }
    }
}

