/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.ui.editor.factories;

import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.EMFEditUIPropertyEditorFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.emf.ui.editor.factories.CustomExtendedDialogCellEditor;
import org.eclipse.papyrus.emf.ui.messages.Messages;
import org.eclipse.papyrus.emf.ui.providers.labelproviders.DelegatingToEMFLabelProvider;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractEStructuralFeatureDialogEditorFactory
extends EMFEditUIPropertyEditorFactory {
    protected final EStructuralFeature editedFeature;
    protected ILabelProvider labelProvider;

    public AbstractEStructuralFeatureDialogEditorFactory(URI propertyEditorFactoryURI, EStructuralFeature editedFeature) {
        super(propertyEditorFactoryURI);
        this.editedFeature = editedFeature;
    }

    public final CellEditor createEditor(Object object, IItemPropertyDescriptor itemPropertyDescriptor, Composite composite) {
        if (!itemPropertyDescriptor.canSetProperty(object)) {
            return null;
        }
        Assert.isTrue((itemPropertyDescriptor.getFeature(object) == this.editedFeature ? 1 : 0) != 0, (String)NLS.bind((String)"The edited feature is {0} instead of {1}.", (Object)itemPropertyDescriptor.getFeature(object), (Object)this.editedFeature));
        Assert.isTrue((boolean)(object instanceof EObject), (String)"The edited object is not an EObject");
        EObject editedEObject = (EObject)object;
        CustomExtendedDialogCellEditor cellEditor = new CustomExtendedDialogCellEditor(composite, this.getOrCreateLabelProvider(), itemPropertyDescriptor, editedEObject, this.editedFeature);
        cellEditor.setDialogInput(this.getDialogInput(editedEObject));
        this.configureCellEditor(object, cellEditor);
        return cellEditor;
    }

    protected void configureCellEditor(Object editedObject, CustomExtendedDialogCellEditor cellEditor) {
        cellEditor.setDialogTitle(this.getDialogTitle());
        if (this.editedFeature.isMany()) {
            cellEditor.setDialogMessage(NLS.bind((String)Messages.AbstractEStructuralFeatureDialogEditorFactory_SelectOneOrSeveral, (Object)this.editedFeature.getEType().getName()));
        } else {
            cellEditor.setDialogMessage(NLS.bind((String)Messages.AbstractEStructuralFeatureDialogEditorFactory_SelectOne, (Object)this.editedFeature.getEType().getName()));
        }
    }

    protected String getDialogTitle() {
        return NLS.bind((String)Messages.AbstractEStructuralFeatureDialogEditorFactory_PapyrusDialogTitle, (Object)this.editedFeature.getEContainingClass().getName(), (Object)this.editedFeature.getName());
    }

    protected abstract Collection<?> getDialogInput(EObject var1);

    public ILabelProvider getOrCreateLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = DelegatingToEMFLabelProvider.INSTANCE;
        }
        return this.labelProvider;
    }
}

