/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.uml.diagram.common.util.MessageDirection;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.OLDGateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.locator.GateLocator;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Gate;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class GateHelper {
    private static final String CF_GATE_DATA = "CombinedFragment.InnerGate";
    private static final String CF_GATE_INSIDE = "insideCF";
    private static final String CF_GATE_OUTSIDE = "outsideCF";
    private static final String GATE_NAME_VOLATILE = "Gate.name.volatile";

    private GateHelper() {
    }

    public static View createView(View containerView, Gate gate) {
        if (containerView == null || gate == null) {
            return null;
        }
        Shape node = NotationFactory.eINSTANCE.createShape();
        node.setType("Gate");
        node.setElement((EObject)gate);
        node.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        ViewUtil.insertChildView((View)containerView, (View)node, (int)-1, (boolean)true);
        DecorationNode label = NotationFactory.eINSTANCE.createDecorationNode();
        label.setType("Gate_Name");
        label.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createLocation());
        ViewUtil.insertChildView((View)node, (View)label, (int)-1, (boolean)true);
        return node;
    }

    public static Gate createGate(Element parent, boolean createInnerCFGate) {
        if (parent == null) {
            return null;
        }
        String name = GateHelper.generateGateName((EObject)parent, "gate");
        Gate gate = null;
        if (parent instanceof Interaction) {
            gate = ((Interaction)parent).getFormalGate(name, false, true);
        } else if (parent instanceof CombinedFragment) {
            gate = ((CombinedFragment)parent).getCfragmentGate(name, false, true);
            if (createInnerCFGate) {
                Gate innerGate = ((CombinedFragment)parent).createCfragmentGate(GateHelper.generateGateName((EObject)parent, "gate"));
                EAnnotation ann = innerGate.createEAnnotation(CF_GATE_DATA);
                ann.getDetails().put((Object)CF_GATE_OUTSIDE, (Object)GateHelper.getIdentification(gate));
                ann = gate.createEAnnotation(CF_GATE_DATA);
                ann.getDetails().put((Object)CF_GATE_INSIDE, (Object)GateHelper.getIdentification(innerGate));
            }
        } else if (parent instanceof InteractionUse) {
            InteractionUse interactionUse = (InteractionUse)parent;
            Interaction refersTo = interactionUse.getRefersTo();
            if (refersTo != null) {
                refersTo.getFormalGate(name, false, true);
            }
            gate = interactionUse.getActualGate(name, false, true);
        }
        return gate;
    }

    protected static String getIdentification(Gate gate) {
        if (gate == null) {
            return null;
        }
        if (gate.eResource() != null) {
            return gate.eResource().getURIFragment((EObject)gate);
        }
        return gate.getName();
    }

    protected static Gate findGate(CombinedFragment cf, String identification) {
        EObject eObject;
        if (cf == null || identification == null) {
            return null;
        }
        if (cf.eResource() != null && (eObject = cf.eResource().getEObject(identification)) instanceof Gate) {
            return (Gate)eObject;
        }
        return cf.getCfragmentGate(identification);
    }

    public static Gate getInnerCFGate(Gate outerGate) {
        if (outerGate == null || !(outerGate.eContainer() instanceof CombinedFragment)) {
            return null;
        }
        CombinedFragment cf = (CombinedFragment)outerGate.eContainer();
        EAnnotation ann = outerGate.getEAnnotation(CF_GATE_DATA);
        if (ann != null) {
            String name = (String)ann.getDetails().get((Object)CF_GATE_INSIDE);
            return GateHelper.findGate(cf, name);
        }
        return null;
    }

    public static Gate getOuterCFGate(Gate innerGate) {
        if (innerGate == null || !(innerGate.eContainer() instanceof CombinedFragment)) {
            return null;
        }
        CombinedFragment cf = (CombinedFragment)innerGate.eContainer();
        EAnnotation ann = innerGate.getEAnnotation(CF_GATE_DATA);
        if (ann != null) {
            String name = (String)ann.getDetails().get((Object)CF_GATE_OUTSIDE);
            return GateHelper.findGate(cf, name);
        }
        return null;
    }

    public static boolean isInnerCFGate(Gate gate) {
        if (gate == null || !(gate.eContainer() instanceof CombinedFragment)) {
            return false;
        }
        CombinedFragment cf = (CombinedFragment)gate.eContainer();
        EAnnotation ann = gate.getEAnnotation(CF_GATE_DATA);
        if (ann != null) {
            String name = (String)ann.getDetails().get((Object)CF_GATE_OUTSIDE);
            return GateHelper.findGate(cf, name) != null;
        }
        return false;
    }

    public static Message getOuterCFMessage(Message message) {
        MessageEnd receiveEvent;
        if (message == null) {
            return null;
        }
        MessageEnd sendEvent = message.getSendEvent();
        if (sendEvent instanceof Gate) {
            Gate gate = (Gate)sendEvent;
            if (!GateHelper.isInnerCFGate(gate)) {
                return null;
            }
            Gate outerGate = GateHelper.getOuterCFGate(gate);
            if (outerGate != null) {
                return outerGate.getMessage();
            }
        }
        if ((receiveEvent = message.getReceiveEvent()) instanceof Gate) {
            Gate gate = (Gate)receiveEvent;
            if (!GateHelper.isInnerCFGate(gate)) {
                return null;
            }
            Gate outerGate = GateHelper.getOuterCFGate(gate);
            if (outerGate != null) {
                return outerGate.getMessage();
            }
        }
        return null;
    }

    public static Gate getActualGate(Gate gate) {
        if (gate == null || !(gate.eContainer() instanceof Interaction)) {
            return null;
        }
        Interaction interaction = (Interaction)gate.eContainer();
        List<InteractionUse> refersToBy = GateHelper.findRefersToBy(interaction);
        for (InteractionUse interactionUse : refersToBy) {
            Gate actualGate = interactionUse.getActualGate(gate.getName());
            if (actualGate == null) continue;
            return actualGate;
        }
        return null;
    }

    public static List<InteractionUse> findRefersToBy(Interaction interaction) {
        if (interaction == null) {
            return Collections.emptyList();
        }
        ArrayList<InteractionUse> refersToBy = new ArrayList<InteractionUse>();
        Resource eResource = interaction.eResource();
        if (eResource != null) {
            ResourceSet resourceSet = eResource.getResourceSet();
            if (resourceSet != null) {
                EList resources = resourceSet.getResources();
                for (Resource resource : resources) {
                    TreeIterator contents = resource.getAllContents();
                    while (contents.hasNext()) {
                        EObject next = (EObject)contents.next();
                        if (!(next instanceof InteractionUse) || interaction != ((InteractionUse)next).getRefersTo()) continue;
                        refersToBy.add((InteractionUse)next);
                    }
                }
            } else {
                TreeIterator contents = eResource.getAllContents();
                while (contents.hasNext()) {
                    EObject next = (EObject)contents.next();
                    if (!(next instanceof InteractionUse) || interaction != ((InteractionUse)next).getRefersTo()) continue;
                    refersToBy.add((InteractionUse)next);
                }
            }
        } else {
            EList fragments = interaction.getFragments();
            for (InteractionFragment fragment : fragments) {
                if (!(fragment instanceof InteractionUse) || interaction != ((InteractionUse)fragment).getRefersTo()) continue;
                refersToBy.add((InteractionUse)fragment);
            }
        }
        return refersToBy;
    }

    public static String generateGateName(EObject container, String suffix) {
        int index = GateHelper.getTotalGatesNumber(container);
        Object name = suffix;
        if (container instanceof Interaction) {
            Interaction interaction = (Interaction)container;
            if (!"gate".equals(suffix) && interaction.getFormalGate(suffix) == null) {
                return suffix;
            }
            String gateName = (String)name + index;
            while (interaction.getFormalGate(gateName = (String)name + index) != null) {
                ++index;
            }
            name = gateName;
        } else if (container instanceof InteractionUse) {
            InteractionUse iUse = (InteractionUse)container;
            if (!"gate".equals(suffix) && iUse.getActualGate(suffix) == null) {
                return suffix;
            }
            String gateName = (String)name + index;
            while (iUse.getActualGate(gateName = (String)name + index) != null) {
                ++index;
            }
            name = gateName;
        } else if (container instanceof CombinedFragment) {
            CombinedFragment cf = (CombinedFragment)container;
            if (!"gate".equals(suffix) && cf.getCfragmentGate(suffix) == null) {
                return suffix;
            }
            String gateName = (String)name + index;
            while (cf.getCfragmentGate(gateName = (String)name + index) != null) {
                ++index;
            }
            name = gateName;
        }
        return name;
    }

    private static int getTotalGatesNumber(EObject parent) {
        Interaction interaction = GateHelper.getRootInteraction(parent);
        if (interaction == null) {
            return 0;
        }
        int size = 0;
        TreeIterator allContents = interaction.eAllContents();
        while (allContents.hasNext()) {
            if (!(allContents.next() instanceof Gate)) continue;
            ++size;
        }
        return size;
    }

    private static Interaction getRootInteraction(EObject eObj) {
        if (eObj == null) {
            return null;
        }
        if (eObj instanceof Interaction) {
            return (Interaction)eObj;
        }
        return GateHelper.getRootInteraction(eObj.eContainer());
    }

    public static Point computeGateLocation(Point pt, IFigure hostFigure, IFigure gateFigure) {
        if (pt == null || hostFigure == null) {
            return pt;
        }
        Point location = pt.getCopy();
        Rectangle bounds = new Rectangle(location, OLDGateEditPart.DEFAULT_SIZE);
        hostFigure.translateToRelative((Translatable)bounds);
        GateLocator locator = new GateLocator(hostFigure);
        Rectangle validLocation = locator.getValidLocation(bounds, gateFigure);
        return validLocation.getLocation().getTranslated(0, -OLDGateEditPart.DEFAULT_SIZE.height / 2 - 1);
    }

    public static void updateGateName(TransactionalEditingDomain editingDomain, final Gate gate, final String newName) {
        if (gate == null) {
            return;
        }
        String name = gate.getName();
        if (name == null && newName == null) {
            return;
        }
        if (name != null && name.equals(newName)) {
            return;
        }
        AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(editingDomain, "", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                gate.setName(newName);
                return CommandResult.newOKCommandResult();
            }
        };
        CommandStack commandStack = editingDomain.getCommandStack();
        GMFtoEMFCommandWrapper command = new GMFtoEMFCommandWrapper((ICommand)cmd);
        if (commandStack instanceof TransactionalCommandStack) {
            try {
                ((TransactionalCommandStack)commandStack).execute((Command)command, Collections.singletonMap("unprotected", Boolean.TRUE));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (RollbackException e) {
                e.printStackTrace();
            }
        } else {
            commandStack.execute((Command)command);
        }
    }

    public static String getGateLabel(Gate gate) {
        Message message = gate.getMessage();
        if (message != null) {
            MessageDirection direction = null;
            EObject parent = gate.eContainer();
            if (parent instanceof CombinedFragment) {
                CombinedFragment cf = (CombinedFragment)parent;
                if (gate == message.getSendEvent()) {
                    MessageEnd receiveEvent = message.getReceiveEvent();
                    Lifeline lifeline = GateHelper.getCoveredBy(receiveEvent);
                    direction = !cf.getCovereds().contains((Object)lifeline) ? MessageDirection.OUT : MessageDirection.IN;
                } else {
                    MessageEnd sendEvent = message.getSendEvent();
                    Lifeline coveredBy = GateHelper.getCoveredBy(sendEvent);
                    direction = !cf.getCovereds().contains((Object)coveredBy) ? MessageDirection.IN : MessageDirection.OUT;
                }
            } else if (parent instanceof Interaction) {
                if (gate == message.getSendEvent()) {
                    direction = MessageDirection.IN;
                } else if (gate == message.getReceiveEvent()) {
                    direction = MessageDirection.OUT;
                }
            }
            if (direction == null) {
                if (gate == message.getSendEvent()) {
                    direction = MessageDirection.OUT;
                } else if (gate == message.getReceiveEvent()) {
                    direction = MessageDirection.IN;
                }
            }
            if (direction != null) {
                StringBuffer buf = new StringBuffer();
                buf.append(direction.getName() + "_");
                buf.append(UMLLabelInternationalization.getInstance().getLabel((NamedElement)message));
                return new String(buf);
            }
        }
        return gate.getLabel();
    }

    private static Lifeline getCoveredBy(MessageEnd messageEnd) {
        if (messageEnd == null) {
            return null;
        }
        if (messageEnd instanceof OccurrenceSpecification) {
            return ((OccurrenceSpecification)messageEnd).getCovered();
        }
        return null;
    }

    public static void setVolatile(Gate gate, boolean value) {
        Gate innerGate;
        if (gate == null) {
            return;
        }
        EAnnotation annotation = gate.getEAnnotation(GATE_NAME_VOLATILE);
        if (value) {
            if (annotation == null) {
                annotation = gate.createEAnnotation(GATE_NAME_VOLATILE);
            }
            annotation.getDetails().put((Object)GATE_NAME_VOLATILE, (Object)Boolean.toString(value));
        } else if (annotation != null) {
            gate.getEAnnotations().remove((Object)annotation);
        }
        if (gate.eContainer() instanceof InteractionUse) {
            Gate formalGate;
            Interaction refersTo = ((InteractionUse)gate.eContainer()).getRefersTo();
            if (refersTo != null && (formalGate = refersTo.getFormalGate(gate.getName())) != null) {
                GateHelper.setVolatile(formalGate, value);
            }
        } else if (!GateHelper.isInnerCFGate(gate) && (innerGate = GateHelper.getInnerCFGate(gate)) != null) {
            GateHelper.setVolatile(innerGate, value);
        }
    }

    public static boolean isVolatile(Gate gate) {
        if (gate == null) {
            return false;
        }
        EAnnotation ann = gate.getEAnnotation(GATE_NAME_VOLATILE);
        return ann != null;
    }

    public static void updateGateWithMessage(Message message, boolean force) {
        Gate gate;
        if (message == null) {
            return;
        }
        MessageEnd sendEvent = message.getSendEvent();
        MessageEnd receiveEvent = message.getReceiveEvent();
        if (sendEvent instanceof Gate) {
            gate = (Gate)sendEvent;
            GateHelper.updateGateName(gate, force);
        }
        if (receiveEvent instanceof Gate) {
            gate = (Gate)receiveEvent;
            GateHelper.updateGateName(gate, force);
        }
    }

    protected static void updateGateName(Gate gate, boolean force) {
        if (gate == null) {
            return;
        }
        if (gate.eContainer() instanceof InteractionUse) {
            Interaction refersTo = ((InteractionUse)gate.eContainer()).getRefersTo();
            if (refersTo != null) {
                Gate formalGate = refersTo.getFormalGate(gate.getName());
                if (formalGate != null && GateHelper.isVolatile(formalGate)) {
                    formalGate.setName(GateHelper.getGateLabel(gate));
                    if (force) {
                        GateHelper.setVolatile(formalGate, false);
                    }
                }
            } else if (GateHelper.isVolatile(gate)) {
                gate.setName(GateHelper.getGateLabel(gate));
                if (force) {
                    GateHelper.setVolatile(gate, false);
                }
            }
        } else if (!GateHelper.isInnerCFGate(gate)) {
            Gate innerGate;
            String newName = GateHelper.getGateLabel(gate);
            if (GateHelper.isVolatile(gate)) {
                gate.setName(newName);
            }
            if ((innerGate = GateHelper.getInnerCFGate(gate)) != null && GateHelper.isVolatile(innerGate)) {
                innerGate.setName(newName);
                if (force) {
                    GateHelper.setVolatile(innerGate, false);
                }
            }
            if (force) {
                GateHelper.setVolatile(gate, false);
            }
        }
    }
}

