/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.css.xml.engine;

import org.eclipse.e4.ui.css.core.dom.properties.css2.AbstractCSSPropertyFontHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyFontHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyFontXMLHandler
extends AbstractCSSPropertyFontHandler {
    public static final ICSSPropertyFontHandler INSTANCE = new CSSPropertyFontXMLHandler();

    public boolean applyCSSProperty(Object node, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (node instanceof Element && ((Node)node).getOwnerDocument() != null) {
            super.applyCSSProperty(node, property, value, pseudo, engine);
            return true;
        }
        return false;
    }

    public void applyCSSPropertyFontSize(Object node, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (value.getCssValueType() == 1) {
            Element element = (Element)node;
            int size = (int)((CSSPrimitiveValue)value).getFloatValue((short)9);
            element.setAttribute("size", "" + size);
        }
    }

    public void applyCSSPropertyFontWeight(Object node, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (value.getCssValueType() == 1) {
            Element element = (Element)node;
            String weight = ((CSSPrimitiveValue)value).getStringValue();
            if ("bold".equals(weight.toLowerCase())) {
                this.insertElement(element, "b");
            }
        }
    }

    public void applyCSSPropertyFontStyle(Object node, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        if (value.getCssValueType() == 1) {
            Element element = (Element)node;
            String style = ((CSSPrimitiveValue)value).getStringValue();
            if ("italic".equals(style)) {
                this.insertElement(element, "i");
            }
        }
    }

    public String retrieveCSSPropertyFontAdjust(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyFontFamily(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyFontSize(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyFontStretch(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyFontStyle(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyFontVariant(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    public String retrieveCSSPropertyFontWeight(Object element, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }

    private void insertElement(Element element, String elementName) {
        Element b = element.getOwnerDocument().createElement(elementName);
        NodeList nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            b.appendChild(node.cloneNode(true));
            node.getParentNode().removeChild(node);
            ++i;
        }
        element.appendChild(b);
    }
}

