/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.ArrayList;
import java.util.Optional;
import java.util.OptionalInt;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.draw2d.anchors.FixedAnchor;
import org.eclipse.papyrus.uml.diagram.sequence.LifelineNodePlate;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.CInteractionOperandEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ExecutionSpecificationRectangleFigure;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageCreateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.MessageDeleteEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.LifeLineRestorePositionEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.LifelineSelectionEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UpdateNodeReferenceEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UpdateWeakReferenceForExecSpecEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UpdateWeakReferenceForMessageSpecEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.figures.ILifelineInternalFigure;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifeLineLayoutManager;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineFigure;
import org.eclipse.papyrus.uml.diagram.sequence.figures.LifelineNodeFigure;
import org.eclipse.papyrus.uml.diagram.sequence.locator.MessageCreateLifelineAnchor;
import org.eclipse.papyrus.uml.diagram.sequence.locator.TimeElementLocator;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.referencialgrilling.DisplayEvent;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.MessageSort;

public class CLifeLineEditPart
extends LifelineEditPart {
    public static int DEFAUT_HEIGHT = 700;
    public static int DEFAUT_WIDTH = 100;
    public static int MIN_HEIGHT = 100;
    private EditPart activeCreateFeedbackEditPart;

    public CLifeLineEditPart(View view) {
        super(view);
    }

    protected NodeFigure createSVGNodePlate() {
        if (this.svgNodePlate == null) {
            this.svgNodePlate = new LifelineNodePlate((GraphicalEditPart)this, -1, -1).withLinkLFEnabled();
            this.svgNodePlate.setDefaultNodePlate((IFigure)this.createNodePlate());
        }
        return this.svgNodePlate;
    }

    protected NodeFigure createNodeFigure() {
        return new LifelineNodeFigure((IFigure)this.createMainFigureWithSVG());
    }

    public void refresh() {
        if (this.getPrimaryShape() instanceof LifelineFigure) {
            ArrayList<NodeFigure> childrenFigure = new ArrayList<NodeFigure>();
            for (Object current : this.getChildren()) {
                if (!(current instanceof AbstractExecutionSpecificationEditPart)) continue;
                ExecutionSpecificationRectangleFigure figure = ((AbstractExecutionSpecificationEditPart)((Object)current)).getPrimaryShape();
                childrenFigure.add((NodeFigure)figure);
            }
            this.getPrimaryShape().setChildrenFigure(childrenFigure);
        }
        super.refresh();
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new LifelineSelectionEditPolicy());
        this.installEditPolicy("LIFELINE_RESTORE_POSITION_EDITPOLICY", (EditPolicy)new LifeLineRestorePositionEditPolicy());
        this.installEditPolicy(UpdateNodeReferenceEditPolicy.UDPATE_NODE_REFERENCE, (EditPolicy)new UpdateNodeReferenceEditPolicy());
        this.installEditPolicy("UpdateWeakReferenceForMessageSpecEditPolicy", (EditPolicy)new UpdateWeakReferenceForMessageSpecEditPolicy());
        this.installEditPolicy("UpdateWeakReferenceForExecSpecEditPolicy", (EditPolicy)new UpdateWeakReferenceForExecSpecEditPolicy());
    }

    public void setLayoutConstraint(EditPart child, IFigure childFigure, Object constraint) {
        if (!(childFigure instanceof ILifelineInternalFigure)) {
            this.getPrimaryShape().setConstraint(childFigure, constraint);
        }
    }

    public int getStickerHeight() {
        if (this.getPrimaryShape().getLifeLineLayoutManager() != null) {
            return ((LifeLineLayoutManager)this.getPrimaryShape().getLifeLineLayoutManager()).getBottomHeader() - this.getPrimaryShape().getBounds().y();
        }
        return -1;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        if (connEditPart instanceof MessageCreateEditPart) {
            return new MessageCreateLifelineAnchor((IFigure)this.getPrimaryShape(), this);
        }
        if (connEditPart instanceof MessageDeleteEditPart) {
            return new FixedAnchor((IFigure)this.getPrimaryShape(), 1);
        }
        return super.getTargetConnectionAnchor(connEditPart);
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof CreateViewAndElementRequest) {
            EditPart container;
            CreateViewAndElementRequest req = (CreateViewAndElementRequest)request;
            if (UMLElementTypes.InteractionOperand_Shape.equals(req.getViewAndElementDescriptor().getElementAdapter().getAdapter(IElementType.class))) {
                Object container2 = SequenceUtil.findInteractionFragmentContainerEditPartAt(req.getLocation(), (EditPart)this);
                if (container2 instanceof CInteractionOperandEditPart) {
                    container2 = SequenceUtil.getParentCombinedFragmentPart((EditPart)container2);
                }
                if (container2 != null) {
                    return container2.getTargetEditPart(request);
                }
            } else if ((UMLElementTypes.CombinedFragment_Shape.equals(req.getViewAndElementDescriptor().getElementAdapter().getAdapter(IElementType.class)) || UMLElementTypes.InteractionUse_Shape.equals(req.getViewAndElementDescriptor().getElementAdapter().getAdapter(IElementType.class))) && (container = SequenceUtil.getInteractionCompartment((EditPart)this)) != null) {
                return container.getTargetEditPart(request);
            }
        }
        return super.getTargetEditPart(request);
    }

    public void showTargetFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            ((CreateUnspecifiedTypeRequest)request).getElementTypes().forEach(t -> {
                CreateRequest req = ((CreateUnspecifiedTypeRequest)request).getRequestForType((IElementType)t);
                EditPart targetEP = this.getTargetEditPart((Request)req);
                if (this.activeCreateFeedbackEditPart != targetEP) {
                    if (this.activeCreateFeedbackEditPart != null) {
                        this.activeCreateFeedbackEditPart.eraseTargetFeedback(request);
                    }
                    this.activeCreateFeedbackEditPart = targetEP;
                }
                if (targetEP != this) {
                    targetEP.showTargetFeedback(request);
                } else {
                    super.showTargetFeedback(request);
                }
            });
            return;
        }
        super.showTargetFeedback(request);
    }

    public void eraseTargetFeedback(Request request) {
        if (request instanceof CreateUnspecifiedTypeRequest) {
            ((CreateUnspecifiedTypeRequest)request).getElementTypes().forEach(t -> {
                CreateRequest req = ((CreateUnspecifiedTypeRequest)request).getRequestForType((IElementType)t);
                EditPart targetEP = this.getTargetEditPart((Request)req);
                if (this.activeCreateFeedbackEditPart != null && this.activeCreateFeedbackEditPart != this) {
                    this.activeCreateFeedbackEditPart.eraseTargetFeedback(request);
                    this.activeCreateFeedbackEditPart = null;
                }
                if (targetEP != this) {
                    targetEP.eraseTargetFeedback(request);
                } else {
                    super.eraseTargetFeedback(request);
                }
            });
            return;
        }
        super.eraseTargetFeedback(request);
    }

    @Override
    protected boolean addFixedChild(EditPart childEditPart) {
        Optional<MessageEnd> createEnd = TimeElementLocator.getTimedElement(childEditPart, MessageEnd.class).filter(MessageEnd::isReceive).filter(end -> end.getMessage().getMessageSort() == MessageSort.CREATE_MESSAGE_LITERAL);
        return createEnd.map(__ -> {
            this.getBorderedFigure().getBorderItemContainer().add(((IGraphicalEditPart)childEditPart).getFigure(), (Object)new TimeElementLocator(this.getMainFigure(), this::getTimeElementSide));
            return true;
        }).orElseGet(() -> super.addFixedChild(childEditPart));
    }

    public OptionalInt getCreateMessageIncomingSide(Point where) {
        Point search = where.getCopy();
        this.getMainFigure().translateToAbsolute((Translatable)search);
        DisplayEvent displayEvent = new DisplayEvent((EditPart)this);
        MessageOccurrenceSpecification end = displayEvent.getMessageEvent(this.getMainFigure(), search);
        if (end != null && end.isReceive() && end.getMessage().getMessageSort() == MessageSort.CREATE_MESSAGE_LITERAL) {
            return this.getCreateMessageIncomingSide((MessageEnd)end);
        }
        return OptionalInt.empty();
    }

    private OptionalInt getCreateMessageIncomingSide(MessageEnd end) {
        LifelineFigure lifelineFigure = (LifelineFigure)((Object)this.svgNodePlate.getChildren().get(0));
        IFigure headerFigure = lifelineFigure.getHeaderFigure();
        OptionalInt result = OptionalInt.empty();
        for (Object next : this.getTargetConnections()) {
            Message message;
            ConnectionEditPart incoming = (ConnectionEditPart)next;
            EObject semantic = (EObject)incoming.getAdapter(EObject.class);
            if (!(semantic instanceof Message) || (message = (Message)semantic).getMessageSort() != MessageSort.CREATE_MESSAGE_LITERAL) continue;
            Point headCenter = headerFigure.getBounds().getCenter();
            lifelineFigure.translateToAbsolute((Translatable)headCenter);
            Connection conn = (Connection)incoming.getFigure();
            Point target = conn.getPoints().getLastPoint();
            result = target.x() > headCenter.x() ? OptionalInt.of(16) : OptionalInt.of(8);
        }
        return result;
    }

    int getTimeElementSide(Rectangle proposedBounds) {
        OptionalInt incoming = this.getCreateMessageIncomingSide(proposedBounds.getTopLeft());
        return incoming.isPresent() ? 0x18 ^ incoming.getAsInt() : 2;
    }
}

