/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text.atl.types;

import java.util.Collection;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.AtlTypesProcessor;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.CollectionType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.ModelElementType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OclAnyType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.OrderedSetType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.SequenceType;
import org.eclipse.m2m.atl.adt.ui.text.atl.types.UnitType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Feature
implements Comparable<Feature> {
    private static final String DOCUMENTATION_COMMENTS_PREFIX = "---";
    protected String name;
    private UnitType unit;
    private OclAnyType contextType;
    private OclAnyType type;
    private boolean many;
    private boolean ordered;
    private int lower;
    private int upper;
    private String imagePath;
    private boolean container;
    private String oppositeName;
    private EObject declaration;
    protected String documentation;

    public Feature(UnitType unit, EObject declaration, String name, OclAnyType contextType, OclAnyType type, boolean ordered, boolean container, int lower, int upper) {
        this.name = name;
        this.type = type;
        this.contextType = contextType;
        this.ordered = ordered;
        this.lower = lower;
        this.upper = upper;
        this.container = container;
        this.many = false;
        this.declaration = declaration;
        this.unit = unit;
        this.imagePath = this.isMany() ? "$nl$/icons/model_reference.gif" : "$nl$/icons/model_attribute.gif";
    }

    public Feature(UnitType unit, EStructuralFeature feature, String metamodelName) {
        this.name = feature.getName();
        this.type = ModelElementType.create(feature.getEType(), metamodelName);
        this.contextType = ModelElementType.create((EClassifier)feature.getEContainingClass(), metamodelName);
        this.ordered = feature.isOrdered();
        this.lower = feature.getLowerBound();
        this.upper = feature.getUpperBound();
        this.container = false;
        this.declaration = feature;
        if (feature instanceof EReference) {
            this.container = ((EReference)feature).isContainment();
            EReference opposite = ((EReference)feature).getEOpposite();
            if (opposite != null) {
                this.oppositeName = opposite.getName();
            }
        }
        this.many = this.upper > 1 || this.upper == -1;
        this.imagePath = this.isMany() ? "$nl$/icons/model_reference.gif" : "$nl$/icons/model_attribute.gif";
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isMany() {
        return this.many;
    }

    public String getOppositeName() {
        return this.oppositeName;
    }

    public boolean isContainer() {
        return this.container;
    }

    public String getName() {
        return this.name;
    }

    public OclAnyType getType() {
        if (this.many) {
            return new SequenceType(this.type);
        }
        return this.type;
    }

    public EObject getDeclaration() {
        return this.declaration;
    }

    public OclAnyType getContextType() {
        return this.contextType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Feature) {
            Feature feature = (Feature)obj;
            return this.name.equals(feature.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public int getLowerBound() {
        return this.lower;
    }

    public int getUpperBound() {
        return this.upper;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public static Feature createFromAttribute(UnitType unit, EObject attribute, OclAnyType context) {
        String featureName = (String)AtlTypesProcessor.eGet(attribute, "name");
        EObject featureType = (EObject)AtlTypesProcessor.eGet(attribute, "type");
        OclAnyType type = OclAnyType.create(unit.getSourceManager(), featureType);
        if (featureName != null) {
            String doc;
            boolean ordered = type instanceof SequenceType || type instanceof OrderedSetType;
            int upper = 1;
            if (type instanceof CollectionType) {
                upper = -1;
            }
            Feature feature = new Feature(unit, attribute, featureName, context, type, ordered, false, 1, upper);
            feature.setImagePath("$nl$/icons/helper.gif");
            EObject container = attribute.eContainer();
            if (container != null && (container = container.eContainer()) != null && (doc = Feature.getDocumentation(container)) != null && doc.length() > 0) {
                feature.setDocumentation(doc);
            }
            return feature;
        }
        return null;
    }

    public UnitType getUnit() {
        return this.unit;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(Feature o) {
        return this.toString().compareTo(o.toString());
    }

    public String getInformation() {
        StringBuffer information = new StringBuffer();
        information.append(this.getName());
        information.append(" : ");
        if (this.isMany()) {
            OclAnyType type = this.getType();
            if (type instanceof CollectionType) {
                information.append(((CollectionType)type).getParameterType());
            } else {
                information.append(this.getType());
            }
            information.append(' ');
            if (this.isContainer()) {
                information.append('[');
            } else {
                information.append('{');
            }
            information.append(this.getLowerBound());
            information.append("..");
            if (this.getUpperBound() == -1) {
                information.append('*');
            } else {
                information.append(this.getUpperBound());
            }
            if (this.isContainer()) {
                information.append(']');
            } else {
                information.append('}');
            }
        } else {
            information.append(this.getType());
        }
        information.append(" - " + this.getContextType());
        return information.toString();
    }

    public String getDocumentation() {
        StringBuffer doc = new StringBuffer();
        doc.append(String.valueOf(this.getName()) + ": " + this.getType());
        if (this.documentation != null && !this.documentation.trim().equals("")) {
            doc.append("\n\n" + this.documentation);
        }
        return doc.toString();
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    protected static String getDocumentation(EObject element) {
        Collection comments = (Collection)AtlTypesProcessor.eGet(element, "commentsBefore");
        StringBuffer buf = new StringBuffer();
        for (Object line : comments) {
            if (!line.toString().startsWith(DOCUMENTATION_COMMENTS_PREFIX)) continue;
            buf.append(line.toString().replaceFirst(DOCUMENTATION_COMMENTS_PREFIX, ""));
            buf.append('\n');
        }
        return buf.toString().trim();
    }
}

