/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.common;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.m2m.atl.adt.ui.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class WorkspaceFileDialog
extends ElementTreeSelectionDialog {
    public WorkspaceFileDialog(Shell parent, final String ... extensions) {
        super(parent, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        this.setInput(ResourcesPlugin.getWorkspace().getRoot());
        this.setMessage(Messages.getString("WorkspaceFileDialog.SELECT_FILE"));
        this.setTitle(Messages.getString("WorkspaceFileDialog.SELECT_FILE"));
        this.setAllowMultiple(false);
        this.setDoubleClickSelects(true);
        this.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean ret = false;
                try {
                    ret = WorkspaceFileDialog.isResourceAvailable((IResource)element, extensions);
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
                return ret;
            }
        });
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                IStatus ret = Status.CANCEL_STATUS;
                if (selection.length == 1 && selection[0] instanceof IFile) {
                    ret = Status.OK_STATUS;
                }
                return ret;
            }
        });
    }

    private static boolean isResourceAvailable(IResource resource, String ... extensions) throws CoreException {
        block8: {
            block7: {
                IResource[] members;
                if (!(resource instanceof IContainer)) break block7;
                if (!((IContainer)resource).isAccessible()) break block8;
                IResource[] iResourceArray = members = ((IContainer)resource).members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (WorkspaceFileDialog.isResourceAvailable(member, extensions)) {
                        return true;
                    }
                    ++n2;
                }
                break block8;
            }
            if (resource instanceof IFile) {
                IFile currentFile = (IFile)resource;
                if (extensions == null || extensions.length == 0) {
                    return true;
                }
                if (currentFile.getFileExtension() != null) {
                    int i = 0;
                    while (i < extensions.length) {
                        String extension = extensions[i];
                        if (currentFile.getFileExtension().toUpperCase().equals(extension.toUpperCase())) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
        }
        return false;
    }
}

