/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.types.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.ocl.internal.OCLPlugin;
import org.eclipse.ocl.types.AnyType;
import org.eclipse.ocl.types.BagType;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.ElementType;
import org.eclipse.ocl.types.InvalidType;
import org.eclipse.ocl.types.MessageType;
import org.eclipse.ocl.types.OrderedSetType;
import org.eclipse.ocl.types.PrimitiveType;
import org.eclipse.ocl.types.SequenceType;
import org.eclipse.ocl.types.SetType;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.types.TypeType;
import org.eclipse.ocl.types.TypesPackage;
import org.eclipse.ocl.types.VoidType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypesValidator
extends EObjectValidator {
    public static final TypesValidator INSTANCE = new TypesValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.ocl.types";
    public static final int BAG_TYPE__COLLECTION_TYPE_NAME = 1;
    public static final int COLLECTION_TYPE__COLLECTION_TYPE_NAME = 2;
    public static final int COLLECTION_TYPE__NO_INVALID_VALUES = 3;
    public static final int MESSAGE_TYPE__EXCLUSIVE_SIGNATURE = 4;
    public static final int MESSAGE_TYPE__OPERATION_PARAMETERS = 5;
    public static final int MESSAGE_TYPE__SIGNAL_ATTRIBUTES = 6;
    public static final int ORDERED_SET_TYPE__COLLECTION_TYPE_NAME = 7;
    public static final int SEQUENCE_TYPE__COLLECTION_TYPE_NAME = 8;
    public static final int SET_TYPE__COLLECTION_TYPE_NAME = 9;
    public static final int TUPLE_TYPE__TUPLE_TYPE_NAME = 10;
    public static final int TUPLE_TYPE__PART_NAMES_UNIQUE = 11;
    public static final int TUPLE_TYPE__FEATURES_ONLY_PROPERTIES = 12;
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 12;
    protected static final int DIAGNOSTIC_CODE_COUNT = 12;

    protected EPackage getEPackage() {
        return TypesPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateAnyType((AnyType)value, diagnostics, context);
            }
            case 1: {
                return this.validateBagType((BagType)value, diagnostics, context);
            }
            case 2: {
                return this.validateCollectionType((CollectionType)value, diagnostics, context);
            }
            case 3: {
                return this.validateElementType((ElementType)value, diagnostics, context);
            }
            case 4: {
                return this.validateInvalidType((InvalidType)value, diagnostics, context);
            }
            case 5: {
                return this.validateMessageType((MessageType)value, diagnostics, context);
            }
            case 6: {
                return this.validateOrderedSetType((OrderedSetType)value, diagnostics, context);
            }
            case 7: {
                return this.validatePrimitiveType((PrimitiveType)value, diagnostics, context);
            }
            case 8: {
                return this.validateSequenceType((SequenceType)value, diagnostics, context);
            }
            case 9: {
                return this.validateSetType((SetType)value, diagnostics, context);
            }
            case 10: {
                return this.validateTupleType((TupleType)value, diagnostics, context);
            }
            case 11: {
                return this.validateTypeType((TypeType)value, diagnostics, context);
            }
            case 12: {
                return this.validateVoidType((VoidType)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateAnyType(AnyType<?> anyType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(anyType, diagnostics, context);
    }

    public boolean validateBagType(BagType<?, ?> bagType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(bagType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(bagType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(bagType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(bagType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(bagType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(bagType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(bagType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateBagType_checkCollectionTypeName(bagType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCollectionType_checkNoInvalidValues(bagType, diagnostics, context);
        }
        return result;
    }

    public boolean validateBagType_checkCollectionTypeName(BagType<?, ?> bagType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateCollectionType(CollectionType<?, ?> collectionType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(collectionType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(collectionType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(collectionType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(collectionType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(collectionType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(collectionType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(collectionType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCollectionType_checkCollectionTypeName(collectionType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCollectionType_checkNoInvalidValues(collectionType, diagnostics, context);
        }
        return result;
    }

    public boolean validateCollectionType_checkCollectionTypeName(CollectionType<?, ?> collectionType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return collectionType.checkCollectionTypeName(diagnostics, context);
    }

    public boolean validateCollectionType_checkNoInvalidValues(CollectionType<?, ?> collectionType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return collectionType.checkNoInvalidValues(diagnostics, context);
    }

    public boolean validateElementType(ElementType elementType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(elementType, diagnostics, context);
    }

    public boolean validateInvalidType(InvalidType<?> invalidType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(invalidType, diagnostics, context);
    }

    public boolean validateMessageType(MessageType<?, ?, ?> messageType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(messageType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMessageType_checkExclusiveSignature(messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMessageType_checkOperationParameters(messageType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateMessageType_checkSignalAttributes(messageType, diagnostics, context);
        }
        return result;
    }

    public boolean validateMessageType_checkExclusiveSignature(MessageType<?, ?, ?> messageType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return messageType.checkExclusiveSignature(diagnostics, context);
    }

    public boolean validateMessageType_checkOperationParameters(MessageType<?, ?, ?> messageType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return messageType.checkOperationParameters(diagnostics, context);
    }

    public boolean validateMessageType_checkSignalAttributes(MessageType<?, ?, ?> messageType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return messageType.checkSignalAttributes(diagnostics, context);
    }

    public boolean validateOrderedSetType(OrderedSetType<?, ?> orderedSetType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(orderedSetType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(orderedSetType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(orderedSetType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(orderedSetType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(orderedSetType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(orderedSetType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(orderedSetType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateOrderedSetType_checkCollectionTypeName(orderedSetType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCollectionType_checkNoInvalidValues(orderedSetType, diagnostics, context);
        }
        return result;
    }

    public boolean validateOrderedSetType_checkCollectionTypeName(OrderedSetType<?, ?> orderedSetType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validatePrimitiveType(PrimitiveType<?> primitiveType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(primitiveType, diagnostics, context);
    }

    public boolean validateSequenceType(SequenceType<?, ?> sequenceType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(sequenceType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(sequenceType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(sequenceType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(sequenceType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(sequenceType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(sequenceType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(sequenceType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSequenceType_checkCollectionTypeName(sequenceType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCollectionType_checkNoInvalidValues(sequenceType, diagnostics, context);
        }
        return result;
    }

    public boolean validateSequenceType_checkCollectionTypeName(SequenceType<?, ?> sequenceType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateSetType(SetType<?, ?> setType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(setType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(setType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(setType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(setType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(setType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(setType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(setType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSetType_checkCollectionTypeName(setType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCollectionType_checkNoInvalidValues(setType, diagnostics, context);
        }
        return result;
    }

    public boolean validateSetType_checkCollectionTypeName(SetType<?, ?> setType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateTupleType(TupleType<?, ?> tupleType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validate_EveryMultiplicityConforms(tupleType, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(tupleType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(tupleType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(tupleType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(tupleType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(tupleType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(tupleType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTupleType_checkTupleTypeName(tupleType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTupleType_checkPartNamesUnique(tupleType, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTupleType_checkFeaturesOnlyProperties(tupleType, diagnostics, context);
        }
        return result;
    }

    public boolean validateTupleType_checkTupleTypeName(TupleType<?, ?> tupleType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return tupleType.checkTupleTypeName(diagnostics, context);
    }

    public boolean validateTupleType_checkPartNamesUnique(TupleType<?, ?> tupleType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return tupleType.checkPartNamesUnique(diagnostics, context);
    }

    public boolean validateTupleType_checkFeaturesOnlyProperties(TupleType<?, ?> tupleType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return tupleType.checkFeaturesOnlyProperties(diagnostics, context);
    }

    public boolean validateTypeType(TypeType<?, ?> typeType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(typeType, diagnostics, context);
    }

    public boolean validateVoidType(VoidType<?> voidType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(voidType, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return OCLPlugin.INSTANCE;
    }
}

