/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvtc.analysis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.QVTrNameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.analysis.TransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvtc.trace.RelationalTransformation2TracePackage;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationHelper;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;

public class RelationAnalysis
extends QVTrelationHelper {
    protected final @NonNull TransformationAnalysis transformationAnalysis;
    protected final @NonNull Relation relation;
    private @NonNull List<@NonNull VariableDeclaration> rootVariables = new ArrayList<VariableDeclaration>();
    private @Nullable List<@NonNull RelationCallExp> incomingInvocations = null;
    private @Nullable List<@NonNull RelationCallExp> incomingWhenInvocations = null;
    private @Nullable List<@NonNull RelationCallExp> incomingWhereInvocations = null;
    private @Nullable List<@NonNull RelationCallExp> outgoingInvocations = null;
    private @Nullable List<@NonNull RelationCallExp> outgoingWhenInvocations = null;
    private @Nullable List<@NonNull RelationCallExp> outgoingWhereInvocations = null;
    private @Nullable Set<@NonNull RelationAnalysis> overridingRelationAnalyses = null;

    public RelationAnalysis(@NonNull TransformationAnalysis transformationAnalysis, @NonNull Relation relation) {
        super(transformationAnalysis.getEnvironmentFactory());
        this.transformationAnalysis = transformationAnalysis;
        this.relation = relation;
    }

    private void addIncomingRelation(@NonNull RelationCallExp relationInvocation) {
        List<@NonNull RelationCallExp> incomingInvocations2 = this.incomingInvocations;
        if (incomingInvocations2 == null) {
            this.incomingInvocations = incomingInvocations2 = new ArrayList<RelationCallExp>();
        }
        incomingInvocations2.add(relationInvocation);
    }

    private void addIncomingWhenRelation(@NonNull RelationCallExp relationInvocation) {
        List<@NonNull RelationCallExp> incomingWhenInvocations2 = this.incomingWhenInvocations;
        if (incomingWhenInvocations2 == null) {
            this.incomingWhenInvocations = incomingWhenInvocations2 = new ArrayList<RelationCallExp>();
        }
        incomingWhenInvocations2.add(relationInvocation);
    }

    private void addIncomingWhereRelation(@NonNull RelationCallExp relationInvocation) {
        List<@NonNull RelationCallExp> incomingWhereInvocations2 = this.incomingWhereInvocations;
        if (incomingWhereInvocations2 == null) {
            this.incomingWhereInvocations = incomingWhereInvocations2 = new ArrayList<RelationCallExp>();
        }
        incomingWhereInvocations2.add(relationInvocation);
    }

    private void addOutgoingRelation(@NonNull RelationCallExp relationInvocation) {
        List<@NonNull RelationCallExp> outgoingInvocations2 = this.outgoingInvocations;
        if (outgoingInvocations2 == null) {
            this.outgoingInvocations = outgoingInvocations2 = new ArrayList<RelationCallExp>();
        }
        outgoingInvocations2.add(relationInvocation);
    }

    private void addOutgoingWhenRelation(@NonNull RelationCallExp relationInvocation) {
        List<@NonNull RelationCallExp> outgoingWhenInvocations2 = this.outgoingWhenInvocations;
        if (outgoingWhenInvocations2 == null) {
            this.outgoingWhenInvocations = outgoingWhenInvocations2 = new ArrayList<RelationCallExp>();
        }
        outgoingWhenInvocations2.add(relationInvocation);
    }

    private void addOutgoingWhereRelation(@NonNull RelationCallExp relationInvocation) {
        List<@NonNull RelationCallExp> outgoingWhereInvocations2 = this.outgoingWhereInvocations;
        if (outgoingWhereInvocations2 == null) {
            this.outgoingWhereInvocations = outgoingWhereInvocations2 = new ArrayList<RelationCallExp>();
        }
        outgoingWhereInvocations2.add(relationInvocation);
    }

    private boolean addOverridingRelation(@NonNull RelationAnalysis overridingRelationAnalysis) {
        assert (overridingRelationAnalysis != this);
        Set<@NonNull RelationAnalysis> overridingRelationAnalyses2 = this.overridingRelationAnalyses;
        if (overridingRelationAnalyses2 == null) {
            this.overridingRelationAnalyses = overridingRelationAnalyses2 = new HashSet<RelationAnalysis>();
        }
        return overridingRelationAnalyses2.add(overridingRelationAnalysis);
    }

    public void analyze() {
        this.analyzeInvocations();
        this.analyzeRootVariables();
        this.analyzeOverriddens();
    }

    protected void analyzeInvocations() {
        Pattern wherePattern;
        for (EObject eObject : new TreeIterable((EObject)this.relation, true)) {
            if (!(eObject instanceof RelationCallExp)) continue;
            RelationCallExp relationInvocation = (RelationCallExp)eObject;
            Relation invokedRelation = QVTrelationUtil.getReferredRelation((RelationCallExp)relationInvocation);
            RelationAnalysis invokedRelationAnalysis = this.transformationAnalysis.getRelationAnalysis(invokedRelation);
            RelationAnalysis invokingRelationAnalysis = this;
            invokedRelationAnalysis.addIncomingRelation(relationInvocation);
            invokingRelationAnalysis.addOutgoingRelation(relationInvocation);
        }
        Pattern whenPattern = this.relation.getWhen();
        if (whenPattern != null) {
            this.analyzeInvocations(whenPattern, true);
        }
        if ((wherePattern = this.relation.getWhere()) != null) {
            this.analyzeInvocations(wherePattern, false);
        }
    }

    protected void analyzeInvocations(@NonNull Pattern pattern, boolean isWhen) {
        for (Predicate predicate : QVTrelationUtil.getOwnedPredicates((Pattern)pattern)) {
            OCLExpression predicateExpression = predicate.getConditionExpression();
            if (!(predicateExpression instanceof RelationCallExp)) continue;
            RelationCallExp relationInvocation = (RelationCallExp)predicateExpression;
            Relation invokedRelation = QVTrelationUtil.getReferredRelation((RelationCallExp)relationInvocation);
            RelationAnalysis invokedRelationAnalysis = this.transformationAnalysis.getRelationAnalysis(invokedRelation);
            RelationAnalysis invokingRelationAnalysis = this;
            if (isWhen) {
                invokedRelationAnalysis.addIncomingWhenRelation(relationInvocation);
                invokingRelationAnalysis.addOutgoingWhenRelation(relationInvocation);
                continue;
            }
            invokedRelationAnalysis.addIncomingWhereRelation(relationInvocation);
            invokingRelationAnalysis.addOutgoingWhereRelation(relationInvocation);
        }
    }

    protected void analyzeOverriddens() {
        Relation anOverriddenRelation = this.relation;
        while (anOverriddenRelation != null) {
            RelationAnalysis overriddenRelationAnalysis;
            if (anOverriddenRelation != this.relation && !(overriddenRelationAnalysis = this.transformationAnalysis.getRelationAnalysis(anOverriddenRelation)).addOverridingRelation(this)) break;
            anOverriddenRelation = QVTrelationUtil.basicGetOverridden((Relation)anOverriddenRelation);
        }
    }

    protected void analyzeRootVariables() {
        for (RelationDomain rDomain : QVTrelationUtil.getOwnedDomains((Relation)this.relation)) {
            for (DomainPattern rDomainPattern : QVTrelationUtil.getOwnedPatterns((RelationDomain)rDomain)) {
                TemplateExp rRootTemplateExpression = rDomainPattern.getTemplateExpression();
                if (rRootTemplateExpression == null) continue;
                this.rootVariables.add((VariableDeclaration)QVTrelationUtil.getBindsTo((TemplateExp)rRootTemplateExpression));
            }
        }
    }

    public @Nullable Iterable<@NonNull RelationCallExp> getIncomingInvocations() {
        return this.incomingInvocations;
    }

    public @Nullable Iterable<@NonNull RelationCallExp> getIncomingWhenInvocations() {
        return this.incomingWhenInvocations;
    }

    public @Nullable Iterable<@NonNull RelationCallExp> getIncomingWhereInvocations() {
        return this.incomingWhereInvocations;
    }

    public @NonNull QVTrNameGenerator getNameGenerator() {
        return this.getRelationalTransformation2TracePackage().getNameGenerator();
    }

    public @Nullable Iterable<@NonNull RelationCallExp> getOutgoingInvocations() {
        return this.outgoingInvocations;
    }

    public @Nullable Iterable<@NonNull RelationCallExp> getOutgoingWhenInvocations() {
        return this.outgoingWhenInvocations;
    }

    public @Nullable Iterable<@NonNull RelationCallExp> getOutgoingWhereInvocations() {
        return this.outgoingWhereInvocations;
    }

    public @NonNull Relation getRelation() {
        return this.relation;
    }

    public @Nullable Iterable<@NonNull RelationAnalysis> getOverridingRelationAnalyses() {
        return this.overridingRelationAnalyses;
    }

    public @NonNull RelationalTransformation2TracePackage getRelationalTransformation2TracePackage() {
        return this.transformationAnalysis.getRelationalTransformation2TracePackage();
    }

    public @NonNull List<@NonNull VariableDeclaration> getRootVariables() {
        return this.rootVariables;
    }

    public @NonNull TransformationAnalysis getTransformationAnalysis() {
        return this.transformationAnalysis;
    }

    public @NonNull String toString() {
        return String.valueOf(this.relation);
    }

    public boolean traceIsRealized() {
        if (this.relation.isIsTopLevel()) {
            return true;
        }
        return this.relation.getOverridden() != null || !this.relation.getOverrides().isEmpty();
    }
}

